
/*  A Bison parser, made from samuel.y with Bison version GNU Bison version 1.22
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	TOK_ARROW	258
#define	TOK_SHIFT	259
#define	TOK_DBL_ARROW	260
#define	TOK_SC_NL	261
#define	TOK_MODULO	262
#define	TOK_PRINT_VARS	263
#define	IDENT	264
#define	INTEGER	265
#define	QSTRING	266
#define	UNARY_OP	267

#line 10 "samuel.y"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "saml.h"
#include "samuel.h"

#define yyerror(s)	fprintf(stderr, "samuel: %s\n", s)

static void repeat_subs (mref_t expr, mref_t e1, mref_t e2)
{
	int error;
	mref_t save = mref_new();
	
	do {
		mref_copy(save, expr);
		error = mref_subs(expr, expr, e1, e2);
	}
	while (!error && mref_differ(save,expr));
	mref_free(save);
}

static void do_binary_op (char c)
{
	mref_t e2 = pop_mref();
	mref_t e1 = pop_mref();

	switch(c) {
	    case '+':	mref_add(e1, e1, e2); break;
	    case '-':	mref_sub(e1, e1, e2); break;
	    case '*':	mref_mul(e1, e1, e2); break;
	    case '/':	mref_div(e1, e1, e2); break;
	    case '&':	mref_gcd(e1, e1, e2); break;
	    case ':':	mref_diff(e1, e1, e2); break;
	    default:	panic("impossible binary operator");
	}
	push_mref(e1); mref_free(e2);
}


#line 51 "samuel.y"
typedef union {
	int integer;
	char* string;
} YYSTYPE;

#ifndef YYLTYPE
typedef
  struct yyltype
    {
      int timestamp;
      int first_line;
      int first_column;
      int last_line;
      int last_column;
      char *text;
   }
  yyltype;

#define YYLTYPE yyltype
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		93
#define	YYFLAG		-32768
#define	YYNTBASE	31

#define YYTRANSLATE(x) ((unsigned)(x) <= 267 ? yytranslate[x] : 46)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    27,     2,     2,     2,     2,    13,     2,    28,
    29,    16,    14,    23,    15,    17,    18,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    21,    22,     2,
    12,     2,    25,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,    24,     2,    20,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,    26,     2,    30,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    19
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     1,     4,     8,    10,    12,    13,    15,    17,    19,
    21,    27,    33,    39,    41,    45,    47,    49,    52,    55,
    58,    60,    64,    68,    69,    71,    73,    75,    77,    79,
    83,    85,    87,    89,    91,    99,   104,   108,   112,   116,
   120,   124,   128,   132,   136,   144,   147,   150,   154
};

static const short yyrhs[] = {    -1,
    31,     8,     0,    31,    33,    32,     0,    22,     0,     6,
     0,     0,    44,     0,    45,     0,     1,     0,    43,     0,
    34,    23,    43,     3,    43,     0,    34,    23,    43,     4,
    43,     0,    34,    23,     9,     5,     9,     0,    43,     0,
    35,    23,    43,     0,    10,     0,     9,     0,    24,     9,
     0,    25,     9,     0,    20,     9,     0,    11,     0,    26,
    35,    26,     0,     9,    27,    10,     0,     0,    35,     0,
    36,     0,    38,     0,    37,     0,    39,     0,    28,    34,
    29,     0,    44,     0,    45,     0,    42,     0,    40,     0,
    30,    42,    28,    43,    23,    43,    29,     0,     9,    28,
    41,    29,     0,    43,    14,    43,     0,    43,    15,    43,
     0,    43,    16,    43,     0,    43,    17,    43,     0,    43,
    18,    43,     0,    43,    13,    43,     0,    43,    21,    42,
     0,    43,    20,    10,     0,    43,     7,    28,    43,    23,
    43,    29,     0,    15,    43,     0,    14,    43,     0,     9,
    12,    43,     0,    11,    12,    43,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
    71,    72,    73,    75,    76,    79,    80,    97,   103,   106,
   107,   116,   125,   138,   139,   142,   153,   159,   166,   172,
   181,   189,   197,   211,   212,   215,   216,   217,   218,   219,
   222,   222,   224,   225,   226,   235,   236,   237,   238,   239,
   240,   241,   242,   243,   249,   251,   257,   261,   267
};

static const char * const yytname[] = {   "$","error","$illegal.","TOK_ARROW",
"TOK_SHIFT","TOK_DBL_ARROW","TOK_SC_NL","TOK_MODULO","TOK_PRINT_VARS","IDENT",
"INTEGER","QSTRING","'='","'&'","'+'","'-'","'*'","'.'","'/'","UNARY_OP","'^'",
"':'","';'","','","'\\\\'","'?'","'|'","'!'","'('","')'","'~'","lines","semicolon",
"line","nested_expr","expr_list","integer_expr","ident_expr","file_expr","det_expr",
"simple_tensor","optional_expr_list","primary","expr","printable_expr","assignment_expr",
""
};
#endif

static const short yyr1[] = {     0,
    31,    31,    31,    32,    32,    33,    33,    33,    33,    34,
    34,    34,    34,    35,    35,    36,    37,    37,    37,    37,
    38,    39,    40,    41,    41,    42,    42,    42,    42,    42,
    43,    43,    44,    44,    44,    44,    44,    44,    44,    44,
    44,    44,    44,    44,    44,    44,    44,    45,    45
};

static const short yyr2[] = {     0,
     0,     2,     3,     1,     1,     0,     1,     1,     1,     1,
     5,     5,     5,     1,     3,     1,     1,     2,     2,     2,
     1,     3,     3,     0,     1,     1,     1,     1,     1,     3,
     1,     1,     1,     1,     7,     4,     3,     3,     3,     3,
     3,     3,     3,     3,     7,     2,     2,     3,     3
};

static const short yydefact[] = {     1,
     0,     9,     2,    17,    16,    21,     0,     0,     0,     0,
     0,     0,     0,     0,     0,    26,    28,    27,    29,    34,
    33,     0,    31,    32,     0,     0,    24,     0,    47,    31,
    32,    46,    20,    18,    19,     0,    14,     0,    10,    17,
    21,     0,     5,     4,     3,     0,     0,     0,     0,     0,
     0,     0,     0,     0,    48,    23,    25,     0,    49,     0,
    22,     0,    30,     0,     0,    42,    37,    38,    39,    40,
    41,    44,    43,    36,    15,    17,     0,     0,     0,     0,
     0,     0,     0,     0,    13,    11,    12,     0,     0,    35,
    45,     0,     0
};

static const short yydefgoto[] = {     1,
    45,    15,    38,    36,    16,    17,    18,    19,    20,    58,
    21,    37,    30,    31
};

static const short yypact[] = {-32768,
     8,-32768,-32768,    -7,-32768,   -10,    85,    85,    -5,     2,
    26,    85,    85,   114,     7,-32768,-32768,-32768,-32768,-32768,
-32768,   176,     9,    31,    85,    32,    85,    85,    34,-32768,
-32768,    34,-32768,-32768,-32768,    17,   176,    16,   176,-32768,
-32768,    24,-32768,-32768,-32768,    28,    85,    85,    85,    85,
    85,    85,    47,   114,   176,-32768,    21,    29,   176,    85,
-32768,   107,-32768,    85,    85,   184,    86,    86,    34,    34,
    34,-32768,-32768,-32768,   176,    -2,   140,   152,   164,    51,
    85,    85,    85,    85,-32768,   176,   176,    55,    72,-32768,
-32768,    65,-32768
};

static const short yypgoto[] = {-32768,
-32768,-32768,-32768,    39,-32768,-32768,-32768,-32768,-32768,-32768,
   -13,    -1,    66,    73
};


#define	YYLAST		205


static const short yytable[] = {    22,
    42,    28,    80,    33,    25,    29,    32,    92,     2,    25,
    34,    39,    43,    -6,    -7,     3,     4,     5,     6,    26,
    27,     7,     8,    55,    26,    27,    59,     9,    44,    -6,
    -7,    10,    11,    12,    35,    13,    -8,    14,    62,    60,
    73,    56,    61,    60,    63,    66,    67,    68,    69,    70,
    71,    64,    -8,    53,    54,    65,    72,    74,    75,    85,
    77,    46,    78,    79,    93,    57,    23,    47,    48,    49,
    50,    51,    52,    24,    53,    54,     0,     0,    46,    86,
    87,    88,    89,    90,    47,    48,    49,    50,    51,    52,
     0,    53,    54,     4,     5,     6,     0,     0,     7,     8,
    91,    50,    51,    52,     9,    53,    54,     0,    10,    11,
    12,     0,    13,     0,    14,    76,     5,     6,     0,     0,
     7,     8,    40,     5,    41,     0,     9,     0,     0,     0,
    10,    11,    12,     9,    13,     0,    14,    10,    11,    12,
     0,    13,    81,    82,     0,     0,    46,     0,     0,     0,
     0,     0,    47,    48,    49,    50,    51,    52,    46,    53,
    54,     0,     0,     0,    47,    48,    49,    50,    51,    52,
    46,    53,    54,     0,    83,     0,    47,    48,    49,    50,
    51,    52,    46,    53,    54,     0,    84,     0,    47,    48,
    49,    50,    51,    52,     0,    53,    54,    48,    49,    50,
    51,    52,     0,    53,    54
};

static const short yycheck[] = {     1,
    14,    12,     5,     9,    12,     7,     8,     0,     1,    12,
     9,    13,     6,     6,     6,     8,     9,    10,    11,    27,
    28,    14,    15,    25,    27,    28,    28,    20,    22,    22,
    22,    24,    25,    26,     9,    28,     6,    30,    23,    23,
    54,    10,    26,    23,    29,    47,    48,    49,    50,    51,
    52,    28,    22,    20,    21,    28,    10,    29,    60,     9,
    62,     7,    64,    65,     0,    27,     1,    13,    14,    15,
    16,    17,    18,     1,    20,    21,    -1,    -1,     7,    81,
    82,    83,    84,    29,    13,    14,    15,    16,    17,    18,
    -1,    20,    21,     9,    10,    11,    -1,    -1,    14,    15,
    29,    16,    17,    18,    20,    20,    21,    -1,    24,    25,
    26,    -1,    28,    -1,    30,     9,    10,    11,    -1,    -1,
    14,    15,     9,    10,    11,    -1,    20,    -1,    -1,    -1,
    24,    25,    26,    20,    28,    -1,    30,    24,    25,    26,
    -1,    28,     3,     4,    -1,    -1,     7,    -1,    -1,    -1,
    -1,    -1,    13,    14,    15,    16,    17,    18,     7,    20,
    21,    -1,    -1,    -1,    13,    14,    15,    16,    17,    18,
     7,    20,    21,    -1,    23,    -1,    13,    14,    15,    16,
    17,    18,     7,    20,    21,    -1,    23,    -1,    13,    14,
    15,    16,    17,    18,    -1,    20,    21,    14,    15,    16,
    17,    18,    -1,    20,    21
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/lib/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Bob Corbett and Richard Stallman

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#else /* not MSDOS, __TURBOC__, or _AIX */
#ifdef __hpux
#ifdef __cplusplus
extern "C" {
void *alloca (unsigned int);
};
#else /* not __cplusplus */
void *alloca ();
#endif /* not __cplusplus */
#endif /* __hpux */
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#define YYLEX		yylex(&yylval, &yylloc)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
int yyparse (void);
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_bcopy(FROM,TO,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (from, to, count)
     char *from;
     char *to;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (char *from, char *to, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 184 "/usr/lib/bison.simple"
int
yyparse()
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_bcopy ((char *)yyss1, (char *)yyss, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_bcopy ((char *)yyvs1, (char *)yyvs, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_bcopy ((char *)yyls1, (char *)yyls, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 2:
#line 72 "samuel.y"
{ list_variables(); ;
    break;}
case 4:
#line 75 "samuel.y"
{ /* no action */    ;
    break;}
case 5:
#line 76 "samuel.y"
{ print_cpu_usage(); ;
    break;}
case 7:
#line 81 "samuel.y"
{
	    	mref_t top = pop_mref();
	    	FILE *fp;

		if (post_processor && (fp = popen(post_processor,"w"))) {
		    	fputs(mref_string(top), fp);
		    	fputc('\n', fp);
			pclose(fp);
		}
		else {
			puts(mref_string(top));
			fflush(stdout);
		}
	    	assign_to_variable("last",top);
	    	mref_free(top);
	    ;
    break;}
case 8:
#line 98 "samuel.y"
{
	    	mref_t top = pop_mref();
	    	assign_to_variable("last",top);
	    	mref_free(top);
	    ;
    break;}
case 9:
#line 103 "samuel.y"
{ clean_stack(); ;
    break;}
case 11:
#line 108 "samuel.y"
{
	    	mref_t e3 = pop_mref();
	    	mref_t e2 = pop_mref();
	    	mref_t e1 = pop_mref();
	    	
	    	mref_subs(e1, e1, e2, e3);
	    	push_mref(e1); mref_free(e2); mref_free(e3);
	    ;
    break;}
case 12:
#line 117 "samuel.y"
{
	    	mref_t e3 = pop_mref();
	    	mref_t e2 = pop_mref();
	    	mref_t e1 = pop_mref();
	    	
	    	repeat_subs(e1, e2, e3);
	    	push_mref(e1); mref_free(e2); mref_free(e3);
	    ;
    break;}
case 13:
#line 126 "samuel.y"
{
	    	mref_t l1 = mref_new();
	    	mref_t l2 = mref_new();
	    	mref_t ne = pop_mref();

	    	mref_build(l1, ST_LITERAL, yyvsp[-2].string); free(yyvsp[-2].string);
	    	mref_build(l2, ST_LITERAL, yyvsp[0].string); free(yyvsp[0].string);
	    	mref_move_lit(ne ,ne, l1, l2);
	    	push_mref(ne); mref_free(l1); mref_free(l2);
	    ;
    break;}
case 14:
#line 138 "samuel.y"
{ yyval.integer=1; ;
    break;}
case 15:
#line 139 "samuel.y"
{ ++yyval.integer; ;
    break;}
case 16:
#line 143 "samuel.y"
{
	    	/* Returns the integer as a polynomial */
		mref_t number = mref_new();
		
		mref_build(number, ST_INTEGER, yyvsp[0].string);
		mref_promote(number, mr_model);
		free(yyvsp[0].string); push_mref(number);
	    ;
    break;}
case 17:
#line 154 "samuel.y"
{
	    	mref_t mr = mref_new();
	    	read_identifier(mr,yyvsp[0].string);
	    	free(yyvsp[0].string); push_mref(mr);
	    ;
    break;}
case 18:
#line 160 "samuel.y"
{
	    	mref_t mr = mref_new();
	    	mref_build(mr, ST_LITERAL, yyvsp[0].string);
	    	mref_promote(mr, mr_model);
	    	free(yyvsp[0].string); push_mref(mr);
	    ;
    break;}
case 19:
#line 167 "samuel.y"
{
	    	mref_t mr = mref_new();
	    	read_variable(mr,yyvsp[0].string);
	    	free(yyvsp[0].string); push_mref(mr);
	    ;
    break;}
case 20:
#line 173 "samuel.y"
{
	    	mref_t mr = mref_new();
	    	read_variable(mr,yyvsp[0].string);
	    	destroy_variable(yyvsp[0].string);
	    	free(yyvsp[0].string); push_mref(mr);
	    ;
    break;}
case 21:
#line 182 "samuel.y"
{
	    	mref_t mr = mref_new();
	    	read_mref_from_file(mr,yyvsp[0].string);
	    	free(yyvsp[0].string); push_mref(mr);
	    ;
    break;}
case 22:
#line 190 "samuel.y"
{
	    	mref_t top = make_square_matrix(yyvsp[-1].integer);
	    	mref_det(top, top);
	    	push_mref(top);
	    ;
    break;}
case 23:
#line 198 "samuel.y"
{
	    	mref_t mr = mref_new();
	    	char *buff = realloc(yyvsp[-2].string, strlen(yyvsp[-2].string)+strlen(yyvsp[0].string)+2);

	    	if (!buff) panic("out of memory");
	    	strcat(buff, "!");
	    	strcat(buff, yyvsp[0].string); free(yyvsp[0].string);
	    	mref_build(mr, ST_TENSOR, buff); free(buff);
	    	mref_promote(mr, mr_model);
	    	push_mref(mr);
	    ;
    break;}
case 24:
#line 211 "samuel.y"
{ yyval.integer = 0; ;
    break;}
case 25:
#line 212 "samuel.y"
{ yyval.integer = yyvsp[0].integer; ;
    break;}
case 30:
#line 219 "samuel.y"
{ ;
    break;}
case 35:
#line 227 "samuel.y"
{
	    	mref_t e3 = pop_mref();
	    	mref_t e2 = pop_mref();
	    	mref_t e1 = pop_mref();

	    	mref_elim(e1, e1, e2, e3);
	    	push_mref(e1); mref_free(e2); mref_free(e3);
	    ;
    break;}
case 36:
#line 235 "samuel.y"
{ execute_function(yyvsp[-3].string,yyvsp[-1].integer); ;
    break;}
case 37:
#line 236 "samuel.y"
{ do_binary_op('+'); ;
    break;}
case 38:
#line 237 "samuel.y"
{ do_binary_op('-'); ;
    break;}
case 39:
#line 238 "samuel.y"
{ do_binary_op('*'); ;
    break;}
case 40:
#line 239 "samuel.y"
{ do_binary_op('*'); ;
    break;}
case 41:
#line 240 "samuel.y"
{ do_binary_op('/'); ;
    break;}
case 42:
#line 241 "samuel.y"
{ do_binary_op('&'); ;
    break;}
case 43:
#line 242 "samuel.y"
{ do_binary_op(':'); ;
    break;}
case 44:
#line 244 "samuel.y"
{
	    	mref_t top = pop_mref();
	    	mref_power(top, top, atoi(yyvsp[0].string));
	    	free(yyvsp[0].string); push_mref(top);
	    ;
    break;}
case 45:
#line 250 "samuel.y"
{ execute_function("modulo", 3); ;
    break;}
case 46:
#line 252 "samuel.y"
{
	    	mref_t top = pop_mref();
	    	mref_negate(top, top);
	    	push_mref(top);
	    ;
    break;}
case 47:
#line 258 "samuel.y"
{ /* Nothing to do */ ;
    break;}
case 48:
#line 262 "samuel.y"
{
	    	mref_t top = pop_mref();
	    	assign_to_variable(yyvsp[-2].string, top);
	    	free(yyvsp[-2].string); push_mref(top);
	    ;
    break;}
case 49:
#line 268 "samuel.y"
{
	    	mref_t top = pop_mref();
	    	write_mref_to_file(yyvsp[-2].string, top);
	    	free(yyvsp[-2].string); push_mref(top);
	    ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 465 "/usr/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 274 "samuel.y"
