/*
 * s390-tools/zt_error/zt_error.c
 *   Error handling functions for s390 tools.
 *
 * (C) Copyright IBM Corp. 2004
 *
 * Author(s): Gerhard Tonn (ton@de.ibm.com)
 */

#include <stdio.h>
#include <stdarg.h>

#include "zt_error.h"

/* Error message string */
#define ERROR_STRING_SIZE       1024
static char error_string[ERROR_STRING_SIZE];

/*
 * Generate and print an error message based on the formatted
 * text string FMT and a variable amount of extra arguments. 
 */
void
zt_error_print (const char* fmt, ...)
{
	va_list args;

	va_start (args, fmt);
	vsnprintf (error_string, ERROR_STRING_SIZE, fmt, args);
	va_end (args);

	fprintf (stderr, "Error: %s\n", error_string);
}

