extern crate futures;

mod support;

use futures::stream;

use support::*;

#[test]
fn unfold1() {
    let mut stream = stream::unfold(0, |state| {
        if state <= 2 {
            let res: Result<_,()> = Ok((state * 2, state + 1));
            Some(delay_future(res))
        } else {
            None
        }
    });
    // Creates the future with the closure
    // Not ready (delayed future)
    sassert_empty(&mut stream);
    // future is ready, yields the item
    sassert_next(&mut stream, 0);

    // Repeat
    sassert_empty(&mut stream);
    sassert_next(&mut stream, 2);

    sassert_empty(&mut stream);
    sassert_next(&mut stream, 4);

    // no more items
    sassert_done(&mut stream);
}

#[test]
fn unfold_err1() {
    let mut stream = stream::unfold(0, |state| {
        if state <= 2 {
            Some(Ok((state * 2, state + 1)))
        } else {
            Some(Err(-1))
        }
    });
    sassert_next(&mut stream, 0);
    sassert_next(&mut stream, 2);
    sassert_next(&mut stream, 4);
    sassert_err(&mut stream, -1);

    // An error was generated by the stream, it will then finish
    sassert_done(&mut stream);
}
