#include <rumba/parse.h>
#include <fstream>

using std::cout;
using std::endl;
using std::string;
using namespace RUMBA;
void test_parse_rc_line()
{
	string line1 = " line1 = blah  \n";
   	string line2 = " foo  = bar ";
   	string line3 = " foobar    	= x y \n";

	string key,val;

	parseRcLine(line1,key,val);
	if ( key == "line1" && val == "blah" )
		cout << "OK" << endl;
	else 
		cout << "Not OK, key, val should be line1,blah, but are \"" << key << "\", \"" << val << "\"" << endl;

	parseRcLine(line2,key,val);
	if ( key == "foo" && val == "bar" )
		cout << "OK" << endl;
	else 
		cout << "Not OK, key, val should be foo,bar, but are \"" << key << "\", \"" << val << "\"" << endl;

	parseRcLine(line3,key,val);
	if ( key == "foobar" && val == "x y" )
		cout << "OK" << endl;
	else 
		cout << "Not OK, key, val should be foobar,\"x y\", but are \"" << key << "\", \"" << val << "\"" << endl;


}

void test_strip_helper(std::string test)
{
	if ( test == "hello world" )
		cout << "OK" << endl;
	else
		cout << "Not OK, got \"" << test << endl;
}

void test_strip()
{
	string test = "	  hello world ";
	strip(test);
	test_strip_helper(test);

	test = "	  hello world";
	strip(test);
	test_strip_helper(test);

	test = "hello world";
	strip(test);
	test_strip_helper(test);


}



void test_rcFind()
{

	string rcString = " line1 = blah  \n foo  = bar \n foobar    	= x y \n";
	std::istringstream in(rcString);
//	std::ifstream in ("test.dat");
	string val;

	if ( ! rcFind ( in,"line1", val ) ) cout << "rcFind() returned false!" << endl;
	if ( val == "blah" ) { cout << "OK" << endl; } else { cout << "Not OK, val = \"" << val << "\"" << endl; }

	if ( ! rcFind ( in,"foo", val )) cout << "rcFind() returned false!" << endl;
	if ( val == "bar" ) { cout << "OK" << endl; } else { cout << "Not OK, val = \"" << val << "\"" << endl; }

	if ( ! rcFind ( in, "foobar", val )) cout << "rcFind() returned false!" << endl;
	if ( val == "x y" ) { cout << "OK" << endl; } else { cout << "Not OK, val = \"" << val << "\"" << endl; }
}



int main()
{
	cout << "Testing parse_rc_line" << endl;
	test_parse_rc_line();

	cout << "Testing strip()" << endl;
	test_strip();

	cout << "Testing rcFind()" << endl;
	test_rcFind();

}

