dnl
dnl		Set up prefix and rumba directory
dnl

AC_DEFUN(RUMBA_SETUP_PREFIX,
[
AC_ARG_WITH(rumba-dir,
	[	--with-rumba-dir=DIR	where the rumba installation is located ],
	[ 	echo [Rumba directory: "$withval"]
		rumba_dir="$withval"
])
if test "x$rumba_dir" = "x" 
then
	echo "Looking for rumba installation"
	for X in /usr/local /usr /opt  $HOME
	do
		if test -d $X/rumba && test -e $X/rumba/include/manifold.h
		then
			rumba_dir=$X/rumba;
			echo "Found: $X/rumba"
		fi
	done
else
	echo "Rumba dir is $rumba_dir"
fi

if test "x" != "x$rumba_dir"
then
		rumba_includes="-I$rumba_dir/include"
		rumba_libraries="-L$rumba_dir/lib -lrumba -lnetcdf"
		rumba_demos="$rumba_dir"/bin
		if test -n "`echo $rumba_dir|grep rumba`"; then
			rumba_data=$rumba_dir/share
		else
			rumba_data=$rumba_dir/share/rumba
		fi
fi

if test "x" = "x$rumba_dir"
then
	echo "failed to find rumba directory"
	echo "please specify by using"
	echo "--with-rumba-dir directory"
	exit 1
fi

if test "x$prefix" = "xNONE" ; then
	if test "x$rumba_dir" = "x"; then
		prefix=$ac_default_prefix
	else
		prefix=$rumba_dir
	fi
	ac_configure_args="$ac_configure_args --prefix $prefix"
fi




])



AC_DEFUN(RUMBA_INCLUDES,[

AC_ARG_WITH(rumba-includes,
[	--with-rumba-includes=DIR Where rumba include header files are located ],
[	echo [Rumba directory: "$withval"]
	rumba_includes="-I$withval"
])


])


AC_DEFUN(RUMBA_CHECK_IOS_BASE_OPENMODE,[
	AC_MSG_CHECKING("std::ios_base::openmode")
	AC_TRY_LINK(
		[
			#include <iostream>
		],
		[ 
			std::ios_base::openmode x; 
		],
		[
			have_ios_base_openmode=yes
			AC_DEFINE(HAVE_IOS_BASE_OPENMODE)
		],
		have_ios_base_openmode=no
	)

	]
	AC_MSG_RESULT($have_ios_base_openmode)
)
