#ifndef RUMBA_MANIFOLDMATRIX_H
#define RUMBA_MANIFOLDMATRIX_H

/**
  * \file manifoldmatrix.h
  * \author Donovan Rebbechi, Ben Bly, Giorgio Grasso
  * Copyright Ben Bly
  * This file is released under the artistic license. See the file COPYING
  * for details.
  */

#include <rumba/manifold.h>
#include <rumba/matrix.hpp>

namespace RUMBA
{
class manifold_generator;

typedef Matrix<Manifold<double>,Manifold<double>::iterator,manifold_generator>	
ManifoldMatrix; 

ManifoldMatrix
makeProductManifold(const Manifold<double>& left, const Manifold<double>& right);

ManifoldMatrix pseudoInvert(const ManifoldMatrix& M);

class manifold_generator
{
	public:
		manifold_generator(){}
		ManifoldMatrix operator() (const ManifoldMatrix& left, const ManifoldMatrix& right);
		ManifoldMatrix operator() (const ManifoldMatrix& );
		ManifoldMatrix operator() (unsigned int r, unsigned int c);
};

ManifoldMatrix makeMatrix(Manifold<double> M, bool transpose);
ManifoldMatrix makeMatrix(Manifold<double> M);
ManifoldMatrix makeMatrix(int i , int j);

ManifoldMatrix identityMatrix(int n);

ManifoldMatrix getRow ( const ManifoldMatrix& Mm, int r );

} // namespace RUMBA

#endif
