#include <rumba/point.hpp>
#include <sstream>
#include <iostream>
#include <fstream>

#include <rumba/matrixio.h>
#include <rumba/manifoldmatrix.h>
#include <rumba/parse.h>

using std::vector;
using std::cout;

int RUMBA::countcolumns(std::string s)
{
	int count=0;
	double tmp;


	std::istringstream in(s);

	while (in>>tmp)
	{
		++count;
	}

	return count;
}

bool RUMBA::hasDouble(std::string s)
{
	double tmp;
	std::istringstream in(s);
	if (in>>tmp)
		return true;
	else
		return false;
}





int RUMBA::getRow ( std::string line, vector<double>& v )
{
	int c = 0;
	double tmp;
	std::istringstream strin(line);
	while ( strin >> tmp )
	{
		++c;
		v.push_back(tmp);
	}
	return c;
}


// RUMBA::Manifold<double> RUMBA::loadAsciiManifold(std::istream& in)
RUMBA::ManifoldMatrix RUMBA::readManifoldMatrix(std::istream& in=std::cin)

{
	Manifold<double> M = loadAsciiManifold(in);

	RUMBA::ManifoldMatrix Mm ( makeMatrix(M) );
	return Mm;
}

RUMBA::Manifold<double> RUMBA::loadAsciiManifold(const char* filename)
{
	std::ifstream fin (filename);
	return loadAsciiManifold(fin);
}

RUMBA::ManifoldMatrix RUMBA::readManifoldMatrix(const char* filename)
{
	std::ifstream fin (filename);
	return readManifoldMatrix(fin);
}


// RUMBA::ManifoldMatrix RUMBA::readManifoldMatrix(std::istream& in=std::cin)
RUMBA::Manifold<double> RUMBA::loadAsciiManifold(std::istream& in)

{
	std::string line;
	std::vector<double> v;
	int cols = 0;
	int rows = 0;
	int tmp;


	// skip blank lines or lines that don't begin with a double.
	while ( getline ( in, line )  && ! hasDouble(line) )
		;


	if ( in )
		cols = countcolumns(line);
	else 
		throw RUMBA::BadFile ( std::string("No matrix data found in data stream") );

	rows = 0;

	do {
		if ( hasDouble(line) && ++rows && (tmp = getRow ( line, v )) != cols)
		{
			std::ostringstream msg;
			msg << "Row " << rows << " has " << tmp << " columns, should have " << cols;
			throw RUMBA::Exception ( msg.str() );
		}
	}
	while ( getline (in,line));

	Manifold<double> M ( intPoint ( rows,1,1,cols ));

	if ( (int)v.size() > M.size() )
		throw RUMBA::Exception("warning: internal exception: vector is bigger than manifold in readManifoldMatrix");
//	std::copy(v.begin(),v.end(),M.begin());
//

	for ( int j = 0; j < cols; ++j )
		for ( int i = 0; i < rows; ++ i )
			M[ j * rows + i ] = v [ i * cols + j ];	

	return M;
}

void RUMBA::writeManifoldMatrix (const ManifoldMatrix& M, const char* filename)
{
	std::ofstream fout(filename);
	writeManifoldMatrix(M,fout);
}

void RUMBA::writeManifoldMatrix (const ManifoldMatrix& M, std::ostream& out)
{
	for ( int i = 0; i < M.rows(); ++i )
	{
		out << setiosflags(std::ios::fixed);
		for ( int j = 0; j < M.cols(); ++j )
			out << std::setprecision(4) << M.element( i,j)<<"\t";
		out << std::endl;
	}
}

#ifdef TEST_MATRIX_IO
using namespace RUMBA;
int main()
{
	cout << "got here (program started)" << endl;

	RUMBA::Manifold<double> M = readManifoldMatrix("test.txt");
	for ( int i = 0; i < M.size(); ++i )
		cout << "ith elt of M: " << M.getElement(i) << endl;
	cout << "got here" << endl;
//	M.save("test.img");
	cout << "got here" << endl;
	writeManifoldMatrix(M,"test2.txt");
	cout << "got here" << endl;

	return 0;
}

#endif







using namespace RUMBA;

ManifoldMatrix RUMBA::manifoldMatrixReadHack(std::string filename)
{
	if (filename.empty()) {
		return ( makeMatrix ( loadAsciiManifold ( std::cin ) ) );
	}
    else if (fileExtension(filename) == ".txt") {
		return makeMatrix(loadAsciiManifold ( filename.c_str() ) );
    }
    else {
	 	return ( makeMatrix( Manifold<double> ( filename.c_str() ) ) );
    }
}

void RUMBA::manifoldMatrixWriteHack(const ManifoldMatrix& mM , std::string filename )
{
	if (filename.empty()) {
		writeManifoldMatrix( mM, std::cout );
	}
	else if (fileExtension(filename) == ".txt") {
		writeManifoldMatrix( mM , filename.c_str() );
	}
	else {
		const_cast<ManifoldMatrix&>(mM).M.headerData()["hist_description"] = 
			(mM.Transpose ? "transposed matrix" : "matrix");
		mM.M.save(filename.c_str());
	}
}

