/**
  *	General routines for processing headers with fixed length fields
  */


	

#include <iostream>
#include <fstream>
#include <map>
#include <list>
#include <string>
#include <cmath>

#include <rumba/splodge.h>
#include <rumba/fileIO.h>
#include <rumba/constants.h>
#include <rumba/exception.h>
#include <rumba/header_request.h>
// #include <transforms.h>
#include <rumba/binary_header.h>

using RUMBA::header_request;
using std::list;
using RUMBA::Splodge;

namespace 
{
std::string extract_string(istream& in, int maxlen)
{
	char c;
	std::string result;
	for (int i=0; i < maxlen; ++i )
	{
		c = in.get();
		if (c)
			result += c;
		else
			break;
	}
	return result;
}
}

std::map<std::string, RUMBA::Splodge>
RUMBA::getData ( const list<header_request>& li, std::ifstream& Stream, bool le)
{
	std::map<std::string, RUMBA::Splodge> res;
	list<header_request>::const_iterator it = li.begin();
	for ( ; it != li.end(); ++it )
	{
		Stream.seekg(it->offset);

		res[it->name ] = getDataHelper(it->type,Stream, le, it->bytes);

	}

	return res;

}

Splodge RUMBA::getDataHelper ( int t,  std::ifstream& Stream, bool le , int bytes)
{
	switch (t)
	{
		case RUMBA::TYPE_CHAR:
			return Splodge(extract_string(Stream,bytes));

		case RUMBA::TYPE_SHORT: 
			return  Splodge( RUMBA::getShort(Stream, le ) );
		case RUMBA::TYPE_INT: 
			return  Splodge( RUMBA::getInt(Stream ,le ));
		case RUMBA::TYPE_FLOAT: 
			return  Splodge( RUMBA::getFloat(Stream ,le ));
		case RUMBA::TYPE_DOUBLE: 
			return  Splodge (RUMBA::getDouble(Stream, le) );
		default:
			throw RUMBA::Exception("Unknown type in RUMBA::getDataHelper");
	}

}



void RUMBA::putData 
( 
	const std::map<std::string, RUMBA::Splodge> & data,
	const list<header_request>& li , 
	std::ofstream& Stream, 
	bool le
)
{
	bool success = false;
	std::string  tmp_str;
	double tmp_dbl;
	int tmp_int;
	std::map<std::string, RUMBA::Splodge>::const_iterator it;
	list<header_request>::const_iterator lit = li.begin();

		
	for ( ; lit != li.end() ; ++lit )
	{
		Stream.seekp(lit->offset);
		it = data.find (lit->name);
		if ( it == data.end() )
			continue;

		switch (lit->type)
		{
			case RUMBA::TYPE_CHAR:
				tmp_str = it->second.asString();
				for (int i=0; i < lit->bytes && i < (int)tmp_str.length(); ++i )
					Stream.put ( tmp_str[i] );
				break;

			case RUMBA::TYPE_SHORT: 
				success = it->second.asInt(tmp_int);
				if (success)
					RUMBA::putShort( Stream, short(tmp_int) , le ); 
				break;
			case RUMBA::TYPE_INT: 
				success = it->second.asInt(tmp_int);
				if ( success )
					RUMBA::putInt( Stream, tmp_int, le ) ; 
				break; 
			case RUMBA::TYPE_FLOAT: 
				success = it->second.asDouble(tmp_dbl);
				if ( success ) 
					RUMBA::putFloat( Stream, float(tmp_dbl), le ); 
				break;
			case RUMBA::TYPE_DOUBLE: 
				success = it->second.asDouble(tmp_dbl);
				if ( success ) 
					RUMBA::putDouble( Stream, tmp_dbl, le );
				break;
		default:
				throw RUMBA::Exception("unknown type in putData()" );
		}
	}



	
	
}

#ifdef FOO_FOO_FOO

void writeAnalyzeData (ifstream& in, ofstream& out, int width, int height, int depth, int nTilesWide)
{
	int size = height * width * depth;
	cout << "height " << height << endl;
	cout << "width" << width << endl;
	cout << "depth" << depth << endl;
	cout << "nTiles" << nTilesWide << endl;

	for (int i=0;i<size;++i)
	{
		// neeed to multiply flatToMosaic() by 2 since the data are two bytes
		// wide
		in.seekg( 2 *   
				RUMBA::flatToMosaic(width,height,depth,nTilesWide, i)
				+ RUMBA::SIEMENS_HEADER_SIZE
				);
		RUMBA::putShort(out, RUMBA::getShort( in, 0 ), 1 );
	}
}
#endif


#ifdef TEST

#include <siemens_header_request.h>
#include <analyze_header_request.h>
#include <sys/stat.h>

int main(int argc, char** argv)
{
	int width,height,depth;
	int fileSize;
	struct stat fileStat;
	int top;
	if ( argc < 2 )
	{
		cerr << "must enter an analyze header name\n";
		exit(1);
	}
	cout << argv[1] << endl;

	ifstream in (argv[1]);
	
	std::map<std::string, RUMBA::Splodge> data;

	data = getData(RUMBA::siemens_header_request,in,0);

	std::map<std::string, RUMBA::Splodge>::const_iterator it;

	for ( it = data.begin(); it != data.end(); ++it )
	{
		cout << it->first << " " << it->second << endl;
	}

	int displayMatrixSize;
	if ( ! data["private_DisplayMatrixSize"].asInt( displayMatrixSize ) )
		cout << "Help! DisplayMatrixSize isn't an int\n";
	cout << displayMatrixSize << endl;


	width = displayMatrixSize;
	height = displayMatrixSize;
	// 2 is the size of the data type short in the ima data
	stat(argv[1], &fileStat );

	depth = ( 	fileStat.st_size - SIEMENS_HEADER_SIZE ) / ( width * height * 2 );	

	cout << depth << endl;
	ofstream headerOut("test.hdr");
	ofstream dataOut("test.img"  )	;
	
	// massage to analyze

	data["width"] = width;
	data["height"] = height;
	data["depth"] = depth;
	data["timepoints"] = 1;
	data["headerSize"] = 348;	
	data["nDims"] = 3;
	data["datatype"] = RUMBA::TYPE_SHORT;
	// From:  http://www.mayo.edu/bir/Analyze_Pages/AnalyzeFileInfo.html
	// these are required:
	data["hkey_regular"] = 'r';
	data["hkey_extents"] = 16384;
	data["sizeof(datatype)"] = 2; // bits per pixel
	// maybe we should set data["max"] and data["min"]
	
	if ( ! data.count("hist_sMin") )
		data["hist_sMin"] = 0;


	putData( data, RUMBA::analyze_header_request, headerOut );
	writeAnalyzeData(in, dataOut, width,height,depth, (int)(std::sqrt(depth)));
}

#endif
