#ifndef RUMBA_JACOBI_H
#define RUMBA_JACOBI_H


/**
  * \file jacobi.h
  * \author Donovan Rebbechi, Ben Bly, Giorgio Grasso
  * Copyright Ben Bly
  * This file is released under the artistic license. See the file
  * COPYING for details.
  */



#include <rumba/manifoldmatrix.h>

namespace RUMBA 
{

/** overwrites A with a diagonal matrix of eigenvalues
  * and returns the matrix of (column) eigenvectors.
  * t is a "tolerance".
  */
ManifoldMatrix jacobi ( ManifoldMatrix& A, double t = 1e-12);

//! See Matrix computations, P428
void sym_shur2(
		ManifoldMatrix A, 
		unsigned int p, 
		unsigned int q, 
		double& c, 
		double& s
);

}

#endif
