#ifndef RUMBA_HEADER_REQUEST_H
#define RUMBA_HEADER_REQUEST_H


/**
  * \file header_request.h
  * \author Donovan Rebbechi, Ben Bly, Giorgio Grasso
  * Copyright Ben Bly
  * This file is released under the artistic license. See the file
  * COPYING for details.
  */




#include <string>
#include <rumba/splodge.h>

namespace RUMBA
{
/**
 * 
 * Class used to represent the field of a header in a binary header file
 * for fMRI data (eg an analyze .hdr file).  These headers typically include
 * a mixture of different types of numeric data, as well as fixed-length 
 * fields containing character data. 
 */
struct header_request 
{
	header_request(std::string name, int type, int offset, int bytes = 0, bool required = 0, std::string default_value="" )
		: name(name), type(type), offset(offset), bytes(bytes), required(required), default_value(default_value)
		{}
	header_request()
		: name(""), type(-1), offset(0), bytes(0), required(0), default_value("") 
		{}

	/** 
	 * name for header field. This is the key value for the header entry
	 * used by the headerData() member of the BaseManifold class.
	 */
	std::string name;	

	/**
	 *  The data type of the field
	 */
	int type;

	/** 
	 * byte offset in the header file
	 */
	int offset;	

	/** length of field in the header. Only applicable for type char.
	 */
	int bytes;	

/** is the field required ?	
 */
	bool required;	
	RUMBA::Splodge default_value;	// default value of this field.

	bool operator==(const header_request&) { throw 0; }
	bool operator!=(const header_request&) { throw 0; }
	bool operator<(const header_request&) { throw 0; }

};

} /* namespace RUMBA */

#endif
