template <class TYPE>
void RUMBA::Manifold<TYPE>::loadAscii ( string filename, int width, int height, int depth, int timepoints ) 
{
	#ifdef DEBUG
	cerr << "calling Manifold<TYPE>::loadAscii" << endl;
	#endif
	
	// throw exception if  width * depth * height * timepoints != 0 ;
	if ( width * height * depth * timepoints == 0 ) 
	{
		throw RUMBA::Exception("Bad arguments");
	}
	Width = width; 
	Height = height; 
	Depth = depth; 
	TimePoints = timepoints;
	#ifdef DEBUG
	cerr << "Allocating: " << endl;
	cerr << Width << " " << Height << " " << Depth << " " << TimePoints << endl;
	#endif
	allocate ( Width, Height, Depth, TimePoints );
	loadAsciiData ( filename );
}

template <class TYPE>
void RUMBA::Manifold<TYPE>::loadAsciiData ( string filename) 
{
	#ifdef DEBUG
	cerr << "calling Manifold<TYPE>::loadAsciiData" << endl;
	#endif
	
	double d;
	ifstream fin (filename.c_str());

	if (!fin) {
		debug( "Manifold: cannot open file " );
		debug (  filename.c_str());
		#ifdef USE_EXCEPTIONS
		throw RUMBA::BadFile ( "Manifold::loadData : Cannot open file");
		#endif

	}
	int size = Size;
	TYPE *dstDataArray = DataArray;
	while ( size-- && fin ) 
	{
		cerr << size << endl;
		fin >> d;
		#ifdef USE_RUMBA_CAST
		*(dstDataArray++) = rumba_cast<TYPE> (d);
		#else
		*(dstDataArray++) = (TYPE) d;
		#endif
	}

	// Throw exception if file has too much or too little data.
	#ifdef USE_EXCEPTIONS
	if ( size != -1  )
		if ( fin.eof() )
			throw RUMBA::BadFile
				("Operation requested more data than there is in the file");
		else
			throw RUMBA::BadFile
				("Corrupt data");
	#endif
	fin.close();
}

template <class TYPE>
void RUMBA::Manifold<TYPE>::saveAsciiData ( string filename ) const
{
	TYPE* tmpDataArray;

	ofstream fout ( filename.c_str() );
	if ( !fout ) {
	#ifdef USE_EXCEPTIONS
		throw RUMBA::BadFile ( "Couldn't create file" );
	#else
	cerr << "Couldn't create file " << filename << endl;
	return;
	#endif
	}


	int size = Size;

	while ( size-- ) 
	{
		fout << *(tmpDataArray++);
		if (! (size%10) )
			fout << endl;
	}
	fout << endl;

}



