/*
*  RAL -- Rubrica Addressbook Library
*  file: date.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_DATE_H
#define _R_DATE_H

#include <time.h>
#include <glib.h>
#include <glib-object.h> 


#define R_DATE_TYPE           (r_date_get_type())

#define R_DATE(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj),   \
                               R_DATE_TYPE, RDate))

#define R_DATE_CLASS(kls)     (G_TYPE_CHECK_CLASS_CAST((kls),      \
                               R_DATE_TYPE, RDateClass))

#define IS_R_DATE(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj), R_DATE_TYPE))
#define IS_R_DATE_CLASS(kls)  (G_TYPE_CHECK_CLASS_TYPE((kls), R_DATE_TYPE))

#define R_DATE_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS((kls),    \
                               R_DATE_TYPE, RDateClass))


typedef struct _RDate        RDate;  
typedef struct _RDateClass   RDateClass;
typedef struct _RDatePrivate RDatePrivate;


struct _RDate
{
  GObject parent; 
  
  RDatePrivate *priv;
};


struct _RDateClass
{
  GObjectClass parent_class;
};



GType    r_date_get_type       (void);

 

RDate*   r_date_new            (void);
void     r_date_free           (RDate* date);
RDate*   r_date_copy           (RDate* date);

gboolean r_date_is_known       (RDate* date);
gboolean r_date_is_valid       (RDate* date);

gchar*   r_date_get_human_date (RDate* date);

gchar*   r_date_get_day        (RDate* date);
gchar*   r_date_get_month      (RDate* date);
gchar*   r_date_get_year       (RDate* date);

#endif
