/*
*  Rubrica
*  file: view.c
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#include <config.h>
#include <gnome.h>

#include "ui.h"
#include "rubrica.h"
#include "main.h"
#include "prefer.h"
#include "utils.h"

static RubricaViewType rubrica_view_type;

static GtkWidget *text_view;
static GtkTextBuffer *text_buffer;
GtkTextIter iter;

static GtkWidget *statusbar   = NULL;
static GtkWidget *label_path  = NULL;
static GtkWidget *label_items = NULL;

gint indirizzi  = 0;

/* 
   TODO:
   - add full pango support
   - add refresh of data 
   - user must choose font and font's colour
   - other ?
*/

GtkWidget *
rubrica_view_interface_creation(void)
{
  GtkWidget *scrollwin;
  PangoFontDescription *font_desc;
  
  scrollwin = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrollwin), 
				  GTK_POLICY_AUTOMATIC, 
				  GTK_POLICY_AUTOMATIC);  
  gtk_widget_show (scrollwin);

  text_view = gtk_text_view_new ();
  text_buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text_view));

  /* Change default font throughout the widget 
   */
  font_desc = pango_font_description_from_string ("Times 12");
  gtk_widget_modify_font (text_view, font_desc);
  pango_font_description_free (font_desc);
  
  /* Use a tag to change the color for just one part of the widget 
   */
  gtk_text_buffer_create_tag (text_buffer, "bold", "weight", 
			      PANGO_WEIGHT_BOLD, NULL);
  gtk_text_buffer_create_tag (text_buffer, "italic", "style", 
			      PANGO_STYLE_ITALIC, NULL);
  gtk_text_buffer_create_tag (text_buffer, "blue", "foreground", "blue", NULL);
  gtk_text_buffer_create_tag (text_buffer, "center", "justification", 
			      GTK_JUSTIFY_CENTER,NULL);
  gtk_text_buffer_create_tag (text_buffer, "margins", "left_margin", 10, 
			      "right_margin", 10, NULL);
  
  gtk_container_add (GTK_CONTAINER (scrollwin), text_view);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (text_view), FALSE);
  gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (text_view), GTK_WRAP_WORD);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (text_view), FALSE);

  gtk_widget_show (text_view);

  return (GtkWidget *) scrollwin;
}


void 
rubrica_view_init_view_type(RubricaViewType view_type)
{
  rubrica_view_type = CARD_VIEW;
}

RubricaViewType 
rubrica_view_get_view_type(void)
{
  return (RubricaViewType) rubrica_view_type;
}

void 
rubrica_view_set_view_type(RubricaViewType view_type)
{
  rubrica_view_type = (RubricaViewType) view_type;
}

void rubrica_view_clean_view(void)
{
  rubrica_ui_clean_text_view(text_view);
}

void 
rubrica_view_set_statusbar(GtkWidget *sbar)
{
  statusbar = sbar;
}

GtkWidget*
rubrica_view_get_statusbar(void)
{
  return (GtkWidget*) statusbar;
}

void 
rubrica_view_set_items_label(GtkWidget *items)
{
  label_items = items;
}


void 
rubrica_view_set_path_label(GtkWidget *path)
{
  label_path = path;
}


void rubrica_view_show_path(gboolean bool)
{
  if (bool)
    gtk_widget_show(label_path);
  else
    gtk_widget_hide(label_path);
}



/* public */

void 
rubrica_view_set_items(gint n)
{
 gchar *str;

 indirizzi = n;
 str = g_strdup_printf("%d", n);
 gtk_label_set_text(GTK_LABEL(label_items), str);

 g_free(str);
}


void 
rubrica_view_set_path(gchar *str)
{
  gtk_label_set_text(GTK_LABEL(label_path),str);		   
}



gint rubrica_view_get_indirizzi(void)  
{
  return (gint) indirizzi;  
}


void rubrica_view_write_item(GConfClient *client, gchar *key, gchar *str, 
			     gchar *label)
{
  gchar *string;

  if (!label || (strcmp(label, "") == 0))
    return;
  
  if (gconf_client_get_bool(client, key, NULL))
  {
    string = g_strdup_printf("\n%s: ", str);

    gtk_text_buffer_insert_with_tags_by_name(text_buffer, &iter, string, -1, 
					     "margins", "bold", NULL);  
    gtk_text_buffer_insert_with_tags_by_name(text_buffer, &iter, label, -1, 
					     "margins", NULL);

    g_free(string);
  }  
}


void rubrica_view_write_date_item(GConfClient *client, gchar *key, 
				  gchar *str, gboolean bool, gchar *label)
{
  gchar *string;
  
  if (bool && gconf_client_get_bool(client, key, NULL))
    {
      string = g_strdup_printf("\n%s: ", str);
      
      gtk_text_buffer_insert_with_tags_by_name(text_buffer, &iter, string, -1, 
					       "margins", "bold", NULL);   
      
      gtk_text_buffer_insert_with_tags_by_name(text_buffer, &iter, label, -1, 
					       "margins", NULL);
      
      g_free(string);
    }
}


void rubrica_view_show_card_item(RubricaItem *item)
{
  GConfClient *client;
  GList *alias = NULL;
  
  client = gconf_client_get_default();
  rubrica_ui_clean_text_view(text_view);
 
  gtk_text_buffer_get_iter_at_offset(text_buffer, &iter, 0);


  gtk_text_buffer_insert_with_tags_by_name(text_buffer, &iter, _("Card"), -1, 
					   "margins", "bold", "center", NULL);

  gtk_text_buffer_insert_with_tags_by_name(text_buffer, &iter, ": ", -1, 
					   "margins", "bold", "center", NULL); 
  if (item->card)
    gtk_text_buffer_insert_with_tags_by_name(text_buffer, &iter, item->card,
					     -1, "margins", NULL);
  else
    gtk_text_buffer_insert_with_tags_by_name(text_buffer, &iter, 
					     _("No Card name"), -1, 
					     "margins", NULL); 
  gtk_text_buffer_insert_with_tags_by_name(text_buffer, &iter, "\n", -1, 
					   "margins", NULL);


  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_FIRST_NAME, 
			  _("First Name"), item->personal.first);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_MIDDLE_NAME, 
			  _("Middle Name"), item->personal.middle);
  
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_LAST_NAME, 
			  _("Last Name"), item->personal.last);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_PROFESSION, 
			  _("Profession"), item->personal.profession);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_NAME_PREFIX, 
			  _("Name Prefix"), item->personal.prefix);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_TITLE, 
			  _("Title"), item->personal.title);
  rubrica_view_write_date_item(client, RUBRICA_KEY_SHOW_DATA_BIRTHDAY, 
			       _("BirthDay"), 
			       item->personal.birthknow,
			       rubrica_utils_convert_time(item->personal.birthdate, FALSE));
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_STREET, 
			  _("Street"), item->address.street);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_STREET_NUM, 
			  _("Street Number"), item->address.number);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_ZIP_CODE, 
			  _("Zip Code"), item->address.zip);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_CITY, 
			  _("City"), item->address.city);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_PROVINCE, 
			  _("Province"), item->address.province);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_STATE, 
			  _("State"), item->address.state);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_COUNTRY, 
			  _("Country"), item->address.country);

  /*    Rete
   */
  if (gconf_client_get_bool(client, RUBRICA_KEY_SHOW_DATA_WEB, NULL) || 
      gconf_client_get_bool(client, RUBRICA_KEY_SHOW_DATA_EMAIL, NULL))
    {
      alias = item->net.web;
      while(alias)
	{
	  gchar *str;
	  
	  str = (gchar *) alias->data;
	  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_WEB, 
				  _("Web"), str);     
	  alias = g_list_next(alias);
	}
      
      alias = item->net.email;
      while(alias)
	{
	  gchar *str;
	  
	  str = (gchar *) alias->data;
	  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_EMAIL,
				  _("Email"), str);     
	  alias = g_list_next(alias);
	}
    }

  /*     Telefono
  */
  if (gconf_client_get_bool(client, RUBRICA_KEY_SHOW_DATA_TELEPHONE, NULL))
    {
      alias = item->phone.telephone;
      while(alias)
	{
	  TelNum *tn;
	  gchar *str = NULL;
	  
	  tn = (TelNum *) alias->data;	  
	  if (tn->number && (tn->type && (strcmp(tn->type, "") != 0)))
	    str = g_strdup_printf("%s  (%s)", tn->number, tn->type);
	  else if (tn->number)
	    str = g_strdup_printf("%s", tn->number);
	  
	  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_TELEPHONE, 
				  _("Telephone"), str);     
	  if (str)
	    g_free(str);	      	  
	  
	  alias = g_list_next(alias);
	}
    }
 
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_COMPANY, 
			  _("Company"), item->company.name);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_JOB_STREET, 
			  _("Street"), item->company.street);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_JOB_STREET_NUM, 
			  _("Street Number"), item->company.number);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_JOB_ZIP_CODE,
			  _("Zip Code"), item->company.zip);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_JOB_CITY, 
			  _("City"), item->company.city);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_JOB_PROVINCE, 
			  _("Province"), item->company.province);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_JOB_COUNTRY, 
			  _("Country"), item->company.country);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_JOB_WEB, 
			  _("Web"), item->company.web);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_JOB_EMAIL, 
			  _("Email"), item->company.email);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_OPERATOR, 
			  _("Operator"), item->company.operator);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_FAX, 
			  _("Fax"), item->company.fax);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_GREEN, 
			  _("Green"), item->company.green);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_CUSTOMER_CARE, 
			  _("Customer Care"), item->company.customer_care);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_JOB_NOTE, 
			  _("Note"), item->company.notes);

  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_ASSIGMENT, 
			  _("Assigment"), item->work.assigment);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_ORG, 
			  _("Organization"), item->work.organization);  
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_DEP, 
			  _("Department"), item->work.department);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_SUB_DEP, 
			  _("Sub Department"), item->work.subdep);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_SECRETARY, 
			  _("Secretary"), item->work.secretary);
  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_SECR_PHONE, 
			  _("Secretary Telephone"), item->work.telephone);
  
  if (item->notes.is_married)
    rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_MARRIED, 
			    _("Contact"), item->notes.is_married ? 
			    _("is married") : _("is not married"));

  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_SPOUSE, 
			  _("Spouse"), item->notes.spouse);
  
  rubrica_view_write_date_item(client, RUBRICA_KEY_SHOW_DATA_SPOUSE_BIRTH, 
			       _("Spouse birthday"), item->notes.birthknow,
			       rubrica_utils_convert_time(item->notes.birthdate, FALSE));
  
  rubrica_view_write_date_item(client, RUBRICA_KEY_SHOW_DATA_ANNIVERSARY,
			       _("Marriage anniversary"), 
			       item->notes.anniverknow,
			       rubrica_utils_convert_time(item->notes.anniverdate, FALSE));

  if (item->notes.has_children)
    rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_HAS_CHILDREN, 
			    _("Children"), item->notes.has_children ? 
			    _("has got children") : _("has not children"));

  if (item->notes.has_children)
    rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_CHILDREN, 
			    _("Children note"), item->notes.children);

  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_HOBBIES, 
			  _("Hobbies"), item->notes.hobbies); 

  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_NOTE, _("Note"), 
			  item->notes.notes);

  rubrica_view_write_item(client, RUBRICA_KEY_SHOW_DATA_PUBLIC_KEY, 
			  _("Public key"), item->notes.pubkey);
}


