/*
*  program name: Rubrica <http://digilander.iol.it/nfragale/download.html>
*  file: prefer_cb.c
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gconf/gconf-client.h>
#include <libxml/tree.h>

#include "autosave.h"
#include "prefer.h"
#include "prefer_cb.h"
#include "prefer_int.h"
#include "dictionary.h"
#include "dialog.h"
#include "utils.h"
#include "rubrica.h"
#include "rubrica_type.h"
#include "main.h"



void 
rubrica_preferences_close_dialog  (GtkButton  *button, gpointer user_data)
{
  GtkWidget *w = user_data;

  gtk_widget_hide(w);
}


void 
on_option_menu_changed(GtkOptionMenu *optionmenu, gpointer user_data)
{
  GConfClient *client;
  gchar *key = user_data;
  gint option;
  
  client = gconf_client_get_default();
  option = gtk_option_menu_get_history(GTK_OPTION_MENU(optionmenu));
  gconf_client_set_int (client, key, option, NULL);    
}

/*    widget callbacks
*/
void on_check_button_toggled(GtkToggleButton *togglebutton, gpointer user_data)
{
  GConfClient *client;
  GtkWidget *prefbox; 
  
  gboolean state;
  gchar *key = user_data;
  
  g_return_if_fail(togglebutton != NULL);
  g_return_if_fail(key != NULL);
  

  client = gconf_client_get_default();
  prefbox = rubrica_preferences_get_preferencesbox();
  
  /* get the button state 
   */
  state = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton));
  
  /* per queste chiavi sono necessarie altre operazioni 
     those keys needs other steps
  */
  if ((strcmp(key, RUBRICA_KEY_SORT_DIRECTION) == 0))
    {
      if (state)
	gconf_client_set_int (client, key, SORT_ASCENDING, NULL);  
      else
	gconf_client_set_int (client, key, SORT_DESCENDING, NULL);  
      
      return;
    } 

  if ((strcmp(key, RUBRICA_KEY_HAVE_BOOK) == 0))
    {
      GtkWidget *fileentry;
      
      fileentry = gtk_object_get_data(GTK_OBJECT(prefbox), RUBRICA_KEY_BOOK);
      gtk_widget_set_sensitive(fileentry, state); 
    } 
  
  if ((strcmp(key, RUBRICA_KEY_HAVE_FOLDER) == 0))  
    { 
      GtkWidget *fileentry;  
      
      fileentry = gtk_object_get_data(GTK_OBJECT(prefbox), RUBRICA_KEY_FOLDER);
      gtk_widget_set_sensitive(fileentry, state);  
    }
      
  if (strcmp(key, RUBRICA_KEY_BACKUP) == 0)
    {
      GtkWidget *radio1;
      GtkWidget *radio2;  
      
      radio1 = gtk_object_get_data(GTK_OBJECT(prefbox), "inc_bak");   
      radio2 = gtk_object_get_data(GTK_OBJECT(prefbox), "bak_bak");   

      if (state)  
	{
	  gtk_widget_set_sensitive (radio1, TRUE);   
	  gtk_widget_set_sensitive (radio2, TRUE);   
	}  
      else   
	{
	  gtk_widget_set_sensitive (radio1, FALSE);   
	  gtk_widget_set_sensitive (radio2, FALSE);   
	}
    }
  
  if (strcmp(key, RUBRICA_KEY_COMPRESS) == 0)
    {
      GtkWidget *box;
      GtkWidget *spin; 
      
      spin = gtk_object_get_data(GTK_OBJECT(prefbox), RUBRICA_KEY_RATE); 
      box  = gtk_object_get_data(GTK_OBJECT(togglebutton), "spin_box"); 
      gtk_widget_set_sensitive(box, state); 
      gtk_widget_set_sensitive(spin, state); 
    }
  
  if (strcmp(key, RUBRICA_KEY_AUTOSAVE) == 0)
    {
      GtkWidget *box; 
      GtkWidget *spin; 
      gint time; 
      
      box  = gtk_object_get_data(GTK_OBJECT(togglebutton), "spin_box"); 
      spin = gtk_object_get_data(GTK_OBJECT(prefbox), RUBRICA_KEY_WAIT_TIME); 
      gtk_widget_set_sensitive(box, state); 
      gtk_widget_set_sensitive(spin, state); 

      if (state) 
	{ 
	  time = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin)); 
	  
	  rubrica_autosave_enable(time); 
	} 
      else                            
	rubrica_autosave_disable();      
    }

  gconf_client_set_bool (client, key, state, NULL);  
}

void on_radio_button_toggled (GtkToggleButton *togglebutton,
			      gpointer user_data)
{
  GConfClient *client;
  GtkWidget *prefbox; 
  gboolean state;
  gchar *key = user_data;

  g_return_if_fail(togglebutton != NULL);
  g_return_if_fail(user_data != NULL);

  /*    get ptr to preferences window dialog anto to GConf change set
   */
  client = gconf_client_get_default();
  prefbox = rubrica_preferences_get_preferencesbox();
  
  state = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton));

  /*     backup radio button
  */
  if ((strcmp(key, RUBRICA_KEY_BACKUP_TYPE_INC) == 0))
    {
      gconf_client_set_bool(client, RUBRICA_KEY_BACKUP_TYPE_INC, state, NULL);
      gconf_client_set_bool(client, RUBRICA_KEY_BACKUP_TYPE_BAK, !state, NULL);
    }

  if ((strcmp(key, RUBRICA_KEY_BACKUP_TYPE_BAK) == 0))
    {
      gconf_client_set_bool(client,RUBRICA_KEY_BACKUP_TYPE_INC, !state, NULL);
      gconf_client_set_bool(client, RUBRICA_KEY_BACKUP_TYPE_BAK, state, NULL);
    }  

  if ((strcmp(key, RUBRICA_KEY_ITALIAN) == 0))
    {
      gconf_client_set_bool(client, RUBRICA_KEY_ITALIAN, state, NULL);
      gconf_client_set_bool(client, RUBRICA_KEY_ENGLISH, !state, NULL);
    }

  if ((strcmp(key, RUBRICA_KEY_ENGLISH) == 0))
    {
      gconf_client_set_bool(client, RUBRICA_KEY_ITALIAN, !state, NULL);
      gconf_client_set_bool(client, RUBRICA_KEY_ENGLISH, state, NULL);
    }
  
  if ((strcmp(key, RUBRICA_KEY_DEFAULT)  == 0) || 
      (strcmp(key, RUBRICA_KEY_EXTERNAL) == 0))
    {
      GtkWidget *notebook_box;
      GtkWidget *dictionary_box;
      
      dictionary_box = gtk_object_get_data(GTK_OBJECT(prefbox),"box_def_dict");
      notebook_box  = gtk_object_get_data(GTK_OBJECT(prefbox), "notebook_box");
      
      if ((strcmp(key, RUBRICA_KEY_DEFAULT) == 0))
	{
	  gconf_client_set_bool(client, RUBRICA_KEY_DEFAULT, state, NULL);
	  gconf_client_set_bool(client, RUBRICA_KEY_EXTERNAL, !state, NULL);
	  
	  gtk_widget_set_sensitive(dictionary_box, state);
	  gtk_widget_set_sensitive(notebook_box, !state);
	}
      
      if ((strcmp(key, RUBRICA_KEY_EXTERNAL) == 0))
	{
	  gconf_client_set_bool(client, RUBRICA_KEY_DEFAULT, !state, NULL);
	  gconf_client_set_bool(client, RUBRICA_KEY_EXTERNAL, state, NULL);
	  
	  gtk_widget_set_sensitive(dictionary_box, !state);
	  gtk_widget_set_sensitive(notebook_box, state);
	}	
    }
}


void on_spin_activate (GtkWidget *spin, gpointer user_data)
{ 
  GConfClient *client;
  GtkWidget *prefbox; 
  gint val;
  gchar *key = user_data;

  g_return_if_fail(spin != NULL);
  g_return_if_fail(user_data != NULL);

  client = gconf_client_get_default();
  prefbox = rubrica_preferences_get_preferencesbox();


  val = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin));
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(spin), 0);

  /* store new compression rate in the key
     and set xml compression mode 
  */
  gconf_client_set_int(client, key, val, NULL);

  if (strcmp(key, RUBRICA_KEY_RATE) == 0)
    xmlSetCompressMode(val);

  if (strcmp(key, RUBRICA_KEY_WIDTH) == 0)
    {
      GtkWidget *app;
      gint width, length;

      app = rubrica_get_app();

      gconf_client_set_int(client, RUBRICA_KEY_WIDTH, val, NULL);

      gtk_window_get_size (GTK_WINDOW (app), &width, &length);
      gtk_window_resize(GTK_WINDOW (app), val, length);
    }

  if (strcmp(key, RUBRICA_KEY_LENGTH) == 0)
    {
      GtkWidget *app;
      gint width, length;

      app = rubrica_get_app();

      gconf_client_set_int(client, RUBRICA_KEY_LENGTH, val, NULL);

      gtk_window_get_size (GTK_WINDOW (app), &width, &length);
      gtk_window_resize(GTK_WINDOW (app), width, val);
    }
}


void on_entry_changed (GtkEditable *editable, gpointer user_data)
{
  GConfClient *client;
  GtkWidget *prefbox; 
  gchar *text;
  gchar *key = user_data;
  
  g_return_if_fail(editable != NULL);
  g_return_if_fail(user_data != NULL);  

  prefbox = rubrica_preferences_get_preferencesbox();

  client = gconf_client_get_default();
  text = gtk_editable_get_chars(GTK_EDITABLE(editable), 0, -1);
  
  if ( (strcmp(key, RUBRICA_KEY_BOOK)   == 0) ||
       (strcmp(key, RUBRICA_KEY_FOLDER) == 0))
    {			    
      if (*text != '\0')
	gconf_client_set_string(client, key, text, NULL);
     
      g_free(text);
    }
  
  if (strcmp(key,RUBRICA_KEY_USER_DICTIONARY) == 0)
    {
      GtkWidget *label;
      
      label = gtk_object_get_data(GTK_OBJECT(prefbox), "label_dict_name");
      gtk_label_set_pattern(GTK_LABEL(label), NULL);
      
      /*    if text was entered show it into label, and set into changeset
       */
      if (strlen(text) > 0)
	{
	  gtk_label_set_text(GTK_LABEL(label), text);
	  rubrica_preferences_set_user_dictionary(text);  
	}
      else
	{
	  gtk_label_set_text(GTK_LABEL(label), "");
	}      
    }
}


/*  Callback richiamata ad ogni cambiamento
    delle entry relative al dizionario 
    contenuto nel notebook

    notebook entries's callbacks
*/
void 
on_dictionary_entry_changed(GtkEditable *editable, gpointer user_data)
{
  GConfClient *client;
  gchar *text;
  gchar *key = user_data;

  client = gconf_client_get_default();

  /*    get the text typed into entry 
  */
  text = gtk_editable_get_chars(GTK_EDITABLE(editable), 0, -1);  
  gconf_client_set_string(client, key, text, NULL);
}



/*      Notebook buttons's callbacks
*/
void
on_load_dictionary_clicked(GtkButton *button, gpointer data)
{
  gchar *dictionary;

  dictionary = g_strdup(gtk_entry_get_text(GTK_ENTRY(data)));
  rubrica_dictionary_load_dictionary(dictionary);

  g_free(dictionary);
}

void
on_save_dictionary_clicked(GtkButton  *button, gpointer data)
{
  gchar *dictionary;
  
  dictionary = g_strdup(gtk_entry_get_text(GTK_ENTRY(data)));
  rubrica_dictionary_save_dictionary(dictionary);
  
  g_free(dictionary); 
}

void
on_show_rules_clicked  (GtkButton  *button, gpointer user_data)
{
  rubrica_dialog_translation_rules();
}


