# BEGIN LICENSE BLOCK
# 
#  Copyright (c) 2002-2003 Jesse Vincent <jesse@bestpractical.com>
#  
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of version 2 of the GNU General Public License 
#  as published by the Free Software Foundation.
# 
#  A copy of that license should have arrived with this
#  software, but in any event can be snarfed from www.gnu.org.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 
# END LICENSE BLOCK

# $Header: /raid/cvsroot/fm/lib/RT/FM/CustomFieldObjectValue.pm,v 1.2 2001/09/05 00:43:42 jesse Exp $
# Autogenerated by DBIx::SearchBuilder factory  (by <jesse@fsck.com>)

=head1 NAME

RT::FM::CustomFieldObjectValue


=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 METHODS

=cut

package RT::FM::CustomFieldObjectValue;
use RT::FM::Record; 
use RT::FM::Content;
use RT::FM::CustomField;
use RT::FM::User;
use RT::FM::Article;


use vars qw( @ISA );
@ISA= qw( RT::FM::Record );

sub _Init {
  my $self = shift; 

  $self->Table('CustomFieldObjectValues');
  $self->SUPER::_Init(@_);
}





=item Create PARAMHASH

Create takes a hash of values and creates a row in the database:

  int(11) 'id'.
  int(11) 'Article'.
  int(11) 'CustomField'.
  varchar(255) 'Content'.
  int(11) 'SortOrder'.
  int(11) 'Creator'.
  datetime 'Created'.
  int(11) 'UpdatedBy'.
  datetime 'Updated'.

=cut




sub Create {
    my $self = shift;
    my %args = ( 
                id => undef,
                Article => undef,
                CustomField => undef,
                Content => undef,
                SortOrder => undef,
                Creator => undef,
                Created => undef,
                UpdatedBy => undef,
                Updated => undef,
,
		  @_);
    $self->SUPER::Create(
                         id => $args{'id'},
                         Article => $args{'Article'},
                         CustomField => $args{'CustomField'},
                         Content => $args{'Content'},
                         SortOrder => $args{'SortOrder'},
                         Creator => $args{'Creator'},
                         Created => $args{'Created'},
                         UpdatedBy => $args{'UpdatedBy'},
                         Updated => $args{'Updated'},
);

}



=item id

Returns the current value of id. 
(In the database, id is stored as int(11).)


=item Setid VALUE

Set id to VALUE. 
Returns (1, 'Status message') on success and (0, 'Error Message') on failure.
(In the database, id will be stored as a int(11).)

=cut


=item Article

Returns the current value of Article. 
(In the database, Article is stored as int(11).)


=item SetArticle VALUE

Set Article to VALUE. 
Returns (1, 'Status message') on success and (0, 'Error Message') on failure.
(In the database, Article will be stored as a int(11).)

=cut


=item ArticleObj

Returns the Article Object which has the id returned by Article


=cut

sub ArticleObj {
	my $self = shift;
	my $Article = new RT::FM::Article($self->CurrentUser);
	$Article->Load($self->Article());
	return($Article);
}

=item CustomField

Returns the current value of CustomField. 
(In the database, CustomField is stored as int(11).)


=item SetCustomField VALUE

Set CustomField to VALUE. 
Returns (1, 'Status message') on success and (0, 'Error Message') on failure.
(In the database, CustomField will be stored as a int(11).)

=cut


=item CustomFieldObj

Returns the CustomField Object which has the id returned by CustomField


=cut

sub CustomFieldObj {
	my $self = shift;
	my $CustomField = new RT::FM::CustomField($self->CurrentUser);
	$CustomField->Load($self->CustomField());
	return($CustomField);
}

=item Content

Returns the current value of Content. 
(In the database, Content is stored as varchar(255).)


=item FriendlyContent

If this is a freeform custom field, returns the value of content.
If this is a Select custom field, returns the Name attribute of the CustomFieldValue this object is associated with.


=cut

sub FriendlyContent {
	my $self = shift;
	if ($self->CustomFieldObj->Type =~ /^Select/) {
		return $self->CustomFieldValueObj->Name;
	}
	else {
		return ($self->Content);
	}
}



=item CustomFieldValueObj


If this is a Select custom field, returns the CustomFieldValue this object is associated with. Otherwise, returns an empty CustomFieldValue object.


=cut

sub CustomFieldValueObj {
	my $self = shift;
	my $cfv_obj = new RT::FM::CustomFieldValue($self->CurrentUser);
	unless ($self->CustomFieldObj->Type =~ /^Select/) {
		return ($cfv_obj);
	}
	$cfv_obj->Load($self->Content);
	return($cfv_obj); 
}


=item SetContent VALUE

Set Content to VALUE. 
Returns (1, 'Status message') on success and (0, 'Error Message') on failure.
(In the database, Content will be stored as a varchar(255).)

=cut





=item SortOrder

Returns the current value of SortOrder. 
(In the database, SortOrder is stored as int(11).)


=item SetSortOrder VALUE

Set SortOrder to VALUE. 
Returns (1, 'Status message') on success and (0, 'Error Message') on failure.
(In the database, SortOrder will be stored as a int(11).)

=cut


=item Creator

Returns the current value of Creator. 
(In the database, Creator is stored as int(11).)


=item SetCreator VALUE

Set Creator to VALUE. 
Returns (1, 'Status message') on success and (0, 'Error Message') on failure.
(In the database, Creator will be stored as a int(11).)

=cut


=item CreatorObj

Returns the User Object which has the id returned by Creator


=cut

sub CreatorObj {
	my $self = shift;
	my $Creator = new RT::FM::User($self->CurrentUser);
	$Creator->Load($self->Creator());
	return($Creator);
}

=item Created

Returns the current value of Created. 
(In the database, Created is stored as datetime.)


=item SetCreated VALUE

Set Created to VALUE. 
Returns (1, 'Status message') on success and (0, 'Error Message') on failure.
(In the database, Created will be stored as a datetime.)

=cut


=item UpdatedBy

Returns the current value of UpdatedBy. 
(In the database, UpdatedBy is stored as int(11).)


=item SetUpdatedBy VALUE

Set UpdatedBy to VALUE. 
Returns (1, 'Status message') on success and (0, 'Error Message') on failure.
(In the database, UpdatedBy will be stored as a int(11).)

=cut


=item UpdatedByObj

Returns the User Object which has the id returned by UpdatedBy


=cut

sub UpdatedByObj {
	my $self = shift;
	my $UpdatedBy = new RT::FM::User($self->CurrentUser);
	$UpdatedBy->Load($self->UpdatedBy());
	return($UpdatedBy);
}

=item Updated

Returns the current value of Updated. 
(In the database, Updated is stored as datetime.)


=item SetUpdated VALUE

Set Updated to VALUE. 
Returns (1, 'Status message') on success and (0, 'Error Message') on failure.
(In the database, Updated will be stored as a datetime.)

=cut



sub _ClassAccessible {
    {
     
        id => {'read' => 1, 'write' => 1},
        Article => {'read' => 1, 'write' => 1},
        CustomField => {'read' => 1, 'write' => 1},
        Content => {'read' => 1, 'write' => 1},
        SortOrder => {'read' => 1, 'write' => 1},
        Creator => {'read' => 1, 'write' => 1},
        Created => {'read' => 1, 'write' => 1},
        UpdatedBy => {'read' => 1, 'write' => 1},
        Updated => {'read' => 1, 'write' => 1},

 }
};
1;
