/***************************************************************************
 * RT2400/RT2500 SourceForge Project - http://rt2x00.serialmonkey.com      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 *   Licensed under the GNU GPL                                            *
 *   Original code supplied under license from RaLink Inc, 2004.           *
 ***************************************************************************/

 /***************************************************************************
 *      Module Name: rt_config.h
 *
 *      Abstract: Central header file for all includes
 *
 *      Revision History:
 *      Who             When            What
 *      --------        -----------     -----------------------------
 *      RoryC           21st Dec 02     Initial code
 *      MarkW           8th  Dec 04     Baseline code
 ***************************************************************************/

#ifndef __RT_CONFIG_H__
#define __RT_CONFIG_H__

// Propagate predefined compiler variables asap - bb.
#if defined(__BIG_ENDIAN) || defined(__BIG_ENDIAN__) || defined(_BIG_ENDIAN)
#define BIG_ENDIAN TRUE
#endif /* __BIG_ENDIAN */

#define	DRV_NAME	"rt2500"
#define DRV_VERSION	"1.1.0 CVS"
#define DRV_RELDATE	"CVS Release"
#define DRV_VERSION_MAJOR 1
#define DRV_VERSION_MINOR 1
#define DRV_VERSION_SUB 0
#define DRV_BUILD_YEAR 2007
#define DRV_BUILD_MONTH 05
#define DRV_BUILD_DAY 13

#define PROFILE_PATH                "/etc/Wireless/RT2500STA/RT2500STA.dat"
#define NIC_DEVICE_NAME             "RT2500STA"

/* Operational parameters that are set at compile time. */
#if !defined(__OPTIMIZE__)  ||  !defined(__KERNEL__)
#warning  You must compile this file with the correct options!
#warning  See the last lines of the source file.
#error  You must compile this driver with "-O".
#endif

#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/module.h>
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,25))	// N.A. earlier
#include <linux/moduleparam.h>	// Only need to explicitly include
#endif							// in early 2.6 series
#include <linux/string.h>
#include <linux/timer.h>
#include <linux/slab.h>
#include <linux/pci.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/delay.h>		// For udelay, mdelay
#include <linux/wireless.h>
#include <linux/proc_fs.h>
#include <linux/if_arp.h>
#include <linux/ctype.h>

#if LINUX_VERSION_CODE >= 0x20407
#include <linux/mii.h>
#endif
#include <asm/processor.h>      /* Processor type for cache alignment. */
#include <asm/bitops.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/uaccess.h>
#include <asm/div64.h>

// The type definition has to be placed before including rt2460.h
#ifndef ULONG
#define CHAR            signed char
#define INT             int
#define SHORT           short
#define UINT            u32
#define ULONG           u32
#define USHORT          u16
#define UCHAR           u8

#define BOOLEAN         u8
//#define LARGE_INTEGER s64
#define VOID            void
#define LONG            int
#define ULONGLONG       u64
typedef VOID            *PVOID;
typedef CHAR            *PCHAR;
typedef UCHAR           *PUCHAR;
typedef LONG            *PLONG;
typedef ULONG           *PULONG;

typedef union _LARGE_INTEGER {
	struct {
		ULONG LowPart;
		LONG HighPart;
	} vv;
	struct {
		ULONG LowPart;
		LONG HighPart;
	} u;
	s64 QuadPart;
} LARGE_INTEGER;

#endif

#define IN
#define OUT

#define TRUE        1
#define FALSE       0

#define NDIS_STATUS                             INT
#define NDIS_STATUS_SUCCESS                     0x00
#define NDIS_STATUS_FAILURE                     0x01
#define NDIS_STATUS_RESOURCES                   0x03
#define NDIS_STATUS_MEDIA_DISCONNECT            0x04
#define NDIS_STATUS_MEDIA_CONNECT               0x05

#include    "rtmp_type.h"
#include    "rtmp_def.h"
#include    "rt2560.h"
#include    "rtmp.h"
#include    "rt2x00debug.h"
#include    "mlme.h"
#include    "oid.h"
#include    "wpa.h"
#include    "md5.h"

#define DEBUG_TASK_DELAY        2000

enum rt2560_chips {
    RT2560A = 0,
};

#if 1				//#ifdef RTMP_EMBEDDED
#undef GFP_KERNEL
#define GFP_KERNEL      (GFP_DMA | GFP_ATOMIC)
#endif

/* Check CONFIG_SMP defined */
#ifndef NR_CPUS
#define NR_CPUS 1
#endif
#if NR_CPUS > 1
#define MEM_ALLOC_FLAG	    GFP_ATOMIC
#else
#define MEM_ALLOC_FLAG      (GFP_DMA | GFP_ATOMIC)
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,23)
#undef del_timer_sync
#define del_timer_sync(x) del_timer(x)
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,25)
/* 2.6 compatibility */
#define SET_NETDEV_DEV(net, pdev) do { } while (0)
#endif

#ifndef pci_name
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0))
#define pci_name(__pPci_Dev)	(__pPci_Dev)->dev.bus_id
#else /* (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)) */
#define pci_name(__pPci_Dev)	(__pPci_Dev)->slot_name
#endif /*(LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)) */
#endif /* pci_name */

// 2.5.44? 2.5.26?
#ifndef smp_read_barrier_depends
#define smp_read_barrier_depends() ((void)0)
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,18))
#define IRQFLAGS SA_SHIRQ
#else
#define IRQFLAGS IRQF_SHARED
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,22))

// Accomodate 64 bit compatibility macros
#define skb_end_pointer(skb) (skb->end)
#define skb_tail_pointer(skb) (skb->tail)
#define skb_reset_mac_header(skb) (skb->mac.raw = skb->data)
#define skb_reset_tail_pointer(skb) (skb->tail = skb->data)
#define skb_set_tail_pointer(skb, offset) (skb->tail = skb->data + offset)
#endif

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,22))
#define pci_module_init	pci_register_driver
#endif

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,24))
#define SET_MODULE_OWNER(some_struct) do { } while (0)
#define dev_get_by_name(slot_name) dev_get_by_name(&init_net, slot_name)
#define first_net_device() first_net_device(&init_net)
#endif

#endif // __RT_CONFIG_H__
