/*
 * Copyright (C) 2002  Terence M. Welsh
 * Ported to Linux by Tugrul Galatali <tugrul@galatali.com>
 *
 * Implicit is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as 
 * published by the Free Software Foundation.
 *
 * Implicit is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "config.h"
#include "impSphere.h"

void
  impSphere::setScale (float s)
{
	scale = s;
	invscale = 1.0f / scale;
}

float impSphere::value (float *position)
{
#ifdef _USE_SSE /* disabled, performance sucks, play with it later ;) */
        float value = 1;

        __asm__ (
		"movups		%1, %%xmm0\n"
		"prefetcht0	(%3)\n"

		"movss		%2, %%xmm2\n"
		"unpcklps	%%xmm2, %%xmm2\n"
		"unpcklps	%%xmm2, %%xmm2\n"

		"movups		(%3), %%xmm1\n"
		"prefetcht0	%0\n"
		"addps		%%xmm1, %%xmm0\n"

		"mulps		%%xmm2, %%xmm0\n"

		"mulps		%%xmm0, %%xmm0\n"

		"movups		%%xmm0, %%xmm1\n"

		"shufps          $9, %%xmm1, %%xmm0\n"
		"addss           %%xmm0, %%xmm1\n"

		"shufps          $1, %%xmm0, %%xmm0\n"
		"addss           %%xmm0, %%xmm1\n"

#if 0
		"mov		$1, %%edx\n"
		"cvtsi2ss	%%edx, %%xmm0\n"
#else
		"movss		%0, %%xmm3\n"
#endif

		"divss		%%xmm1, %%xmm3\n"

		"movss		%%xmm3, %0\n"
	: "=m" (value), "=m" (invmat[12]), "=m" (invscale)
	: "d" (position)
	);

	return value;
#else
	float x = (invmat[12] + position[0]) * invscale;
	float y = (invmat[13] + position[1]) * invscale;
	float z = (invmat[14] + position[2]) * invscale;

	return (1.0f / (x * x + y * y + z * z));
#endif
}
