/*				       	-*- c-file-style: "bsd" -*-
 * rproxy -- dynamic caching and delta update in HTTP
 * $Id: request.h,v 1.7 2000/08/13 10:40:32 mbp Exp $
 * 
 * Copyright (C) 1999, 2000 by Martin Pool <mbp@linuxcare.com>
 * Copyright (C) 1999 by Andrew Tridgell <tridge@linuxcare.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef RP_REQUEST_H
#define RP_REQUEST_H


/* 
 * These represent the state machine of a request: the ordering is
 * critical e.g. to know when the request headers have gone out.  More
 * can be added when more resolution is necessary.
 */
enum request_state {
    begin = 0,
    sending_response_headers,
    sending_body
};


/* Information about this request. */
typedef struct request {
    char           *req_line;	/* "GET http://foo.bar.com:80/index.html HTTP/1.0" */
    char           *url;	/* "http://foo.bar.com:80/index.html?a=2" */
    char           *path;	/* "/index.html" */
    char           *method_name; /* "GET" */
    http_method_t   method_id;  /* METHOD_GET */
    char const     *http_version;	/* "HTTP/1.0" */

    /* stdio will be phased out */
    FILE           *f_to_client, *f_from_client;
    FILE           *f_upstream;

    /* these may be different if e.g. they are stdin/stdout. */
    int             fd_from_client, fd_to_client;
    int             fd_upstream;

    /* Read and write cache file */
    FILE           *f_old_cache, *f_new_cache;

    /* host and port from the request URL */
    char           *url_hostname;
    int             url_port;

    /* host and port to whom this request will be forwarded; either the
       upstream host or the origin. */
    char           *dest_hostname;
    int             dest_port;

    hs_stats_t      hs_stats;

    /* We use this to know whether it's OK to send an error message to the
       client. */
    enum request_state state;

    char           *resp_content_type;

    char const     *action_str;	/* description of how we're handling the
				   request e.g. `pass' */
    int             status;	/* response status code */
    char           *status_msg;	/* e.g. 'Not authorized' */
    int             resp_rsync_encoded:1;	/* response is sync encoded */
    int             client_does_hsync:1;	/* client does rsync2
						   server-side-signature */
    int             client_wants_direct:1;	/* client doesn't want us
						   screwing up the request. */
    int             content_length;

    char           *req_signature;	/* signature from downstream */
    int             req_signature_len;

    FILE           *f_old_sig;	/* signature files */
    int            fd_new_sig;

    /* Address of client in printable form */
    char           client_addr_str[80];
    int            client_port;

    /* My own address */
    int            local_port;

    struct header_list *headers;
} request_t;



void rp_request_free(request_t *);

struct sockaddr;
void rp_req_set_client_addr(request_t *req, struct sockaddr *client_addr);

void rp_req_find_local_addr(int fd, request_t *req);

void rp_req_set_status(request_t *req, int status);

#endif /* RP_REQUEST_H */
