/*				       	-*- c-file-style: "bsd" -*-
 * rproxy -- dynamic caching and delta update in HTTP
 * $Id: xferlog.c,v 1.4 2000/08/16 10:08:58 mbp Exp $
 * 
 * Copyright (C) 1999, 2000 by Martin Pool
 * Copyright (C) 1999 by Andrew Tridgell
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Hmm, logging works like this: we open a file descriptor during startup in
   `append' mode, so each write should atomically append, even when several
   tasks are writing at the same time.  (Right?)

   Gee, that's a nice feature. */

/*
 * TODO: If a transfer is interrupted or failed, then we should still
 * log it and indicate so.
 */

#include "config.h"
#include "sysheaders.h"

#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif

#include "rproxy.h"
#include "xferlog.h"
#include "trace.h"


void
rp_log_transfer(request_t * req)
{
    char            date_str[40];
    time_t          now;
    char            stats_str[256];

    if (!config.transfer_log)
        return;

    time(&now);
    strftime(date_str, sizeof date_str,
	     "%d/%b/%Y:%H:%M:%S %z", localtime(&now));

    errno = 0;

    hs_format_stats(&req->hs_stats, stats_str, sizeof stats_str);

    /* This format is meant to be reasonably close to the standard Combined
       Log Format, but with more fields for things we care about that web
       servers don't. */

    /* FIXME: Quote string fields properly. */

    fprintf(config.transfer_log,
	    "%s - - [%s] \"%s\" %d %10s [%s] \"%s\"\n",
	    req->client_addr_str,
	    date_str,
	    req->req_line, req->status, req->action_str, stats_str,
	    req->resp_content_type ? req->resp_content_type : "-");

    fflush(config.transfer_log);

    if (errno) {
        rp_log(LOGAREA_PROCESS, LOG_ERR, "error writing to logfile %s: %s\n",
               config.transfer_logfile,
               strerror(errno));
    }
}


void
rp_open_transfer_log(char const *filename)
{
    config.transfer_log = fopen(filename, "at");
    if (!config.transfer_log) {
        rp_log(LOGAREA_PROCESS, LOG_ERR, "can't open transfer logfile %s: %s\n",
               filename, strerror(errno));
	exit(1);
    }
    config.transfer_logfile = filename;
}


