/*
 * mirrors.c : manage a list of distributions mirrors
 *
 * See Copyright for the status of this software.
 *
 * $Id: mirrorfind.c,v 1.3 1998/09/11 05:25:04 daniel Exp $
 */

#include "config.h"
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <dirent.h>
#include <errno.h>
#include <time.h>
#ifdef HAVE_REGEX_H
#include <regex.h>
#else
#ifdef HAVE_RXPOSIX_H
#include <rxposix.h>
#endif
#endif

#include "ftp.h"
#include "mirrorfind.h"

/*
 * Ftp informations
 */
char *downloadDir = "/tmp";
int   mirrorsVerbose = 1;

/*
 * Usage info
 */
void usage(char *name) {
    printf("%s %s : RPM packages search engine\n",
	    MIRRORS_NAME, MIRRORS_VER);
    printf("usage : %s [flags] packagename [packagename ...]\n", name);
    printf("  Homepage: %s\n", MIRRORS_URL);
    printf("  Maintainer: %s <%s>\n", MIRRORS_MAINT, MIRRORS_MAIL);
    printf("\tflags\t\tmeaning\n");
    printf("\t-q or -v\tdecrease or increase verbosity\n");
    printf("\t-p prefix\tprefix for the local RPM database\n");
    printf("\t-s server\tURL of the server to contact\n");
    printf("\t--lookup\tsimple lookup (standard mode)\n");
    printf("\t--latest\tsuggest upgrades for the package[s]\n");
    printf("\t--upgrade\tsuggest upgrades for all dependencies\n");
    printf("\t--apropos\tdo a lookup in the database for the keyword\n");
    exit(1);
}

/*
 * get the origin server #
 */

int getOriginServer(char *ftp) {
    int i;

    for (i = 0;i < originServerNb;i++) {
        if (!strcmp(ftp, originServerList[i].ftp)) return(i);
    }
    if (originServerNb >= MAX_SERVERS) {
        fprintf(stderr, "Increase MAX_SERVERS=%d\n", MAX_SERVERS);
	exit(1);
    }
    originServerList[originServerNb].ftp = strdup(ftp);
    originServerList[originServerNb].nbMirrors = 0;
    return(originServerNb++);
}

/*
 * Add a mirror to an origin server.
 */

void addOriginServerMirror(char *ftp, char *mirror) {
    int i;
    int index = getOriginServer(ftp);
    originServerPtr cur = &originServerList[index];

    for (i = 0;i < cur->nbMirrors;i++) {
        if (!strcmp(mirror, cur->mirrors[i])) return;
    }
    if (i >= MAX_MIRRORS) {
        fprintf(stderr, "Increase MAX_MIRRORS=%d\n", MAX_MIRRORS);
	return;
    }
    cur->mirrors[cur->nbMirrors++] = strdup(mirror);
}

/*
 * get the origin distrib #
 */

int getOriginDistrib(char *dir) {
    int i;

    for (i = 0;i < originDistribNb;i++) {
        if (!strcmp(dir, originDistribList[i].directory)) return(i);
    }
    if (originDistribNb >= MAX_DISTRIBS) {
        fprintf(stderr, "Increase MAX_DISTRIBS=%d\n", MAX_DISTRIBS);
	exit(1);
    }
    originDistribList[originDistribNb].directory = strdup(dir);
    originDistribList[originDistribNb].nbMirrors = 0;
    originDistribList[originDistribNb].html = -1;
    originDistribList[originDistribNb].build_tree = -1;
    return(originDistribNb++);
}

/*
 * Add a mirror to an origin server.
 */

void addOriginDistribMirror(int index, char *mirror) {
    int i;
    originDistribPtr cur = &originDistribList[index];

    for (i = 0;i < cur->nbMirrors;i++) {
        if (!strcmp(mirror, cur->mirrors[i])) return;
    }
    if (i >= MAX_MIRRORS) {
        fprintf(stderr, "Increase MAX_MIRRORS=%d\n", MAX_MIRRORS);
	return;
    }
    cur->mirrors[cur->nbMirrors++] = strdup(mirror);
}

/*
 * The main !
 */
int main(int argc, char **argv) {
    int i,j,k,res;
    int nb_packages = 0;
    char *configfile = NULL;
    char *outputfile = NULL;
    char URL[3000];
    char mirrorname[100];
    char *server;
    char *mirror;
    char *subdir;
    char *ptr;
    char *directory;
    int   start;
    int   end;
    int   nbDistribs;

    /*
     * Parse the command line args
     */
    i = 1;
    while (i < argc) {
        if (argv[i][0] == '-') {
	} else {
	    if (outputfile != NULL) usage(argv[0]);
	    if (configfile == NULL)
		configfile = argv[i];
	    else
	        outputfile = argv[i];
	}
	i++;
    }

    if (nb_packages == 0) {
    }

    /*
     * initialize state from the config files
     */
    mirrorsReadConfigFiles(configfile);

    /*
     * Initialize the FTP client side.
     */
    initFtp();

    /*
     * Search all the items
     * Walk all the servers, pick the mirrors one by one and
     * walk the distribution. If the distribution is hosted by the
     * mirror, guess the loaction for the distrib on the mirror and
     * check if the directory exists. Then mark the mirror as good.
     */
    for (i = 0;i < originServerNb;i++) {
	server = originServerList[i].ftp;
	for (j = 0;j < originServerList[i].nbMirrors;j++) {
	    mirror = originServerList[i].mirrors[j];
	    /*
	     * mirror = "ftp://" "mirrorname" "/directory".
	     */
	    if (strncmp(mirror, "ftp://", 6)) {
		if (mirrorsVerbose)
		    fprintf(stderr, "mirror invalid : %s\n", mirror);
		continue;
	    }
	    directory = &mirror[6];
	    ptr = &mirrorname[0];
	    while ((*directory != 0) && (*directory != '/')) {
	        *ptr++ = *directory++;
	    }
	    *ptr = 0;
	    if (*directory == 0) {
		if (mirrorsVerbose)
		    fprintf(stderr, "mirror invalid : %s\n", mirror);
		continue;
	    }

	    /*
	     * Connect to the server.
	     */
	    nbDistribs = 0;
	    if (mirrorsVerbose)
	        printf("[%s]\n", mirrorname);
	    res = connectFtp(mirrorname, 0);
	    if (res < 0) {
		if (mirrorsVerbose > 1)
		    fprintf(stderr, "cannot connect to %s\n", mirrorname);
		continue;
	    }
	    for (k = 0;k < originDistribNb;k++) {
	        /* check originDistribList[k].ftp = server + subdir */
	        ptr = server;
		subdir = originDistribList[k].ftp;
		while ((*ptr != 0) && (*subdir == *ptr)) {
		    ptr++;
		    subdir++;
		}
		if (*ptr != 0) continue;
		sprintf(URL, "%s%s", directory, subdir);
		start = time(NULL);
		res = changeFtpDirectory(&URL[0]);
		end = time(NULL);
		if ((res < 0) || ((end - start) > 60)) {
		    if (mirrorsVerbose > 1)
			printf("Lost connection with %s \n", mirrorname);
		    goto host_unreachable;
		} else if (res == 0) {
		    if (mirrorsVerbose > 1)
			printf("Directory %s doesn't exists\n", URL);
		    continue;
		}
		sprintf(URL, "%s%s", mirror, subdir);
		if (mirrorsVerbose > 1)
		    printf("Found mirror %s\n", URL);
		addOriginDistribMirror(k, URL);
		nbDistribs++;
	    }
	    if (mirrorsVerbose)
	        printf("%d distribs\n", nbDistribs);
host_unreachable:
            disconnectFtp();
	}
    }

    /*
     * Write the resulting config files.
     */
    mirrorsWriteConfigFile(outputfile);

    exit(0);
}
