/*
 * language.c: code for the Localization support.
 *
 * See Copyright for the status of this software.
 *
 * $Id: language.c,v 1.30 2000/12/10 17:10:38 veillard Exp $
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "rpm2html.h"
#include "rpmdata.h"
#include "html.h"

char *localizedStrings[] = {
    ".html",			/* HTML files suffix */
    "Generated by",
    "index.html",
    "Groups.html",
    "ByDate.html",
    "ByName.html",
    "Vendors.html",
    "Distribs.html",
    "Welcome to the RPM repository on",
    "<p>\n\
<strong>rpm2html</strong> automatically generates Web pages describing a set of\n\
<a href=\"http://www.rpm.org/\">RPM</a> packages.</p>\n\
<p>\n\
<a href=\"http://rpmfind.net/linux/rpm2html/rpmfind.html\">\n\
The Rpmfind tool</a> allows automate the search of packages from\n\
the RPM Database or maintain your system up-to-date in a more automated way.\n\
<p>\n\
The goals of rpm2html are also to identify the dependencies between\n\
various packages and to find the package(s) providing the resources\n\
needed to install a given package. Every package is analyzed to\n\
retrieve its dependencies and the resources it offers. These\n\
relationships are expressed using hyperlinks in the generated\n\
pages. Finding the package providing the resource you need is just a\n\
matter of a few clicks!</p>\n\
<p>Check the <a href=\"http://rpmfind.net/linux/rpm2html/faq.html\">FAQ</a>\n\
in case of problems with rpm2html or rpmfind.\n\
<p>\n\
The proper working of the rpm2html tools requires the package maintainer\n\
to properly comment their RPM(s), if you maintain packages, make sure\n\
that the informations are provided adequately (URL, email, ...).</p>\n\
<p>Learn how to <a href=\"http://rpmfind.net/linux/rpm2html/mirror.html\">\n\
build your own mirror</a> of this site. <B><FONT COLOR=\"#FF0000\">\n\
<FONT SIZE=\"+2\">Do not try to mirror it with a Web copy tool</FONT>\n\
</FONT></B></p>\n",
    "This archive hosts %d RPMs representing %d MBytes of data",
    "On this machine %d RPMs are installed representing %d MBytes of data",
    "The list of ",
    "RPM indexed by category",
    "RPM indexed by date of creation",
    "RPM indexed by name",
    "RPM indexed by maintainer",
    "RPM indexed by distribution",
    "RPM indexed by date of installation",
    "Repository for sources",
    "Local mirror",
    "Mirrors",
    "Generation took",
    "seconds",
    "Welcome to the RPM description of",
    "From",
    "Name",
    "Distribution",
    "Version",
    "Vendor",
    "Release",
    "Build date",
    "Install date",
    "Group",
    "Build host",
    "Size",
    "Source RPM",
    "Packager",
    "Url",
    "Summary",
    "Provides",
    "Requires",
    "Copyright",
    "Files",
    "No Filelist in the Package !",
    "No summary !",
    "RPM resource",
    "Provided by",
    "index by Group",
    "RPM of Group",
    "index by Distribution",
    "RPM of Distribution",
    "index by Vendor",
    "RPM shipped by",
    "index by creation date",
    "index by installation date",
    "RPMs less than three days old",
    "RPMs less than one week old",
    "RPMs less than two weeks old",
    "RPMs less than one month old",
    "RPMs more than 1 months old",
    "RPMs installed less than three days ago",
    "RPMs installed less than one week ago",
    "RPMs installed less than two weeks ago",
    "RPMs installed less than one month ago",
    "RPMs installed more than 1 months ago",
    "index by Name",
    "No description !",
    "Unknown",
    "None",
    "unknown/group",
    "unknown.host",
    "Index",
    "Packages beginning with letter",
    "Warning: this package does not export valid resources lists",
    "Try to pick another",
    "More",
    "Changelog",
    "Sub Directories",
    "Tree.html",
    "Browse the distribution tree",
    "<form action=\"%s/search.php?query=\" enctype=\"application/x-www-form-urlencoded\" method=\"GET\">\n\
<input name=\"query\" type=\"TEXT\" size=\"40\" value=\"\">\n\
    <input name=submit type=submit value=\"Search ...\">\n\
    </form>\n",
    "Signatures",
    "<p>Available as <a href=\"rdf\">an rdf channel</a></p>\n"
};

#define NB_STRINGS (sizeof(localizedStrings)/sizeof(char *))

/****************************************************************
 *								*
 *		The language file parser			*
 *								*
 ****************************************************************/

/*
 * A few macro needed to help building the parser
 */

#define IS_BLANK(ptr) \
     (((*(ptr)) == ' ') || ((*(ptr)) == '\b') || \
      ((*(ptr)) == '\n') || ((*(ptr)) == '\r'))
#define SKIP_BLANK(ptr) \
     { while (((*(ptr)) == ' ') || ((*(ptr)) == '\b') || \
              ((*(ptr)) == '\n') || ((*(ptr)) == '\r')) ptr++; }
#define GOTO_EQL(ptr) \
     { while (((*(ptr)) != '\0') && ((*(ptr)) != '=') && \
              ((*(ptr)) != '\n') && ((*(ptr)) != '\r')) ptr++; }
#define GOTO_EOL(ptr) \
     { while (((*(ptr)) != '\0') && \
              ((*(ptr)) != '\n') && ((*(ptr)) != '\r')) ptr++; }


/*
 * parse a language file
 */
int readLanguageFile(char *filename)
{
    FILE *input;
    char *str;
    char line[1000];
    char buffer[50000];
    int currentString;
    int len;

    input = fopen(filename, "r");
    if (input == NULL) {
	fprintf(stderr, "Cannot read language from %s :\n", filename);
	perror("fopen failed");
	return -1;
    }

    /*
     * all the localized strings are filled in one after the other.
     */
    buffer[0] = '\0';
    currentString = 0;

    while (1) {
	/*
	 * read one line
	 */
	if (fgets(&line[0], sizeof(line) - 1, input) == NULL)
	    break;

	str = &line[0];
	line[sizeof(line) - 1] = '\0';
	len = strlen(line);
	if ((len > 0) && (line[len - 1] == '\n'))
	    line[len - 1] = '\0';
	SKIP_BLANK(str)

	/*
	 * Comment starts with a semicolumn.
	 */
	if (*str == ';')
	continue;

	/*
	 * an empty line is a field separator.
	 */
	if (*str == '\0') {
	    if (buffer[0] != '\0') {
	        /*
		 * Check for localizedStrings overflow.
		 */
		if (currentString >= NB_STRINGS) {
		    fprintf(stderr,
	      "File %s contains too many localized messages (%d expected)\n",
		      filename, NB_STRINGS);
		    break;
		}

		/*
		 * the last paragraph correspond to the new localized
		 * string. Replace the old one and reset the buffer.
		 */
		localizedStrings[currentString] = xmlStrdup(buffer);
		currentString++;
		buffer[0] = '\0';
	    }
	    continue;
	}

	/*
	 * Aggregate the current line to the buffer.
	 */
	if (buffer[0] == '\0')
	    strcpy(buffer, line);
	else {
	    /*
	     * this is a multiline text field
	     */
	    strcat(buffer, "\n");
	    strcat(buffer, line);
	}
    }

    fclose(input);
    return (0);
}

/*
 * dump the internal set of string to an external language file.
 */
int writeLanguageFile(char *filename)
{
    FILE *output;
    int currentString;

    output = fopen(filename, "w");
    if (output == NULL) {
	fprintf(stderr, "Cannot write language to %s :\n", filename);
	perror("fopen failed");
	return -1;
    }
    fprintf(output, ";\n; Automatically generated %s %s language file\n;\n",
            RPM2HTML_NAME, RPM2HTML_VER);
    for (currentString = 0; currentString < NB_STRINGS; currentString++) {
	fprintf(output, "%s\n\n", localizedStrings[currentString]);
    }
    fclose(output);
    return (0);
}

