
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#include <stdio.h>
#include <stdlib.h>

#include "roy.h"

#define USE_ROY 1

#ifdef USE_ROY
#define ALLOC(size) rchunk_alloc(size)
#define FREE(ptr, size) rchunk_free(ptr, size)

#else

#define ALLOC(size) malloc(size)
#define FREE(ptr, size) free(ptr)

#endif

int main (void)
{
    int i;
    int a;
    int size = 4;
    char *block[8192];

    rinit ();

    for (a = 0; a < 10; a++) {
        for (size = 2; size <= 64; size++) {
            for (i = 0; i < 2; i++) {
                block[i] = ALLOC (size);
            }
            for (i = 0; i < 2; i++) {
                FREE (block[i], size);
            }
        }
    }

    rcleanup ();

    return (0);
}

