
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <roy.h>


typedef struct {
    int id;
    int id2;
} MyInfo;

int main (void)
{
    MyInfo *info;
    RArray *array;
    int i, a;
    int *f;

    rinit ();

    for (a = 0; a < 2000; a++) {

        array = rarray_new (sizeof (MyInfo), 256);

        for (i = 0; i < 2000; i++) {
            info = rarray_append (array);
            /* printf ("reading: info is '%p'\n", info); */
            info->id = i;
            info->id2 = 0;
        }

        RARRAY_FOREACH (array, info) {
            /* printf ("writing: info is '%p'\n", info); */
            info->id++;
            info->id2++;
        } RFOREACH_CLOSE;


        rarray_free (array);
    }

    array = rarray_new (sizeof (int), 5);

    printf ("pushing: ");
    for (a = 0; a < 20; a++) {
        f = rarray_push (array);
        *f = a;
        printf ("%d ", a);
    }
    printf ("\n");

    printf ("popping: ");
    do {
        f = rarray_pop (array);
        if (f)
            printf ("%d ", *f);
    } while (f);
    printf ("\n");

    printf ("pushing: ");
    for (a = 0; a < 20; a++) {
        f = rarray_push (array);
        *f = a;
        printf ("%d ", a);
    }
    printf ("\n");
    
    f = rarray_nth (array, 5);
    printf ("testing nth - 5th is %d, ", *f);
    f = rarray_nth (array, 17);
    printf ("17th is %d\n", *f);

    printf ("array length is %u\n", rarray_len (array));

    printf ("popping: ");
    do {
        f = rarray_pop (array);
        if (f)
            printf ("%d ", *f);
    } while (f);
    printf ("\n");
    printf ("array length is %u\n", rarray_len (array));

    rarray_free (array);

    rcleanup ();

    return (0);
}


