// @(#)root/mathmore:$Id: AllIntegrationTypes.h 21503 2007-12-19 17:34:54Z moneta $
// Author: Magdalena Slawinska  10/2007

 /**********************************************************************
  *                                                                    *
  * Copyright (c) 2007 ROOT Foundation,  CERN/PH-SFT                   *
  *                                                                    *
  *                                                                    *
  **********************************************************************/


// Integration types for
// one and multidimensional integration
// eith a common interface

#ifndef ROOT_Math_AllIntegrationTypes
#define ROOT_Math_AllIntegrationTypes



namespace ROOT {
namespace Math {


    // type of integration


  
    //for 1-dim integration
  namespace IntegrationOneDim {


    /**
	 enumeration specifying the integration types.
	 <ul>
	 <li>NONADAPTIVE : to be used for smooth functions
	 <li>ADAPTIVE : to be used for general functions without singularities.
	 <li>ADAPTIVESINGULAR: default adaptive integration type which can be used in the case of the presence of singularities.
	 </ul>
	 @ingroup Integration
    */
     enum Type {ADAPTIVE, ADAPTIVESINGULAR, NONADAPTIVE};

  }

    //for multi-dim integration
  namespace IntegrationMultiDim {


    /**
	 enumeration specifying the integration types.
	 <ul>
         <li>ADAPTIVE : adaptive multi-dimensional integration
	 <li>PLAIN    MC integration
	 <li>MISER    MC integration 
	 <li>VEGAS    MC integration
	 </ul>
	 @ingroup MCIntegration
    */

     enum Type {ADAPTIVE, VEGAS, MISER, PLAIN};

  }  


} // namespace Math
} // namespace ROOT

#endif /* ROOT_Math_AllIntegrationTypes */
