/* 
 * ------------------------------------------------------------------
 * Role PlayingDB V2.0 by Deepwoods Software
 * ------------------------------------------------------------------
 * Spells.cc - Spell classes
 * Created by Robert Heller on Thu Jul 30 09:37:16 1998
 * ------------------------------------------------------------------
 * Modification History: 
 * $Log: Spells.cc,v $
 * Revision 1.3  1998/08/08 21:22:33  heller
 * Small typo
 *
 * Revision 1.2  1998/08/04 23:45:38  heller
 * Minor typo.
 *
 * Revision 1.1  1998/08/04 21:17:00  heller
 * Initial revision
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing DB -- A database package that creates and maintains
 * 		       a database of RPG characters, monsters, treasures,
 * 		       spells, and playing environments.
 * 
 *     Copyright (C) 1995,1998  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

#include <Spells.h>
#include <stdio.h>

static char rcsid[] = "$Id: Spells.cc,v 1.3 1998/08/08 21:22:33 heller Rel1 $";

static unsigned char htob(const char *str)
{
	unsigned char result = 0;
	int nib;	
	while (*str) {
		if (*str >= '0' && *str <= '9')
		{
			nib = *str - '0';
		} else if (*str >= 'A' && *str <= 'F')
		{
			nib = (*str - 'A') + 10;
		} else if (*str >= 'a' && *str <= 'f')
		{
			nib = (*str - 'a') + 10;
		} else break;
		str++;
		result = (result * 16) + nib;
	}
	return result;
}


void Spell::RecordToSpell ()
{
	register char* str = rawData.buffer;	// Data string
	register int   bytesleft = rawData.size; // Number of bytes

	spclass = NULL;
	name = NULL;
	sptype = NULL;
	description = NULL;
	area = NULL;
	casttime = NULL;
	duration = NULL;
	savethrow = NULL;
	level = 0;
	range = 0;
	flags.byte = 0;
	// while bytes remain...
	while (bytesleft > 0) {
		// scan for field specifier
		while (*str != '%' && bytesleft > 0) { str++; bytesleft--; }
		// skip over specified prefix
		str++; bytesleft--;
		// while there still are bytes...
		if (bytesleft <= 0) break;
		// fan out based on field key
		switch (*str++) {
			case 'n': name = str; break;
			case 'C': spclass = str; break;
			case 't': sptype = str; break;
			case 'd': description = str; break;
			case 'a': area = str; break;
			case 'T': casttime = str; break;
			case 'D': duration = str; break;
			case 's': savethrow = str; break;
			case 'l': level = atol(str); break;
			case 'R': range = atol(str); break;
			case 'F': flags.byte = htob(str); break;
		}
		// count specifier
		bytesleft--;
		// find strlen plus nul byte
		int slen = strlen(str) + 1;
		// update counter and pointer
		bytesleft -= slen;
		str += slen;
		// EOR marker?
		if (*str == '\n') break;
	}
}

void Spell::UpdateRecord()
{
	static char levelS[12], rangeS[12], flagsS[4];
	// form numeric strings
	sprintf(levelS,"%d",level);
	sprintf(rangeS,"%d",range);
	sprintf(flagsS,"%02x",flags.byte);
	int rsize = 7 + 		// "*Spell\0"
		strlen(levelS) + 3 + 	// "%lnnn\0"
		strlen(rangeS) + 3 + 	// "%Rnnn\0"
		strlen(flagsS) + 3 +    // "%FXX\0"
		((name)?(strlen(name)):(0)) + 3 + // "%nxxx\0"
		((spclass)?(strlen(spclass)):(0)) + 3 + // "%Cxxx\0"
		((sptype)?(strlen(sptype)):(0)) + 3 + // "%txxx\0"
		((description)?(strlen(description)):(0)) + 3 + // "%dxxx\0"
		((area)?(strlen(area)):(0)) + 3 + // "%axxx\0"
		((casttime)?(strlen(casttime)):(0)) + 3 + // "%Txxx\0"
		((duration)?(strlen(duration)):(0)) + 3 + // "%Dxxx\0"
		((savethrow)?(strlen(savethrow)):(0)) + 3 + // "%sxxx\0"
		strlen("\n") + 1;               // "\n\0"
	// allocate a string
	char* str = new char[rsize]; char* p = str;
	strcpy(p,"*Spell"); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'l'; strcpy(p,levelS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'R'; strcpy(p,rangeS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'F'; strcpy(p,flagsS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'n'; if (name) strcpy(p,name); else strcpy(p,""); name = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'C'; if (spclass) strcpy(p,spclass); else strcpy(p,""); spclass = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 't'; if (sptype) strcpy(p,sptype); else strcpy(p,""); sptype = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'D'; if (description) strcpy(p,description); else strcpy(p,""); description = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'a'; if (area) strcpy(p,area); else strcpy(p,""); area = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'T'; if (casttime) strcpy(p,casttime); else strcpy(p,""); casttime = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'D'; if (duration) strcpy(p,duration); else strcpy(p,""); duration = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 's'; if (savethrow) strcpy(p,savethrow); else strcpy(p,""); savethrow = p;p += strlen(p) + 1;
	*p++ = '\n'; *p++ = 0;
	// free up old buffer
	rawData.NewBuffer(0);
	// paste in new buffer
	rawData.size = rsize;
	rawData.buffer = str;
}


