/*
 * robwxhist.h
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

// History panel for visualization

#ifndef __RT_WX_HISTORY__
#define __RT_WX_HISTORY__

#include <wx/wx.h>

class RoboTourEvent;

class HistoryCtrl : public wxControl 
{
public:
	HistoryCtrl(wxWindow* parent, wxWindowID id, const wxPoint& pos, const wxSize& size);
	~HistoryCtrl();

	void SetMaximum(int max);
	void ClearHistory();
	void UpdateFrom(RoboTourEvent&);

	DECLARE_EVENT_TABLE()
protected:
	wxSize DoGetBestSize();
private:
	void EnsureSize(const wxSize&);
	void Paint(wxDC& dc);

	void OnSize(wxSizeEvent&);
	void OnEraseBackground(wxEraseEvent&) { /* do nothing */ }
	void OnPaint(wxPaintEvent&);

	int max;
	int screenPos, bmpPos;
	wxBitmap* buf;
	int lastCycle, minInterval; 
};



#endif
