# Automatically generated....
raise 'Must be invoked by installation process' unless $opfile

# -----------------------------------------
aClass = ClassModule.new("IO", "Object", "class")
aClass.addSubclasses(%w{File})
aClass.addFragment(Paragraph.new("Class <code>IO</code> is the basis for all input and output in Ruby. An I/O stream may be <em>duplexed</em> (that is, bidirectional), and so may use more than one native operating system stream.\n"))
aClass.addFragment(Paragraph.new("Many of the examples in this section use class <code>File</code>, the only standard subclass of <code>IO</code>. The two classes are closely associated.\n"))
aClass.addFragment(Paragraph.new("As used in this section, <em>aPortname</em> may take any of the following forms.\n"))
aClass.addFragment(Paragraph.new("* A plain string represents a filename suitable for the underlying operating system.\n"))
aClass.addFragment(Paragraph.new("* A string starting with ``<code>|</code>'' indicates a subprocess. The remainder of the string following the ``<code>|</code>'' is invoked as a process with appropriate input/output channels connected to it.\n"))
aClass.addFragment(Paragraph.new("* A string equal to ``<code>|-</code>'' will create another Ruby instance as a subprocess.\n"))
aClass.addFragment(Paragraph.new("Ruby will convert pathnames between different operating system conventions if possible. For instance, on a Windows system the filename ``<code>/gumby/ruby/test.rb</code>'' will be opened as ``<code>\\gumby\\ruby\\test.rb</code>''. When specifying a Windows-style filename in a Ruby string, remember to escape the backslashes:\n"))
aClass.addFragment(Verbatim.new("\"c:\\\\gumby\\\\ruby\\\\test.rb\""))
aClass.addFragment(Paragraph.new("Our examples here will use the Unix-style forward slashes; <code>File::SEPARATOR</code> can be used to get the platform-specific separator character.\n"))
aClass.addFragment(Paragraph.new("I/O ports may be opened in any one of several different modes, which are shown in this section as <em>aModeString</em>. This mode string must be one of the values listed in Table 22.5 on page 331.\n"))
m0002 = MethodDesc.new("foreach", "class", "IO.foreach( <i>aPortName</i>, <i>aSepString</i>=<code>$/</code> ) {| line | block } -> <code>nil</code>")
m0002.addFragment(Paragraph.new("Executes the block for every line in the named I/O port, where lines are separated by <em>aSepString</em>.\n"))
m0002.addFragment(Verbatim.new("IO.foreach(\"testfile\") {|x| print \"GOT \", x }"))
m0002.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0002.addFragment(Verbatim.new("GOT This is line one\nGOT This is line two\nGOT This is line three\nGOT And so on..."))
aClass.addMethod(m0002)
m0003 = MethodDesc.new("new", "class", "IO.new( <i>anInteger</i>, <i>aModeString</i> ) -> <i>aFile</i>")
m0003.addFragment(Paragraph.new("Returns a new <code>File</code> object (a stream) for the given integer file descriptor and mode string. See also <code>IO\#fileno</code>.\n"))
m0003.addFragment(Verbatim.new("a = IO.new(2,\"w\")      \# '2' is standard error\n$stderr.puts \"Hello\"\na.puts \"World\""))
m0003.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0003.addFragment(Verbatim.new("Hello\nWorld"))
aClass.addMethod(m0003)
m0004 = MethodDesc.new("pipe", "class", "IO.pipe -> <i>anArray</i>")
m0004.addFragment(Paragraph.new("Creates a pair of pipe endpoints (connected to each other) and returns them as a two-element array of <code>IO</code> objects: <code>[</code> <i>readFile</i>, <i>writeFile</i> <code>]</code>. Not available on all platforms.\n"))
m0004.addFragment(Paragraph.new("In the example below, the two processes close the ends of the pipe that they are not using. This is not just a cosmetic nicety. The read end of a pipe will not generate an end of file condition if there are any writers with the pipe still open. In the case of the parent process, the <code>rd.read</code> will never return if it does not first issue a <code>wr.close</code>.\n"))
m0004.addFragment(Verbatim.new("rd, wr = IO.pipe\n\n\nif fork\n  wr.close\n  puts \"Parent got: <\#{rd.read}>\"\n  rd.close\n  Process.wait\nelse\n  rd.close\n  puts \"Sending message to parent\"\n  wr.write \"Hi Dad\"\n  wr.close\nend"))
m0004.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0004.addFragment(Verbatim.new("Sending message to parent\nParent got: <Hi Dad>"))
aClass.addMethod(m0004)
m0005 = MethodDesc.new("popen", "class", "IO.popen( <i>aCmdString</i>, <i>aModeString</i>=\"r\" ) -> <i>anIO</i><br></br>IO.popen( <i>aCmdString</i>, <i>aModeString</i>=\"r\" ) {| anIO | block } -> <code>nil</code>")
m0005.addFragment(Paragraph.new("Runs the specified command string as a subprocess; the subprocess's standard input and output will be connected to the returned <code>IO</code> object. If <i>aCmdString</i> starts with a ``<code>-</code>'', then a new instance of Ruby is started as the subprocess. The default mode for the new file object is ``r'', but <i>aModeString</i> may be set to any of the modes in Table 22.5 on page 331.\n"))
m0005.addFragment(Paragraph.new("If a block is given, Ruby will run the command as a child connected to Ruby with a pipe. Ruby's end of the pipe will be passed as a parameter to the block.\n"))
m0005.addFragment(Paragraph.new("If a block is given with a <i>aCmdString</i> of ``<code>-</code>'', the block will be run in two separate processes: once in the parent, and once in a child. The parent process will be passed the pipe object as a parameter to the block, the child version of the block will be passed <code>nil</code>, and the child's standard in and standard out will be connected to the parent through the pipe. Not available on all platforms.\n"))
m0005.addFragment(Verbatim.new("f = IO.popen(\"uname\")\np f.readlines\nputs \"Parent is \#{Process.pid}\"\nIO.popen (\"date\") { |f| puts f.gets }\nIO.popen(\"-\") {|f| $stderr.puts \"\#{Process.pid} is here, f is \#{f}\"}"))
m0005.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0005.addFragment(Verbatim.new("[\"Linux\\n\"]\nParent is 15506\nSun Mar  4 23:28:51 CST 2001\n15509 is here, f is\n15506 is here, f is \#<IO:0x4018d518>"))
aClass.addMethod(m0005)
m0006 = MethodDesc.new("readlines", "class", "IO.readlines( <i>aPortName</i>, <i>aSepString</i>=<code>$/</code> ) -> <i>anArray</i>")
m0006.addFragment(Paragraph.new("Reads the entire file specified by <i>aPortName</i> as individual lines, and returns those lines in an array. Lines are separated by <i>aSepString</i>.\n"))
m0006.addFragment(Verbatim.new("a = IO.readlines(\"testfile\")\na[0]   \#=> \"This is line one\\n\"\n"))
aClass.addMethod(m0006)
m0007 = MethodDesc.new("select", "class", "IO.select( <i>readArray</i> <i>[</i>, <i>writeArray</i> <i>[</i><i>errorArray</i> <i>[</i><i>timeout</i><i>]</i><i>]</i><i>]</i> ) -> <i>anArray</i><br></br>or <code>nil</code>")
m0007.addFragment(Paragraph.new("See <code>Kernel\#select</code> on page 426.\n"))
aClass.addMethod(m0007)
m0008 = MethodDesc.new("<<", "instance", "<em>ios</em> << <i>anObject</i> -> <em>ios</em>")
m0008.addFragment(Paragraph.new("String Output---Writes <i>anObject</i> to <em>ios</em>. <i>anObject</i> will be converted to a string using <code>to_s</code>.\n"))
m0008.addFragment(Verbatim.new("$stdout << \"Hello \" << \"world!\\n\""))
m0008.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0008.addFragment(Verbatim.new("Hello world!"))
aClass.addMethod(m0008)
m0009 = MethodDesc.new("binmode", "instance", "<em>ios</em>.binmode -> <em>ios</em>")
m0009.addFragment(Paragraph.new("Puts <em>ios</em> into binary mode. This is useful only in MS-DOS/Windows environments. Once a stream is in binary mode, it cannot be reset to nonbinary mode.\n"))
aClass.addMethod(m0009)
m0010 = MethodDesc.new("clone", "instance", "<em>ios</em>.clone -> <i>anIO</i>")
m0010.addFragment(Paragraph.new("Creates a new I/O stream, copying all the attributes of <em>ios</em>. The file position is shared as well, so reading from the clone will alter the file position of the original, and vice-versa.\n"))
aClass.addMethod(m0010)
m0011 = MethodDesc.new("close", "instance", "<em>ios</em>.close -> <code>nil</code>")
m0011.addFragment(Paragraph.new("Closes <em>ios</em> and flushes any pending writes to the operating system. The stream is unavailable for any further data operations; an <code>IOError</code> is raised if such an attempt is made. I/O streams are automatically closed when they are claimed by the garbage collector.\n"))
aClass.addMethod(m0011)
m0012 = MethodDesc.new("close_read", "instance", "<em>ios</em>.close_read -> <code>nil</code>")
m0012.addFragment(Paragraph.new("Closes the read end of a duplex I/O stream (i.e., one that contains both a read and a write stream, such as a pipe). Will raise an <code>IOError</code> if the stream is not duplexed.\n"))
m0012.addFragment(Verbatim.new("f = IO.popen(\"/bin/sh\",\"r+\")\nf.close_read\nf.readlines"))
m0012.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0012.addFragment(Verbatim.new("prog.rb:3:in `readlines': not opened for reading (IOError)\n\tfrom prog.rb:3"))
aClass.addMethod(m0012)
m0013 = MethodDesc.new("close_write", "instance", "<em>ios</em>.close_write -> <code>nil</code>")
m0013.addFragment(Paragraph.new("Closes the write end of a duplex I/O stream (i.e., one that contains both a read and a write stream, such as a pipe). Will raise an <code>IOError</code> if the stream is not duplexed.\n"))
m0013.addFragment(Verbatim.new("f = IO.popen(\"/bin/sh\",\"r+\")\nf.close_write\nf.print \"nowhere\""))
m0013.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0013.addFragment(Verbatim.new("prog.rb:3:in `write': not opened for writing (IOError)\n\tfrom prog.rb:3:in `print'\n\tfrom prog.rb:3"))
aClass.addMethod(m0013)
m0014 = MethodDesc.new("closed?", "instance", "<em>ios</em>.closed? -> <code>true</code> or <code>false</code>")
m0014.addFragment(Paragraph.new("Returns <code>true</code> if <em>ios</em> is completely closed (for duplex streams, both reader and writer), <code>false</code> otherwise.\n"))
m0014.addFragment(Verbatim.new("f = File.new(\"testfile\")\nf.close         \#=> nil\nf.closed?       \#=> true\nf = IO.popen(\"/bin/sh\",\"r+\")\nf.close_write   \#=> nil\nf.closed?       \#=> false\nf.close_read    \#=> nil\nf.closed?       \#=> true\n"))
aClass.addMethod(m0014)
m0015 = MethodDesc.new("each", "instance", "<em>ios</em>.each( <i>aSepString</i>=<code>$/</code> ) {| line | block } -> <em>ios</em>")
m0015.addFragment(Paragraph.new("Executes the block for every line in <em>ios</em>, where lines are separated by <i>aSepString</i>. <em>ios</em> must be opened for reading or an <code>IOerror</code> will be raised.\n"))
m0015.addFragment(Verbatim.new("f = File.new(\"testfile\")\nf.each {|line| puts \"\#{f.lineno}: \#{line}\" }"))
m0015.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0015.addFragment(Verbatim.new("1: This is line one\n2: This is line two\n3: This is line three\n4: And so on..."))
aClass.addMethod(m0015)
m0016 = MethodDesc.new("each_byte", "instance", "<em>ios</em>.each_byte {| byte | block } <p></p> -> <code>nil</code>")
m0016.addFragment(Paragraph.new("Calls the given block once for each byte (0..255) in <em>ios</em>, passing the byte as an argument. The stream must be opened for reading or an <code>IOerror</code> will be raised.\n"))
m0016.addFragment(Verbatim.new("f = File.new(\"testfile\")\nchecksum = 0\nf.each_byte {|x| checksum ^= x }   \#=> nil\nchecksum                           \#=> 12\n"))
aClass.addMethod(m0016)
m0017 = MethodDesc.new("each_line", "instance", "<em>ios</em>.each_line( <i>aSepString</i>=<code>$/</code> ) {| line | block } <p></p> -> <em>ios</em>")
m0017.addFragment(Paragraph.new("Synonym for <code>IO\#each</code>.\n"))
aClass.addMethod(m0017)
m0018 = MethodDesc.new("eof", "instance", "<em>ios</em>.eof -> <code>true</code> or <code>false</code>")
m0018.addFragment(Paragraph.new("Returns true if <em>ios</em> is at end of file. The stream must be opened for reading or an <code>IOError</code> will be raised.\n"))
m0018.addFragment(Verbatim.new("f = File.new(\"testfile\")\ndummy = f.readlines\nf.eof   \#=> true\n"))
aClass.addMethod(m0018)
m0019 = MethodDesc.new("eof?", "instance", "<em>ios</em>.eof? -> <code>true</code> or <code>false</code>")
m0019.addFragment(Paragraph.new("Synonym for <code>IO\#eof</code>.\n"))
aClass.addMethod(m0019)
m0020 = MethodDesc.new("fcntl", "instance", "<em>ios</em>.fcntl( <i>anIntegerCmd</i>, <i>anArg</i> ) -> <i>anInteger</i>")
m0020.addFragment(Paragraph.new("Provides a mechanism for issuing low-level commands to control or query file-oriented I/O streams. Arguments and results are platform dependent. If <i>anArg</i> is a number, its value is passed directly. If it is a string, it is interpreted as a binary sequence of bytes. On Unix platforms, see <code>fcntl(2)</code> for details. Not implemented on all platforms.\n"))
aClass.addMethod(m0020)
m0021 = MethodDesc.new("fileno", "instance", "<em>ios</em>.fileno -> <i>aFixnum</i>")
m0021.addFragment(Paragraph.new("Returns an integer representing the numeric file descriptor for <em>ios</em>.\n"))
m0021.addFragment(Verbatim.new("$stdin.fileno    \#=> 0\n$stdout.fileno   \#=> 1\n"))
aClass.addMethod(m0021)
m0022 = MethodDesc.new("flush", "instance", "<em>ios</em>.flush -> <em>ios</em>")
m0022.addFragment(Paragraph.new("Flushes any buffered data within <em>ios</em> to the underlying operating system (note that this is Ruby internal buffering only; the OS may buffer the data as well).\n"))
m0022.addFragment(Verbatim.new("$stdout.print \"no newline\"\n$stdout.flush"))
m0022.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0022.addFragment(Verbatim.new("no newline"))
aClass.addMethod(m0022)
m0023 = MethodDesc.new("getc", "instance", "<em>ios</em>.getc -> <i>aFixnum</i> or <code>nil</code>")
m0023.addFragment(Paragraph.new("Gets the next 8-bit byte (0..255) from <em>ios</em>. Returns <code>nil</code> if called at end of file.\n"))
m0023.addFragment(Verbatim.new("f = File.new(\"testfile\")\nf.getc   \#=> 84\nf.getc   \#=> 104\n"))
aClass.addMethod(m0023)
m0024 = MethodDesc.new("gets", "instance", "<em>ios</em>.gets( <i>aSepString</i>=<code>$/</code> ) -> <i>aString</i> or <code>nil</code>")
m0024.addFragment(Paragraph.new("Reads the next ``line'' from the I/O stream; lines are separated by <i>aSepString</i>. A separator of <code>nil</code> reads the entire contents, and a zero-length separator reads the input a paragraph at a time (two successive newlines in the input separate paragraphs). The stream must be opened for reading or an <code>IOerror</code> will be raised. The line read in will be returned and also assigned to <code>$_</code>. Returns <code>nil</code> if called at end of file.\n"))
m0024.addFragment(Verbatim.new("File.new(\"testfile\").gets   \#=> \"This is line one\\n\"\n$_                          \#=> \"This is line one\\n\"\n"))
aClass.addMethod(m0024)
m0025 = MethodDesc.new("ioctl", "instance", "<em>ios</em>.ioctl( <i>anIntegerCmd</i>, <i>anArg</i> ) -> <i>anInteger</i>")
m0025.addFragment(Paragraph.new("Provides a mechanism for issuing low-level commands to control or query I/O devices. Arguments and results are platform dependent. If <i>anArg</i> is a number, its value is passed directly. If it is a string, it is interpreted as a binary sequence of bytes. On Unix platforms, see <code>ioctl(2)</code> for details. Not implemented on all platforms.\n"))
aClass.addMethod(m0025)
m0026 = MethodDesc.new("isatty", "instance", "<em>ios</em>.isatty -> <code>true</code> or <code>false</code>")
m0026.addFragment(Paragraph.new("Returns <code>true</code> if <em>ios</em> is associated with a terminal device (tty), <code>false</code> otherwise.\n"))
m0026.addFragment(Verbatim.new("File.new(\"testfile\").isatty   \#=> false\nFile.new(\"/dev/tty\").isatty   \#=> true\n"))
aClass.addMethod(m0026)
m0027 = MethodDesc.new("lineno", "instance", "<em>ios</em>.lineno -> <i>anInteger</i>")
m0027.addFragment(Paragraph.new("Returns the current line number in <em>ios</em>. The stream must be opened for reading. <code>lineno</code> counts the number of times <code>gets</code> is called, rather than the number of newlines encountered. The two values will differ if <code>gets</code> is called with a separator other than newline. See also the <code>$.</code> variable.\n"))
m0027.addFragment(Verbatim.new("f = File.new(\"testfile\")\nf.lineno   \#=> 0\nf.gets     \#=> \"This is line one\\n\"\nf.lineno   \#=> 1\nf.gets     \#=> \"This is line two\\n\"\nf.lineno   \#=> 2\n"))
aClass.addMethod(m0027)
m0028 = MethodDesc.new("lineno=", "instance", "<em>ios</em>.lineno = <i>anInteger</i> -> <i>anInteger</i>")
m0028.addFragment(Paragraph.new("Manually sets the current line number to the given value. <code>$.</code> is updated only on the next read.\n"))
m0028.addFragment(Verbatim.new("f = File.new(\"testfile\")\nf.gets                     \#=> \"This is line one\\n\"\n$.                         \#=> 1\nf.lineno = 1000\nf.lineno                   \#=> 1000\n$. \# lineno of last read   \#=> 1\nf.gets                     \#=> \"This is line two\\n\"\n$. \# lineno of last read   \#=> 1001\n"))
aClass.addMethod(m0028)
m0029 = MethodDesc.new("pid", "instance", "<em>ios</em>.pid -> <i>aFixnum</i>")
m0029.addFragment(Paragraph.new("Returns the process ID of a child process associated with <em>ios</em>. This will be set by <code>IO::popen</code>.\n"))
m0029.addFragment(Verbatim.new("pipe = IO.popen(\"-\")\nif pipe\n  $stderr.puts \"In parent, child pid is \#{pipe.pid}\"\nelse\n  $stderr.puts \"In child, pid is \#{$$}\"\nend"))
m0029.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0029.addFragment(Verbatim.new("In parent, child pid is 15545\nIn child, pid is 15545"))
aClass.addMethod(m0029)
m0030 = MethodDesc.new("pos", "instance", "<em>ios</em>.pos -> <i>anInteger</i>")
m0030.addFragment(Paragraph.new("Returns the current offset (in bytes) of <em>ios</em>.\n"))
m0030.addFragment(Verbatim.new("f = File.new(\"testfile\")\nf.pos    \#=> 0\nf.gets   \#=> \"This is line one\\n\"\nf.pos    \#=> 17\n"))
aClass.addMethod(m0030)
m0031 = MethodDesc.new("pos=", "instance", "<em>ios</em>.pos = <i>anInteger</i> -> 0")
m0031.addFragment(Paragraph.new("Seeks to the given position (in bytes) in <em>ios</em>.\n"))
m0031.addFragment(Verbatim.new("f = File.new(\"testfile\")\nf.pos = 17\nf.gets   \#=> \"This is line two\\n\"\n"))
aClass.addMethod(m0031)
m0032 = MethodDesc.new("print", "instance", "<em>ios</em>.print( <i>[</i><i>anObject</i>=<code>$_</code><i>]*</i> ) -> <code>nil</code>")
m0032.addFragment(Paragraph.new("Writes the given object(s) to <em>ios</em>. The stream must be opened for writing. If the output record separator (<code>$\\</code>) is not <code>nil</code>, it will be appended to the output. If no arguments are given, prints <code>$_</code>. Objects that aren't strings will be converted by calling their <code>to_s</code> method. Returns <code>nil</code>.\n"))
m0032.addFragment(Verbatim.new("$stdout.print(\"This is \", 100, \" percent.\\n\")"))
m0032.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0032.addFragment(Verbatim.new("This is 100 percent."))
aClass.addMethod(m0032)
m0033 = MethodDesc.new("printf", "instance", "<em>ios</em>.printf( <i>aFormatString</i> <i>[</i>, <i>anObject</i><i>]*</i> ) -> <code>nil</code>")
m0033.addFragment(Paragraph.new("Formats and writes to <em>ios</em>, converting parameters under control of the format string. See <code>Kernel\#sprintf</code> on page 427 for details.\n"))
aClass.addMethod(m0033)
m0034 = MethodDesc.new("putc", "instance", "<em>ios</em>.putc( <i>anObject</i> ) -> <i>anObject</i>")
m0034.addFragment(Paragraph.new("Writes the given character (taken from a <code>String</code> or a <code>Fixnum</code>) on <em>ios</em>.\n"))
m0034.addFragment(Verbatim.new("$stdout.putc \"A\"\n$stdout.putc 65"))
m0034.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0034.addFragment(Verbatim.new("AA"))
aClass.addMethod(m0034)
m0035 = MethodDesc.new("puts", "instance", "<em>ios</em>.puts( <i>[</i><i>anObject</i><i>]*</i> ) -> <code>nil</code>")
m0035.addFragment(Paragraph.new("Writes the given objects to <em>ios</em> as with <code>IO\#print</code>. Writes a record separator (typically a newline) after any that do not already end with a newline sequence. If called with an array argument, writes each element on a new line. If called without arguments, outputs a single record separator.\n"))
m0035.addFragment(Verbatim.new("$stdout.puts(\"this\", \"is\", \"a\", \"test\")"))
m0035.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0035.addFragment(Verbatim.new("this\nis\na\ntest"))
aClass.addMethod(m0035)
m0036 = MethodDesc.new("read", "instance", "<em>ios</em>.read( <i>[</i><i>anInteger</i><i>]</i> ) -> <i>aString</i> or <code>nil</code>")
m0036.addFragment(Paragraph.new("Reads at most <i>anInteger</i> bytes from the I/O stream, or to the end of file if <i>anInteger</i> is omitted. Returns <code>nil</code> if called at end of file.\n"))
m0036.addFragment(Verbatim.new("f = File.new(\"testfile\")\nf.read(16)   \#=> \"This is line one\"\n"))
aClass.addMethod(m0036)
m0037 = MethodDesc.new("readchar", "instance", "<em>ios</em>.readchar -> <i>aFixnum</i>")
m0037.addFragment(Paragraph.new("Reads a character as with <code>IO\#getc</code>, but raises an <code>EOFError</code> on end of file.\n"))
aClass.addMethod(m0037)
m0038 = MethodDesc.new("readline", "instance", "<em>ios</em>.readline( <i>aSepString</i>=<code>$/</code> ) -> <i>aString</i>")
m0038.addFragment(Paragraph.new("Reads a line as with <code>IO\#gets</code>, but raises an <code>EOFError</code> on end of file.\n"))
aClass.addMethod(m0038)
m0039 = MethodDesc.new("readlines", "instance", "<em>ios</em>.readlines( <i>aSepString</i>=<code>$/</code> ) -> <i>anArray</i>")
m0039.addFragment(Paragraph.new("Reads all of the lines in <em>ios</em>, and returns them in <i>anArray</i>. Lines are separated by the optional <i>aSepString</i>. The stream must be opened for reading or an <code>IOerror</code> will be raised.\n"))
m0039.addFragment(Verbatim.new("f = File.new(\"testfile\")\nf.readlines[0]   \#=> \"This is line one\\n\"\n"))
aClass.addMethod(m0039)
m0040 = MethodDesc.new("reopen", "instance", "<em>ios</em>.reopen( <i>anOtherIO</i> ) -> <em>ios</em> <br></br><em>ios</em>.reopen( <i>aPath</i>, <i>aModeStr</i> ) -> <em>ios</em>")
m0040.addFragment(Paragraph.new("Reassociates <em>ios</em> with the I/O stream given in <i>anOtherIO</i> or to a new stream opened on <i>aPath</i>. This may dynamically change the actual class of this stream.\n"))
m0040.addFragment(Verbatim.new("f1 = File.new(\"testfile\")\nf2 = File.new(\"testfile\")\nf2.readlines[0]   \#=> \"This is line one\\n\"\nf2.reopen(f1)     \#=> \#<File:0x4018d608>\nf2.readlines[0]   \#=> \"This is line one\\n\"\n"))
aClass.addMethod(m0040)
m0041 = MethodDesc.new("rewind", "instance", "<em>ios</em>.rewind -> 0")
m0041.addFragment(Paragraph.new("Positions <em>ios</em> to the beginning of input, resetting <code>lineno</code> to zero.\n"))
m0041.addFragment(Verbatim.new("f = File.new(\"testfile\")\nf.readline   \#=> \"This is line one\\n\"\nf.rewind     \#=> 0\nf.lineno     \#=> 0\nf.readline   \#=> \"This is line one\\n\"\n"))
aClass.addMethod(m0041)
m0042 = MethodDesc.new("seek", "instance", "<em>ios</em>.seek( <i>anInteger</i>, <i>whence</i>=<code>SEEK_SET</code> ) -> 0")
m0042.addFragment(Paragraph.new("Seeks to a given offset <i>anInteger</i> in the stream according to the value of <i>whence</i>:\n"))
m0042.addFragment(Verbatim.new("f = File.new(\"testfile\")\nf.seek(-13, IO::SEEK_END)   \#=> 0\nf.readline                  \#=> \"And so on...\\n\"\n"))
aClass.addMethod(m0042)
m0043 = MethodDesc.new("stat", "instance", "<em>ios</em>.stat -> <i>aStat</i>")
m0043.addFragment(Paragraph.new("Returns status information for <em>ios</em> as an object of type <code>File::Stat</code>.\n"))
m0043.addFragment(Verbatim.new("f = File.new(\"testfile\")\ns = f.stat\n\"%o\" % s.mode   \#=> \"100644\"\ns.blksize       \#=> 4096\ns.atime         \#=> Sun Mar 04 23:28:52 CST 2001\n"))
aClass.addMethod(m0043)
m0044 = MethodDesc.new("sync", "instance", "<em>ios</em>.sync -> <code>true</code> or <code>false</code>")
m0044.addFragment(Paragraph.new("Returns the current ``sync mode'' of <em>ios</em>. When sync mode is true, all output is immediately flushed to the underlying operating system and is not buffered by Ruby internally.\n"))
m0044.addFragment(Verbatim.new("f = File.new(\"testfile\")\nf.sync   \#=> false\n"))
aClass.addMethod(m0044)
m0045 = MethodDesc.new("sync=", "instance", "<em>ios</em>.sync = <i>aBoolean</i> -> <i>aBoolean</i>")
m0045.addFragment(Paragraph.new("Sets the ``sync mode'' to <code>true</code> or <code>false</code>. When sync mode is true, all output is immediately flushed to the underlying operating system and is not buffered internally. Returns the new state.\n"))
m0045.addFragment(Verbatim.new("f = File.new(\"testfile\")\nf.sync = true"))
aClass.addMethod(m0045)
m0046 = MethodDesc.new("sysread", "instance", "<em>ios</em>.sysread( <i>anInteger</i> ) -> <i>aString</i>")
m0046.addFragment(Paragraph.new("Reads <i>anInteger</i> bytes from <em>ios</em> using a low-level read and returns them as a string. Do not mix with other methods that read from <em>ios</em> or you may get unpredictable results. Raises <code>SystemCallError</code> on error and <code>EOFError</code> at end of file.\n"))
m0046.addFragment(Verbatim.new("f = File.new(\"testfile\")\nf.sysread(16)   \#=> \"This is line one\"\n"))
aClass.addMethod(m0046)
m0047 = MethodDesc.new("syswrite", "instance", "<em>ios</em>.syswrite( <i>aString</i> ) -> <i>anInteger</i>")
m0047.addFragment(Paragraph.new("Writes the given string to <em>ios</em> using a low-level write. Returns the number of bytes written. Do not mix with other methods that write to <em>ios</em> or you may get unpredictable results. Raises <code>SystemCallError</code> on error.\n"))
m0047.addFragment(Verbatim.new("f = File.new(\"out\", \"w\")\nf.syswrite(\"ABCDEF\")   \#=> 6\n"))
aClass.addMethod(m0047)
m0048 = MethodDesc.new("tell", "instance", "<em>ios</em>.tell -> <i>anInteger</i>")
m0048.addFragment(Paragraph.new("Synonym for <code>IO\#pos</code>.\n"))
aClass.addMethod(m0048)
m0049 = MethodDesc.new("to_i", "instance", "<em>ios</em>.to_i -> <i>anInteger</i>")
m0049.addFragment(Paragraph.new("Synonym for <code>IO\#fileno</code>.\n"))
aClass.addMethod(m0049)
m0050 = MethodDesc.new("to_io", "instance", "<em>ios</em>.to_io -> <em>ios</em>")
m0050.addFragment(Paragraph.new("Returns <em>ios</em>.\n"))
aClass.addMethod(m0050)
m0051 = MethodDesc.new("tty?", "instance", "<em>ios</em>.tty? -> <code>true</code> or <code>false</code>")
m0051.addFragment(Paragraph.new("Synonym for <code>IO\#isatty</code>.\n"))
aClass.addMethod(m0051)
m0052 = MethodDesc.new("ungetc", "instance", "<em>ios</em>.ungetc( <i>anInteger</i> ) -> <code>nil</code>")
m0052.addFragment(Paragraph.new("Pushes back one character onto <em>ios</em>, such that a subsequent buffered read will return it. Only one character may be pushed back before a subsequent read operation (that is, you will be able to read only the last of several characters that have been pushed back). Has no effect with unbuffered reads (such as <code>IO\#sysread</code>).\n"))
m0052.addFragment(Verbatim.new("f = File.new(\"testfile\")   \#=> \#<File:0x4018d66c>\nc = f.getc                 \#=> 84\nf.ungetc(c)                \#=> nil\nf.getc                     \#=> 84\n"))
aClass.addMethod(m0052)
m0053 = MethodDesc.new("write", "instance", "<em>ios</em>.write( <i>aString</i> ) -> <i>anInteger</i>")
m0053.addFragment(Paragraph.new("Writes the given string to <em>ios</em>. The stream must be opened for writing. If the argument is not a string, it will be converted to a string using <code>to_s</code>. Returns the number of bytes written.\n"))
m0053.addFragment(Verbatim.new("count = $stdout.write( \"This is a test\\n\" )\nputs \"That was \#{count} bytes of data\""))
m0053.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0053.addFragment(Verbatim.new("This is a test\nThat was 15 bytes of data"))
aClass.addMethod(m0053)

File.open($opfile, "w") {|f| Marshal.dump(aClass, f) }
