#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
SRCDIR=${SRCDIR-"."}
TOP_SRCDIR=${TOP_SRCDIR-"../.."}
DATADIR="../..//nfem/ptst"
BINDIR="../../nfem/pbin"
SBINDIR="../../nfem/sbin"
NPROC_MAX=${NPROC_MAX-"7"}
ROUNDER="../../nfem/pbin/field - -field -round"
. "${TOP_SRCDIR}/config/loop_mpirun.sh"

status=0


L="
carre-20
"

run "$SBINDIR/mkgeo_grid_2d -v4 -t 20 -a -2 -b 2 -c -2 -d 2 2>/dev/null | $BINDIR/geo -upgrade - > carre-20.geo 2>/dev/null"
#run "$SBINDIR/mkgeo_grid_2d -v4 -t 41 -a -2 -b 2 -c -2 -d 2 2>/dev/null | $BINDIR/geo -upgrade - > mesh-2d-41.geo 2>/dev/null"
#run "$SBINDIR/mkgeo_grid_3d -v4 -T 20 -a -2 -b 2 -c -2 -d 2 -f -2 -g 2  2>/dev/null| $BINDIR/geo -upgrade - > mesh-3d-20.geo 2>/dev/null"
#run "$SBINDIR/mkgeo_grid_3d -v4 -T 21 -a -2 -b 2 -c -2 -d 2 -f -2 -g 2  2>/dev/null| $BINDIR/geo -upgrade - > mesh-3d-21.geo 2>/dev/null"

for geo in $L; do
  run "rm -f $geo.band.geo.gz"
  loop_mpirun "./field_indirect_band_tst $geo.geo 2>/dev/null | $ROUNDER 2>/dev/null | diff -Bw $DATADIR/field_indirect_band_tst-${geo}.field - >/dev/null 2>/dev/null"
  if test $? -ne 0; then status=1; fi
  run "rm -f $geo.band.geo.gz"
done

run "rm -f mesh-2d-20.geo mesh-2d-41.geo mesh-3d-20.geo mesh-3d-21.geo"

exit $status
