///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// check field_expr<Expr>
#include "rheolef.h"
#include "rheolef/pretty_name.h"
using namespace rheolef;
using namespace std;

template <class Iterator>
void
check_iterator_access_raw (Iterator iter, size_t n) {
  warning_macro ("iter: expr.ndof="<<n);
  for (size_t i = 0; i < n; i++, iter++) {
    warning_macro ("iter: expr["<<i<<"] = "<<*iter);
  }
}
template <class Expr>
void
check_iterator_access (Expr e) {
  check_iterator_access_raw (e.begin_dof(), e.ndof());
}  
template <class Expr>
void
check_subscript_access (Expr e) {
  warning_macro ("sub: expr.ndof="<<e.ndof());
  for (typename Expr::size_type i = 0, n = e.ndof(); i < n; i++) {
    warning_macro ("sub: expr["<<i<<"] = "<< e.dof(i));
  }
}
struct phi : unary_function<Float,Float> {
  Float operator() (const Float& x) { return 2*x; }
};
int main(int argc, char**argv) {
    environment rheolef(argc, argv);
    geo omega (argv[1]);
    space Vh (omega, "P1");
    field x (Vh, 2.5);
    field y (Vh, 4.0);

    // set size and then assign:
    field z(Vh); 
    z = 2*x - y;
    dout << "z = 2*x-y : z.dis_size = " << z.dis_ndof() << endl;
    z.put (dout);
    
    // size is zero and then assign:
    field z1; 
    z1 = 2*x - y;
    dout << "z1.dis_size = " << z1.dis_ndof() << endl;
    z1.put (dout);
    
    // copy cstor:
    field z2 = 2*x - y;
    dout << "z2.dis_size = " << z2.dis_ndof() << endl;
    z2.put (dout);

    check_iterator_access  (x+y);
    check_subscript_access (x+y);

    // dot with expression (lazy evaluation)
    dout << "dot(x, 1) = " << dot(x, 1) << endl;
    dout << "dot(2*x-y, 1) = " << dot(2*x-y, 1) << endl;
    dout << "dot(x, z) = " << dot(x, z) << endl;
    dout << "dot(x, 2*x-y) = " << dot(x, 2*x - y) << endl;
    dout << "dot(2*x-y, x) = " << dot(2*x-y, x) << endl;
    dout << "dot(3*x-y, 2*x-y) = " << dot(3*x-y, 2*x-y) << endl;

#ifdef TO_CLEAN
    // set bad size and then assign: it may exit(1)
    space Wh (omega["left"], "P1");
    field z3(Wh); 
    z3 = 2*x - y;
    dout << "z3 = " << z3.ndof() << endl;
    z3.put (dout);
#endif // TO_CLEAN    
}
