#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "p_laplacian_fixed_point.icc"
#include "dirichlet.icc"
int main(int argc, char**argv) {
  environment rheolef (argc,argv);
  geo omega (argv[1]);
  string approx   = (argc > 2) ?      argv[2]  : "P1";
  Float  p        = (argc > 3) ? atof(argv[3]) : 1.5;
  Float tol       = (argc > 4) ? atof(argv[4]) : 1e-10;
  size_t max_iter = 500;
  derr << "# P-Laplacian problem by fixed-point:" << endl
       << "# geo = " << omega.name() << endl
       << "# approx = " << approx << endl
       << "# p = " << p << endl;
  space Xh (omega, approx);
  Xh.block ("boundary");
  field uh (Xh);
  uh ["boundary"] = 0;
  field lh = riesz (Xh, 1);
  dirichlet (lh, uh);
  int status = p_laplacian_fixed_point (p, lh, uh, tol, max_iter);
  dout << catchmark("p") << p << endl
       << catchmark("u") << uh;
  return status;
}
