#include "gtkUtils.h"
#include "gtkEnum.h"

#include "RGtk.h"

USER_OBJECT_
S_check_GtkVisibility_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"none",
		"partial",
		"full"};
  static const char * const realNames[]  = {"GTK_VISIBILITY_NONE",
		"GTK_VISIBILITY_PARTIAL",
		"GTK_VISIBILITY_FULL"};
  static const int        cValues[]      = {GTK_VISIBILITY_NONE,
	GTK_VISIBILITY_PARTIAL,
	GTK_VISIBILITY_FULL};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GtkVisibility"));
}
 

USER_OBJECT_
S_check_GdkImageType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"normal",
		"shared",
		"fastest"};
  static const char * const realNames[]  = {"GDK_IMAGE_NORMAL",
		"GDK_IMAGE_SHARED",
		"GDK_IMAGE_FASTEST"};
  static const int        cValues[]      = {GDK_IMAGE_NORMAL,
	GDK_IMAGE_SHARED,
	GDK_IMAGE_FASTEST};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GdkImageType"));
}
 

USER_OBJECT_
S_check_GtkCurveType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"linear",
		"spline",
		"free"};
  static const char * const realNames[]  = {"GTK_CURVE_TYPE_LINEAR",
		"GTK_CURVE_TYPE_SPLINE",
		"GTK_CURVE_TYPE_FREE"};
  static const int        cValues[]      = {GTK_CURVE_TYPE_LINEAR,
	GTK_CURVE_TYPE_SPLINE,
	GTK_CURVE_TYPE_FREE};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GtkCurveType"));
}
 

USER_OBJECT_
S_check_GtkPathType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"widget",
		"widget-class",
		"class"};
  static const char * const realNames[]  = {"GTK_PATH_WIDGET",
		"GTK_PATH_WIDGET_CLASS",
		"GTK_PATH_CLASS"};
  static const int        cValues[]      = {GTK_PATH_WIDGET,
	GTK_PATH_WIDGET_CLASS,
	GTK_PATH_CLASS};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GtkPathType"));
}
 

USER_OBJECT_
S_check_GdkVisibilityState_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"unobscured",
		"partial",
		"fully-obscured"};
  static const char * const realNames[]  = {"GDK_VISIBILITY_UNOBSCURED",
		"GDK_VISIBILITY_PARTIAL",
		"GDK_VISIBILITY_FULLY_OBSCURED"};
  static const int        cValues[]      = {GDK_VISIBILITY_UNOBSCURED,
	GDK_VISIBILITY_PARTIAL,
	GDK_VISIBILITY_FULLY_OBSCURED};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GdkVisibilityState"));
}
 

USER_OBJECT_
S_check_GtkSpinType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"step-forward",
		"step-backward",
		"page-forward",
		"page-backward",
		"home",
		"end",
		"user-defined"};
  static const char * const realNames[]  = {"GTK_SPIN_STEP_FORWARD",
		"GTK_SPIN_STEP_BACKWARD",
		"GTK_SPIN_PAGE_FORWARD",
		"GTK_SPIN_PAGE_BACKWARD",
		"GTK_SPIN_HOME",
		"GTK_SPIN_END",
		"GTK_SPIN_USER_DEFINED"};
  static const int        cValues[]      = {GTK_SPIN_STEP_FORWARD,
	GTK_SPIN_STEP_BACKWARD,
	GTK_SPIN_PAGE_FORWARD,
	GTK_SPIN_PAGE_BACKWARD,
	GTK_SPIN_HOME,
	GTK_SPIN_END,
	GTK_SPIN_USER_DEFINED};
  return(S_checkEnum(val, localNames, realNames, cValues, 7,"GtkSpinType"));
}
 

USER_OBJECT_
S_check_GdkAxisUse_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"ignore",
		"x",
		"y",
		"pressure",
		"xtilt",
		"ytilt",
		"last"};
  static const char * const realNames[]  = {"GDK_AXIS_IGNORE",
		"GDK_AXIS_X",
		"GDK_AXIS_Y",
		"GDK_AXIS_PRESSURE",
		"GDK_AXIS_XTILT",
		"GDK_AXIS_YTILT",
		"GDK_AXIS_LAST"};
  static const int        cValues[]      = {GDK_AXIS_IGNORE,
	GDK_AXIS_X,
	GDK_AXIS_Y,
	GDK_AXIS_PRESSURE,
	GDK_AXIS_XTILT,
	GDK_AXIS_YTILT,
	GDK_AXIS_LAST};
  return(S_checkEnum(val, localNames, realNames, cValues, 7,"GdkAxisUse"));
}
 

USER_OBJECT_
S_check_GdkStatus_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"ok",
		"error",
		"error-param",
		"error-file",
		"error-mem"};
  static const char * const realNames[]  = {"GDK_OK",
		"GDK_ERROR",
		"GDK_ERROR_PARAM",
		"GDK_ERROR_FILE",
		"GDK_ERROR_MEM"};
  static const int        cValues[]      = {GDK_OK,
	GDK_ERROR,
	GDK_ERROR_PARAM,
	GDK_ERROR_FILE,
	GDK_ERROR_MEM};
  return(S_checkEnum(val, localNames, realNames, cValues, 5,"GdkStatus"));
}
 

USER_OBJECT_
S_check_GtkArrowType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"up",
		"down",
		"left",
		"right"};
  static const char * const realNames[]  = {"GTK_ARROW_UP",
		"GTK_ARROW_DOWN",
		"GTK_ARROW_LEFT",
		"GTK_ARROW_RIGHT"};
  static const int        cValues[]      = {GTK_ARROW_UP,
	GTK_ARROW_DOWN,
	GTK_ARROW_LEFT,
	GTK_ARROW_RIGHT};
  return(S_checkEnum(val, localNames, realNames, cValues, 4,"GtkArrowType"));
}
 

USER_OBJECT_
S_check_GtkScrollType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"none",
		"step-backward",
		"step-forward",
		"page-backward",
		"page-forward",
		"jump"};
  static const char * const realNames[]  = {"GTK_SCROLL_NONE",
		"GTK_SCROLL_STEP_BACKWARD",
		"GTK_SCROLL_STEP_FORWARD",
		"GTK_SCROLL_PAGE_BACKWARD",
		"GTK_SCROLL_PAGE_FORWARD",
		"GTK_SCROLL_JUMP"};
  static const int        cValues[]      = {GTK_SCROLL_NONE,
	GTK_SCROLL_STEP_BACKWARD,
	GTK_SCROLL_STEP_FORWARD,
	GTK_SCROLL_PAGE_BACKWARD,
	GTK_SCROLL_PAGE_FORWARD,
	GTK_SCROLL_JUMP};
  return(S_checkEnum(val, localNames, realNames, cValues, 6,"GtkScrollType"));
}
 

USER_OBJECT_
S_check_GtkCTreeLineStyle_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"none",
		"solid",
		"dotted",
		"tabbed"};
  static const char * const realNames[]  = {"GTK_CTREE_LINES_NONE",
		"GTK_CTREE_LINES_SOLID",
		"GTK_CTREE_LINES_DOTTED",
		"GTK_CTREE_LINES_TABBED"};
  static const int        cValues[]      = {GTK_CTREE_LINES_NONE,
	GTK_CTREE_LINES_SOLID,
	GTK_CTREE_LINES_DOTTED,
	GTK_CTREE_LINES_TABBED};
  return(S_checkEnum(val, localNames, realNames, cValues, 4,"GtkCTreeLineStyle"));
}
 

USER_OBJECT_
S_check_GtkCornerType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"top-left",
		"bottom-left",
		"top-right",
		"bottom-right"};
  static const char * const realNames[]  = {"GTK_CORNER_TOP_LEFT",
		"GTK_CORNER_BOTTOM_LEFT",
		"GTK_CORNER_TOP_RIGHT",
		"GTK_CORNER_BOTTOM_RIGHT"};
  static const int        cValues[]      = {GTK_CORNER_TOP_LEFT,
	GTK_CORNER_BOTTOM_LEFT,
	GTK_CORNER_TOP_RIGHT,
	GTK_CORNER_BOTTOM_RIGHT};
  return(S_checkEnum(val, localNames, realNames, cValues, 4,"GtkCornerType"));
}
 

USER_OBJECT_
S_check_GdkJoinStyle_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"miter",
		"round",
		"bevel"};
  static const char * const realNames[]  = {"GDK_JOIN_MITER",
		"GDK_JOIN_ROUND",
		"GDK_JOIN_BEVEL"};
  static const int        cValues[]      = {GDK_JOIN_MITER,
	GDK_JOIN_ROUND,
	GDK_JOIN_BEVEL};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GdkJoinStyle"));
}
 

USER_OBJECT_
S_check_GtkFontFilterType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"base",
		"user"};
  static const char * const realNames[]  = {"GTK_FONT_FILTER_BASE",
		"GTK_FONT_FILTER_USER"};
  static const int        cValues[]      = {GTK_FONT_FILTER_BASE,
	GTK_FONT_FILTER_USER};
  return(S_checkEnum(val, localNames, realNames, cValues, 2,"GtkFontFilterType"));
}
 

USER_OBJECT_
S_check_GdkSelectionType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"atom",
		"bitmap",
		"colormap",
		"drawable",
		"integer",
		"pixmap",
		"window",
		"string"};
  static const char * const realNames[]  = {"GDK_SELECTION_TYPE_ATOM",
		"GDK_SELECTION_TYPE_BITMAP",
		"GDK_SELECTION_TYPE_COLORMAP",
		"GDK_SELECTION_TYPE_DRAWABLE",
		"GDK_SELECTION_TYPE_INTEGER",
		"GDK_SELECTION_TYPE_PIXMAP",
		"GDK_SELECTION_TYPE_WINDOW",
		"GDK_SELECTION_TYPE_STRING"};
  static const int        cValues[]      = {GDK_SELECTION_TYPE_ATOM,
	GDK_SELECTION_TYPE_BITMAP,
	GDK_SELECTION_TYPE_COLORMAP,
	GDK_SELECTION_TYPE_DRAWABLE,
	GDK_SELECTION_TYPE_INTEGER,
	GDK_SELECTION_TYPE_PIXMAP,
	GDK_SELECTION_TYPE_WINDOW,
	GDK_SELECTION_TYPE_STRING};
  return(S_checkEnum(val, localNames, realNames, cValues, 8,"GdkSelectionType"));
}
 

USER_OBJECT_
S_check_GtkPathPriorityType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"lowest",
		"gtk",
		"application",
		"rc",
		"highest",
		"mask"};
  static const char * const realNames[]  = {"GTK_PATH_PRIO_LOWEST",
		"GTK_PATH_PRIO_GTK",
		"GTK_PATH_PRIO_APPLICATION",
		"GTK_PATH_PRIO_RC",
		"GTK_PATH_PRIO_HIGHEST",
		"GTK_PATH_PRIO_MASK"};
  static const int        cValues[]      = {GTK_PATH_PRIO_LOWEST,
	GTK_PATH_PRIO_GTK,
	GTK_PATH_PRIO_APPLICATION,
	GTK_PATH_PRIO_RC,
	GTK_PATH_PRIO_HIGHEST,
	GTK_PATH_PRIO_MASK};
  return(S_checkEnum(val, localNames, realNames, cValues, 6,"GtkPathPriorityType"));
}
 

USER_OBJECT_
S_check_GdkWindowType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"root",
		"toplevel",
		"child",
		"dialog",
		"temp",
		"pixmap",
		"foreign"};
  static const char * const realNames[]  = {"GDK_WINDOW_ROOT",
		"GDK_WINDOW_TOPLEVEL",
		"GDK_WINDOW_CHILD",
		"GDK_WINDOW_DIALOG",
		"GDK_WINDOW_TEMP",
		"GDK_WINDOW_PIXMAP",
		"GDK_WINDOW_FOREIGN"};
  static const int        cValues[]      = {GDK_WINDOW_ROOT,
	GDK_WINDOW_TOPLEVEL,
	GDK_WINDOW_CHILD,
	GDK_WINDOW_DIALOG,
	GDK_WINDOW_TEMP,
	GDK_WINDOW_PIXMAP,
	GDK_WINDOW_FOREIGN};
  return(S_checkEnum(val, localNames, realNames, cValues, 7,"GdkWindowType"));
}
 

USER_OBJECT_
S_check_GtkToolbarSpaceStyle_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"empty",
		"line"};
  static const char * const realNames[]  = {"GTK_TOOLBAR_SPACE_EMPTY",
		"GTK_TOOLBAR_SPACE_LINE"};
  static const int        cValues[]      = {GTK_TOOLBAR_SPACE_EMPTY,
	GTK_TOOLBAR_SPACE_LINE};
  return(S_checkEnum(val, localNames, realNames, cValues, 2,"GtkToolbarSpaceStyle"));
}
 

USER_OBJECT_
S_check_GtkStateType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"normal",
		"active",
		"prelight",
		"selected",
		"insensitive"};
  static const char * const realNames[]  = {"GTK_STATE_NORMAL",
		"GTK_STATE_ACTIVE",
		"GTK_STATE_PRELIGHT",
		"GTK_STATE_SELECTED",
		"GTK_STATE_INSENSITIVE"};
  static const int        cValues[]      = {GTK_STATE_NORMAL,
	GTK_STATE_ACTIVE,
	GTK_STATE_PRELIGHT,
	GTK_STATE_SELECTED,
	GTK_STATE_INSENSITIVE};
  return(S_checkEnum(val, localNames, realNames, cValues, 5,"GtkStateType"));
}
 

USER_OBJECT_
S_check_GtkResizeMode_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"parent",
		"queue",
		"immediate"};
  static const char * const realNames[]  = {"GTK_RESIZE_PARENT",
		"GTK_RESIZE_QUEUE",
		"GTK_RESIZE_IMMEDIATE"};
  static const int        cValues[]      = {GTK_RESIZE_PARENT,
	GTK_RESIZE_QUEUE,
	GTK_RESIZE_IMMEDIATE};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GtkResizeMode"));
}
 

USER_OBJECT_
S_check_GtkCellType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"empty",
		"text",
		"pixmap",
		"pixtext",
		"widget"};
  static const char * const realNames[]  = {"GTK_CELL_EMPTY",
		"GTK_CELL_TEXT",
		"GTK_CELL_PIXMAP",
		"GTK_CELL_PIXTEXT",
		"GTK_CELL_WIDGET"};
  static const int        cValues[]      = {GTK_CELL_EMPTY,
	GTK_CELL_TEXT,
	GTK_CELL_PIXMAP,
	GTK_CELL_PIXTEXT,
	GTK_CELL_WIDGET};
  return(S_checkEnum(val, localNames, realNames, cValues, 5,"GtkCellType"));
}
 

USER_OBJECT_
S_check_GtkShadowType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"none",
		"in",
		"out",
		"etched-in",
		"etched-out"};
  static const char * const realNames[]  = {"GTK_SHADOW_NONE",
		"GTK_SHADOW_IN",
		"GTK_SHADOW_OUT",
		"GTK_SHADOW_ETCHED_IN",
		"GTK_SHADOW_ETCHED_OUT"};
  static const int        cValues[]      = {GTK_SHADOW_NONE,
	GTK_SHADOW_IN,
	GTK_SHADOW_OUT,
	GTK_SHADOW_ETCHED_IN,
	GTK_SHADOW_ETCHED_OUT};
  return(S_checkEnum(val, localNames, realNames, cValues, 5,"GtkShadowType"));
}
 

USER_OBJECT_
S_check_GtkFontMetricType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"pixels",
		"points"};
  static const char * const realNames[]  = {"GTK_FONT_METRIC_PIXELS",
		"GTK_FONT_METRIC_POINTS"};
  static const int        cValues[]      = {GTK_FONT_METRIC_PIXELS,
	GTK_FONT_METRIC_POINTS};
  return(S_checkEnum(val, localNames, realNames, cValues, 2,"GtkFontMetricType"));
}
 

USER_OBJECT_
S_check_GdkFilterReturn_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"continue",
		"translate",
		"remove"};
  static const char * const realNames[]  = {"GDK_FILTER_CONTINUE",
		"GDK_FILTER_TRANSLATE",
		"GDK_FILTER_REMOVE"};
  static const int        cValues[]      = {GDK_FILTER_CONTINUE,
	GDK_FILTER_TRANSLATE,
	GDK_FILTER_REMOVE};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GdkFilterReturn"));
}
 

USER_OBJECT_
S_check_GdkFill_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"solid",
		"tiled",
		"stippled",
		"opaque-stippled"};
  static const char * const realNames[]  = {"GDK_SOLID",
		"GDK_TILED",
		"GDK_STIPPLED",
		"GDK_OPAQUE_STIPPLED"};
  static const int        cValues[]      = {GDK_SOLID,
	GDK_TILED,
	GDK_STIPPLED,
	GDK_OPAQUE_STIPPLED};
  return(S_checkEnum(val, localNames, realNames, cValues, 4,"GdkFill"));
}
 

USER_OBJECT_
S_check_GdkCrossingMode_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"normal",
		"grab",
		"ungrab"};
  static const char * const realNames[]  = {"GDK_CROSSING_NORMAL",
		"GDK_CROSSING_GRAB",
		"GDK_CROSSING_UNGRAB"};
  static const int        cValues[]      = {GDK_CROSSING_NORMAL,
	GDK_CROSSING_GRAB,
	GDK_CROSSING_UNGRAB};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GdkCrossingMode"));
}
 

USER_OBJECT_
S_check_GtkMetricType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"pixels",
		"inches",
		"centimeters"};
  static const char * const realNames[]  = {"GTK_PIXELS",
		"GTK_INCHES",
		"GTK_CENTIMETERS"};
  static const int        cValues[]      = {GTK_PIXELS,
	GTK_INCHES,
	GTK_CENTIMETERS};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GtkMetricType"));
}
 

USER_OBJECT_
S_check_GtkReliefStyle_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"normal",
		"half",
		"none"};
  static const char * const realNames[]  = {"GTK_RELIEF_NORMAL",
		"GTK_RELIEF_HALF",
		"GTK_RELIEF_NONE"};
  static const int        cValues[]      = {GTK_RELIEF_NORMAL,
	GTK_RELIEF_HALF,
	GTK_RELIEF_NONE};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GtkReliefStyle"));
}
 

USER_OBJECT_
S_check_GdkCapStyle_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"not-last",
		"butt",
		"round",
		"projecting"};
  static const char * const realNames[]  = {"GDK_CAP_NOT_LAST",
		"GDK_CAP_BUTT",
		"GDK_CAP_ROUND",
		"GDK_CAP_PROJECTING"};
  static const int        cValues[]      = {GDK_CAP_NOT_LAST,
	GDK_CAP_BUTT,
	GDK_CAP_ROUND,
	GDK_CAP_PROJECTING};
  return(S_checkEnum(val, localNames, realNames, cValues, 4,"GdkCapStyle"));
}
 

USER_OBJECT_
S_check_GdkFunction_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"copy",
		"invert",
		"xor",
		"clear",
		"and",
		"and-reverse",
		"and-invert",
		"noop",
		"or",
		"equiv",
		"or-reverse",
		"copy-invert",
		"or-invert",
		"nand",
		"set"};
  static const char * const realNames[]  = {"GDK_COPY",
		"GDK_INVERT",
		"GDK_XOR",
		"GDK_CLEAR",
		"GDK_AND",
		"GDK_AND_REVERSE",
		"GDK_AND_INVERT",
		"GDK_NOOP",
		"GDK_OR",
		"GDK_EQUIV",
		"GDK_OR_REVERSE",
		"GDK_COPY_INVERT",
		"GDK_OR_INVERT",
		"GDK_NAND",
		"GDK_SET"};
  static const int        cValues[]      = {GDK_COPY,
	GDK_INVERT,
	GDK_XOR,
	GDK_CLEAR,
	GDK_AND,
	GDK_AND_REVERSE,
	GDK_AND_INVERT,
	GDK_NOOP,
	GDK_OR,
	GDK_EQUIV,
	GDK_OR_REVERSE,
	GDK_COPY_INVERT,
	GDK_OR_INVERT,
	GDK_NAND,
	GDK_SET};
  return(S_checkEnum(val, localNames, realNames, cValues, 15,"GdkFunction"));
}
 

USER_OBJECT_
S_check_GdkNotifyType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"ancestor",
		"virtual",
		"inferior",
		"nonlinear",
		"nonlinear-virtual",
		"unknown"};
  static const char * const realNames[]  = {"GDK_NOTIFY_ANCESTOR",
		"GDK_NOTIFY_VIRTUAL",
		"GDK_NOTIFY_INFERIOR",
		"GDK_NOTIFY_NONLINEAR",
		"GDK_NOTIFY_NONLINEAR_VIRTUAL",
		"GDK_NOTIFY_UNKNOWN"};
  static const int        cValues[]      = {GDK_NOTIFY_ANCESTOR,
	GDK_NOTIFY_VIRTUAL,
	GDK_NOTIFY_INFERIOR,
	GDK_NOTIFY_NONLINEAR,
	GDK_NOTIFY_NONLINEAR_VIRTUAL,
	GDK_NOTIFY_UNKNOWN};
  return(S_checkEnum(val, localNames, realNames, cValues, 6,"GdkNotifyType"));
}
 

USER_OBJECT_
S_check_GtkButtonBoxStyle_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"default-style",
		"spread",
		"edge",
		"start",
		"end"};
  static const char * const realNames[]  = {"GTK_BUTTONBOX_DEFAULT_STYLE",
		"GTK_BUTTONBOX_SPREAD",
		"GTK_BUTTONBOX_EDGE",
		"GTK_BUTTONBOX_START",
		"GTK_BUTTONBOX_END"};
  static const int        cValues[]      = {GTK_BUTTONBOX_DEFAULT_STYLE,
	GTK_BUTTONBOX_SPREAD,
	GTK_BUTTONBOX_EDGE,
	GTK_BUTTONBOX_START,
	GTK_BUTTONBOX_END};
  return(S_checkEnum(val, localNames, realNames, cValues, 5,"GtkButtonBoxStyle"));
}
 

USER_OBJECT_
S_check_GdkCursorType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"num-glyphs",
		"x-cursor",
		"arrow",
		"based-arrow-down",
		"based-arrow-up",
		"boat",
		"bogosity",
		"bottom-left-corner",
		"bottom-right-corner",
		"bottom-side",
		"bottom-tee",
		"box-spiral",
		"center-ptr",
		"circle",
		"clock",
		"coffee-mug",
		"cross",
		"cross-reverse",
		"crosshair",
		"diamond-cross",
		"dot",
		"dotbox",
		"double-arrow",
		"draft-large",
		"draft-small",
		"draped-box",
		"exchange",
		"fleur",
		"gobbler",
		"gumby",
		"hand1",
		"hand2",
		"heart",
		"icon",
		"iron-cross",
		"left-ptr",
		"left-side",
		"left-tee",
		"leftbutton",
		"ll-angle",
		"lr-angle",
		"man",
		"middlebutton",
		"mouse",
		"pencil",
		"pirate",
		"plus",
		"question-arrow",
		"right-ptr",
		"right-side",
		"right-tee",
		"rightbutton",
		"rtl-logo",
		"sailboat",
		"sb-down-arrow",
		"sb-h-double-arrow",
		"sb-left-arrow",
		"sb-right-arrow",
		"sb-up-arrow",
		"sb-v-double-arrow",
		"shuttle",
		"sizing",
		"spider",
		"spraycan",
		"star",
		"target",
		"tcross",
		"top-left-arrow",
		"top-left-corner",
		"top-right-corner",
		"top-side",
		"top-tee",
		"trek",
		"ul-angle",
		"umbrella",
		"ur-angle",
		"watch",
		"xterm",
		"last-cursor",
		"cursor-is-pixmap"};
  static const char * const realNames[]  = {"GDK_NUM_GLYPHS",
		"GDK_X_CURSOR",
		"GDK_ARROW",
		"GDK_BASED_ARROW_DOWN",
		"GDK_BASED_ARROW_UP",
		"GDK_BOAT",
		"GDK_BOGOSITY",
		"GDK_BOTTOM_LEFT_CORNER",
		"GDK_BOTTOM_RIGHT_CORNER",
		"GDK_BOTTOM_SIDE",
		"GDK_BOTTOM_TEE",
		"GDK_BOX_SPIRAL",
		"GDK_CENTER_PTR",
		"GDK_CIRCLE",
		"GDK_CLOCK",
		"GDK_COFFEE_MUG",
		"GDK_CROSS",
		"GDK_CROSS_REVERSE",
		"GDK_CROSSHAIR",
		"GDK_DIAMOND_CROSS",
		"GDK_DOT",
		"GDK_DOTBOX",
		"GDK_DOUBLE_ARROW",
		"GDK_DRAFT_LARGE",
		"GDK_DRAFT_SMALL",
		"GDK_DRAPED_BOX",
		"GDK_EXCHANGE",
		"GDK_FLEUR",
		"GDK_GOBBLER",
		"GDK_GUMBY",
		"GDK_HAND1",
		"GDK_HAND2",
		"GDK_HEART",
		"GDK_ICON",
		"GDK_IRON_CROSS",
		"GDK_LEFT_PTR",
		"GDK_LEFT_SIDE",
		"GDK_LEFT_TEE",
		"GDK_LEFTBUTTON",
		"GDK_LL_ANGLE",
		"GDK_LR_ANGLE",
		"GDK_MAN",
		"GDK_MIDDLEBUTTON",
		"GDK_MOUSE",
		"GDK_PENCIL",
		"GDK_PIRATE",
		"GDK_PLUS",
		"GDK_QUESTION_ARROW",
		"GDK_RIGHT_PTR",
		"GDK_RIGHT_SIDE",
		"GDK_RIGHT_TEE",
		"GDK_RIGHTBUTTON",
		"GDK_RTL_LOGO",
		"GDK_SAILBOAT",
		"GDK_SB_DOWN_ARROW",
		"GDK_SB_H_DOUBLE_ARROW",
		"GDK_SB_LEFT_ARROW",
		"GDK_SB_RIGHT_ARROW",
		"GDK_SB_UP_ARROW",
		"GDK_SB_V_DOUBLE_ARROW",
		"GDK_SHUTTLE",
		"GDK_SIZING",
		"GDK_SPIDER",
		"GDK_SPRAYCAN",
		"GDK_STAR",
		"GDK_TARGET",
		"GDK_TCROSS",
		"GDK_TOP_LEFT_ARROW",
		"GDK_TOP_LEFT_CORNER",
		"GDK_TOP_RIGHT_CORNER",
		"GDK_TOP_SIDE",
		"GDK_TOP_TEE",
		"GDK_TREK",
		"GDK_UL_ANGLE",
		"GDK_UMBRELLA",
		"GDK_UR_ANGLE",
		"GDK_WATCH",
		"GDK_XTERM",
		"GDK_LAST_CURSOR",
		"GDK_CURSOR_IS_PIXMAP"};
  static const int        cValues[]      = {GDK_NUM_GLYPHS,
	GDK_X_CURSOR,
	GDK_ARROW,
	GDK_BASED_ARROW_DOWN,
	GDK_BASED_ARROW_UP,
	GDK_BOAT,
	GDK_BOGOSITY,
	GDK_BOTTOM_LEFT_CORNER,
	GDK_BOTTOM_RIGHT_CORNER,
	GDK_BOTTOM_SIDE,
	GDK_BOTTOM_TEE,
	GDK_BOX_SPIRAL,
	GDK_CENTER_PTR,
	GDK_CIRCLE,
	GDK_CLOCK,
	GDK_COFFEE_MUG,
	GDK_CROSS,
	GDK_CROSS_REVERSE,
	GDK_CROSSHAIR,
	GDK_DIAMOND_CROSS,
	GDK_DOT,
	GDK_DOTBOX,
	GDK_DOUBLE_ARROW,
	GDK_DRAFT_LARGE,
	GDK_DRAFT_SMALL,
	GDK_DRAPED_BOX,
	GDK_EXCHANGE,
	GDK_FLEUR,
	GDK_GOBBLER,
	GDK_GUMBY,
	GDK_HAND1,
	GDK_HAND2,
	GDK_HEART,
	GDK_ICON,
	GDK_IRON_CROSS,
	GDK_LEFT_PTR,
	GDK_LEFT_SIDE,
	GDK_LEFT_TEE,
	GDK_LEFTBUTTON,
	GDK_LL_ANGLE,
	GDK_LR_ANGLE,
	GDK_MAN,
	GDK_MIDDLEBUTTON,
	GDK_MOUSE,
	GDK_PENCIL,
	GDK_PIRATE,
	GDK_PLUS,
	GDK_QUESTION_ARROW,
	GDK_RIGHT_PTR,
	GDK_RIGHT_SIDE,
	GDK_RIGHT_TEE,
	GDK_RIGHTBUTTON,
	GDK_RTL_LOGO,
	GDK_SAILBOAT,
	GDK_SB_DOWN_ARROW,
	GDK_SB_H_DOUBLE_ARROW,
	GDK_SB_LEFT_ARROW,
	GDK_SB_RIGHT_ARROW,
	GDK_SB_UP_ARROW,
	GDK_SB_V_DOUBLE_ARROW,
	GDK_SHUTTLE,
	GDK_SIZING,
	GDK_SPIDER,
	GDK_SPRAYCAN,
	GDK_STAR,
	GDK_TARGET,
	GDK_TCROSS,
	GDK_TOP_LEFT_ARROW,
	GDK_TOP_LEFT_CORNER,
	GDK_TOP_RIGHT_CORNER,
	GDK_TOP_SIDE,
	GDK_TOP_TEE,
	GDK_TREK,
	GDK_UL_ANGLE,
	GDK_UMBRELLA,
	GDK_UR_ANGLE,
	GDK_WATCH,
	GDK_XTERM,
	GDK_LAST_CURSOR,
	GDK_CURSOR_IS_PIXMAP};
  return(S_checkEnum(val, localNames, realNames, cValues, 80,"GdkCursorType"));
}
 

USER_OBJECT_
S_check_GdkPropertyState_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"new-value",
		"delete"};
  static const char * const realNames[]  = {"GDK_PROPERTY_NEW_VALUE",
		"GDK_PROPERTY_DELETE"};
  static const int        cValues[]      = {GDK_PROPERTY_NEW_VALUE,
	GDK_PROPERTY_DELETE};
  return(S_checkEnum(val, localNames, realNames, cValues, 2,"GdkPropertyState"));
}
 

USER_OBJECT_
S_check_GdkVisualType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"static-gray",
		"grayscale",
		"static-color",
		"pseudo-color",
		"true-color",
		"direct-color"};
  static const char * const realNames[]  = {"GDK_VISUAL_STATIC_GRAY",
		"GDK_VISUAL_GRAYSCALE",
		"GDK_VISUAL_STATIC_COLOR",
		"GDK_VISUAL_PSEUDO_COLOR",
		"GDK_VISUAL_TRUE_COLOR",
		"GDK_VISUAL_DIRECT_COLOR"};
  static const int        cValues[]      = {GDK_VISUAL_STATIC_GRAY,
	GDK_VISUAL_GRAYSCALE,
	GDK_VISUAL_STATIC_COLOR,
	GDK_VISUAL_PSEUDO_COLOR,
	GDK_VISUAL_TRUE_COLOR,
	GDK_VISUAL_DIRECT_COLOR};
  return(S_checkEnum(val, localNames, realNames, cValues, 6,"GdkVisualType"));
}
 

USER_OBJECT_
S_check_GdkRgbDither_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"none",
		"normal",
		"max"};
  static const char * const realNames[]  = {"GDK_RGB_DITHER_NONE",
		"GDK_RGB_DITHER_NORMAL",
		"GDK_RGB_DITHER_MAX"};
  static const int        cValues[]      = {GDK_RGB_DITHER_NONE,
	GDK_RGB_DITHER_NORMAL,
	GDK_RGB_DITHER_MAX};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GdkRgbDither"));
}
 

USER_OBJECT_
S_check_GtkSortType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"ascending",
		"descending"};
  static const char * const realNames[]  = {"GTK_SORT_ASCENDING",
		"GTK_SORT_DESCENDING"};
  static const int        cValues[]      = {GTK_SORT_ASCENDING,
	GTK_SORT_DESCENDING};
  return(S_checkEnum(val, localNames, realNames, cValues, 2,"GtkSortType"));
}
 

USER_OBJECT_
S_check_GtkWindowPosition_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"none",
		"center",
		"mouse"};
  static const char * const realNames[]  = {"GTK_WIN_POS_NONE",
		"GTK_WIN_POS_CENTER",
		"GTK_WIN_POS_MOUSE"};
  static const int        cValues[]      = {GTK_WIN_POS_NONE,
	GTK_WIN_POS_CENTER,
	GTK_WIN_POS_MOUSE};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GtkWindowPosition"));
}
 

USER_OBJECT_
S_check_GdkInputMode_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"disabled",
		"screen",
		"window"};
  static const char * const realNames[]  = {"GDK_MODE_DISABLED",
		"GDK_MODE_SCREEN",
		"GDK_MODE_WINDOW"};
  static const int        cValues[]      = {GDK_MODE_DISABLED,
	GDK_MODE_SCREEN,
	GDK_MODE_WINDOW};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GdkInputMode"));
}
 

USER_OBJECT_
S_check_GdkEventType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"nothing",
		"delete",
		"destroy",
		"expose",
		"motion-notify",
		"button-press",
		"button2-press",
		"button3-press",
		"button-release",
		"key-press",
		"key-release",
		"enter-notify",
		"leave-notify",
		"focus-change",
		"configure",
		"map",
		"unmap",
		"property-notify",
		"selection-clear",
		"selection-request",
		"selection-notify",
		"proximity-in",
		"proximity-out",
		"drag-enter",
		"drag-leave",
		"drag-motion",
		"drag-status",
		"drop-start",
		"drop-finished",
		"client-event",
		"visibility-notify",
		"no-expose"};
  static const char * const realNames[]  = {"GDK_NOTHING",
		"GDK_DELETE",
		"GDK_DESTROY",
		"GDK_EXPOSE",
		"GDK_MOTION_NOTIFY",
		"GDK_BUTTON_PRESS",
		"GDK_2BUTTON_PRESS",
		"GDK_3BUTTON_PRESS",
		"GDK_BUTTON_RELEASE",
		"GDK_KEY_PRESS",
		"GDK_KEY_RELEASE",
		"GDK_ENTER_NOTIFY",
		"GDK_LEAVE_NOTIFY",
		"GDK_FOCUS_CHANGE",
		"GDK_CONFIGURE",
		"GDK_MAP",
		"GDK_UNMAP",
		"GDK_PROPERTY_NOTIFY",
		"GDK_SELECTION_CLEAR",
		"GDK_SELECTION_REQUEST",
		"GDK_SELECTION_NOTIFY",
		"GDK_PROXIMITY_IN",
		"GDK_PROXIMITY_OUT",
		"GDK_DRAG_ENTER",
		"GDK_DRAG_LEAVE",
		"GDK_DRAG_MOTION",
		"GDK_DRAG_STATUS",
		"GDK_DROP_START",
		"GDK_DROP_FINISHED",
		"GDK_CLIENT_EVENT",
		"GDK_VISIBILITY_NOTIFY",
		"GDK_NO_EXPOSE"};
  static const int        cValues[]      = {GDK_NOTHING,
	GDK_DELETE,
	GDK_DESTROY,
	GDK_EXPOSE,
	GDK_MOTION_NOTIFY,
	GDK_BUTTON_PRESS,
	GDK_2BUTTON_PRESS,
	GDK_3BUTTON_PRESS,
	GDK_BUTTON_RELEASE,
	GDK_KEY_PRESS,
	GDK_KEY_RELEASE,
	GDK_ENTER_NOTIFY,
	GDK_LEAVE_NOTIFY,
	GDK_FOCUS_CHANGE,
	GDK_CONFIGURE,
	GDK_MAP,
	GDK_UNMAP,
	GDK_PROPERTY_NOTIFY,
	GDK_SELECTION_CLEAR,
	GDK_SELECTION_REQUEST,
	GDK_SELECTION_NOTIFY,
	GDK_PROXIMITY_IN,
	GDK_PROXIMITY_OUT,
	GDK_DRAG_ENTER,
	GDK_DRAG_LEAVE,
	GDK_DRAG_MOTION,
	GDK_DRAG_STATUS,
	GDK_DROP_START,
	GDK_DROP_FINISHED,
	GDK_CLIENT_EVENT,
	GDK_VISIBILITY_NOTIFY,
	GDK_NO_EXPOSE};
  return(S_checkEnum(val, localNames, realNames, cValues, 32,"GdkEventType"));
}
 

USER_OBJECT_
S_check_GtkCTreeExpansionType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"expand",
		"expand-recursive",
		"collapse",
		"collapse-recursive",
		"toggle",
		"toggle-recursive"};
  static const char * const realNames[]  = {"GTK_CTREE_EXPANSION_EXPAND",
		"GTK_CTREE_EXPANSION_EXPAND_RECURSIVE",
		"GTK_CTREE_EXPANSION_COLLAPSE",
		"GTK_CTREE_EXPANSION_COLLAPSE_RECURSIVE",
		"GTK_CTREE_EXPANSION_TOGGLE",
		"GTK_CTREE_EXPANSION_TOGGLE_RECURSIVE"};
  static const int        cValues[]      = {GTK_CTREE_EXPANSION_EXPAND,
	GTK_CTREE_EXPANSION_EXPAND_RECURSIVE,
	GTK_CTREE_EXPANSION_COLLAPSE,
	GTK_CTREE_EXPANSION_COLLAPSE_RECURSIVE,
	GTK_CTREE_EXPANSION_TOGGLE,
	GTK_CTREE_EXPANSION_TOGGLE_RECURSIVE};
  return(S_checkEnum(val, localNames, realNames, cValues, 6,"GtkCTreeExpansionType"));
}
 

USER_OBJECT_
S_check_GtkProgressBarStyle_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"continuous",
		"discrete"};
  static const char * const realNames[]  = {"GTK_PROGRESS_CONTINUOUS",
		"GTK_PROGRESS_DISCRETE"};
  static const int        cValues[]      = {GTK_PROGRESS_CONTINUOUS,
	GTK_PROGRESS_DISCRETE};
  return(S_checkEnum(val, localNames, realNames, cValues, 2,"GtkProgressBarStyle"));
}
 

USER_OBJECT_
S_check_GdkLineStyle_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"solid",
		"on-off-dash",
		"double-dash"};
  static const char * const realNames[]  = {"GDK_LINE_SOLID",
		"GDK_LINE_ON_OFF_DASH",
		"GDK_LINE_DOUBLE_DASH"};
  static const int        cValues[]      = {GDK_LINE_SOLID,
	GDK_LINE_ON_OFF_DASH,
	GDK_LINE_DOUBLE_DASH};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GdkLineStyle"));
}
 

USER_OBJECT_
S_check_GtkRcTokenType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"invalid",
		"include",
		"normal",
		"active",
		"prelight",
		"selected",
		"insensitive",
		"fg",
		"bg",
		"base",
		"text",
		"font",
		"fontset",
		"bg-pixmap",
		"pixmap-path",
		"style",
		"binding",
		"bind",
		"widget",
		"widget-class",
		"class",
		"lowest",
		"gtk",
		"application",
		"rc",
		"highest",
		"engine",
		"module-path",
		"last"};
  static const char * const realNames[]  = {"GTK_RC_TOKEN_INVALID",
		"GTK_RC_TOKEN_INCLUDE",
		"GTK_RC_TOKEN_NORMAL",
		"GTK_RC_TOKEN_ACTIVE",
		"GTK_RC_TOKEN_PRELIGHT",
		"GTK_RC_TOKEN_SELECTED",
		"GTK_RC_TOKEN_INSENSITIVE",
		"GTK_RC_TOKEN_FG",
		"GTK_RC_TOKEN_BG",
		"GTK_RC_TOKEN_BASE",
		"GTK_RC_TOKEN_TEXT",
		"GTK_RC_TOKEN_FONT",
		"GTK_RC_TOKEN_FONTSET",
		"GTK_RC_TOKEN_BG_PIXMAP",
		"GTK_RC_TOKEN_PIXMAP_PATH",
		"GTK_RC_TOKEN_STYLE",
		"GTK_RC_TOKEN_BINDING",
		"GTK_RC_TOKEN_BIND",
		"GTK_RC_TOKEN_WIDGET",
		"GTK_RC_TOKEN_WIDGET_CLASS",
		"GTK_RC_TOKEN_CLASS",
		"GTK_RC_TOKEN_LOWEST",
		"GTK_RC_TOKEN_GTK",
		"GTK_RC_TOKEN_APPLICATION",
		"GTK_RC_TOKEN_RC",
		"GTK_RC_TOKEN_HIGHEST",
		"GTK_RC_TOKEN_ENGINE",
		"GTK_RC_TOKEN_MODULE_PATH",
		"GTK_RC_TOKEN_LAST"};
  static const int        cValues[]      = {GTK_RC_TOKEN_INVALID,
	GTK_RC_TOKEN_INCLUDE,
	GTK_RC_TOKEN_NORMAL,
	GTK_RC_TOKEN_ACTIVE,
	GTK_RC_TOKEN_PRELIGHT,
	GTK_RC_TOKEN_SELECTED,
	GTK_RC_TOKEN_INSENSITIVE,
	GTK_RC_TOKEN_FG,
	GTK_RC_TOKEN_BG,
	GTK_RC_TOKEN_BASE,
	GTK_RC_TOKEN_TEXT,
	GTK_RC_TOKEN_FONT,
	GTK_RC_TOKEN_FONTSET,
	GTK_RC_TOKEN_BG_PIXMAP,
	GTK_RC_TOKEN_PIXMAP_PATH,
	GTK_RC_TOKEN_STYLE,
	GTK_RC_TOKEN_BINDING,
	GTK_RC_TOKEN_BIND,
	GTK_RC_TOKEN_WIDGET,
	GTK_RC_TOKEN_WIDGET_CLASS,
	GTK_RC_TOKEN_CLASS,
	GTK_RC_TOKEN_LOWEST,
	GTK_RC_TOKEN_GTK,
	GTK_RC_TOKEN_APPLICATION,
	GTK_RC_TOKEN_RC,
	GTK_RC_TOKEN_HIGHEST,
	GTK_RC_TOKEN_ENGINE,
	GTK_RC_TOKEN_MODULE_PATH,
	GTK_RC_TOKEN_LAST};
  return(S_checkEnum(val, localNames, realNames, cValues, 29,"GtkRcTokenType"));
}
 

USER_OBJECT_
S_check_GtkMenuFactoryType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"menu",
		"menu-bar",
		"option-menu"};
  static const char * const realNames[]  = {"GTK_MENU_FACTORY_MENU",
		"GTK_MENU_FACTORY_MENU_BAR",
		"GTK_MENU_FACTORY_OPTION_MENU"};
  static const int        cValues[]      = {GTK_MENU_FACTORY_MENU,
	GTK_MENU_FACTORY_MENU_BAR,
	GTK_MENU_FACTORY_OPTION_MENU};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GtkMenuFactoryType"));
}
 

USER_OBJECT_
S_check_GtkCTreePos_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"before",
		"as-child",
		"after"};
  static const char * const realNames[]  = {"GTK_CTREE_POS_BEFORE",
		"GTK_CTREE_POS_AS_CHILD",
		"GTK_CTREE_POS_AFTER"};
  static const int        cValues[]      = {GTK_CTREE_POS_BEFORE,
	GTK_CTREE_POS_AS_CHILD,
	GTK_CTREE_POS_AFTER};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GtkCTreePos"));
}
 

USER_OBJECT_
S_check_GtkCListDragPos_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"none",
		"before",
		"into",
		"after"};
  static const char * const realNames[]  = {"GTK_CLIST_DRAG_NONE",
		"GTK_CLIST_DRAG_BEFORE",
		"GTK_CLIST_DRAG_INTO",
		"GTK_CLIST_DRAG_AFTER"};
  static const int        cValues[]      = {GTK_CLIST_DRAG_NONE,
	GTK_CLIST_DRAG_BEFORE,
	GTK_CLIST_DRAG_INTO,
	GTK_CLIST_DRAG_AFTER};
  return(S_checkEnum(val, localNames, realNames, cValues, 4,"GtkCListDragPos"));
}
 

USER_OBJECT_
S_check_GdkExtensionMode_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"none",
		"all",
		"cursor"};
  static const char * const realNames[]  = {"GDK_EXTENSION_EVENTS_NONE",
		"GDK_EXTENSION_EVENTS_ALL",
		"GDK_EXTENSION_EVENTS_CURSOR"};
  static const int        cValues[]      = {GDK_EXTENSION_EVENTS_NONE,
	GDK_EXTENSION_EVENTS_ALL,
	GDK_EXTENSION_EVENTS_CURSOR};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GdkExtensionMode"));
}
 

USER_OBJECT_
S_check_GtkWindowType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"toplevel",
		"dialog",
		"popup"};
  static const char * const realNames[]  = {"GTK_WINDOW_TOPLEVEL",
		"GTK_WINDOW_DIALOG",
		"GTK_WINDOW_POPUP"};
  static const int        cValues[]      = {GTK_WINDOW_TOPLEVEL,
	GTK_WINDOW_DIALOG,
	GTK_WINDOW_POPUP};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GtkWindowType"));
}
 

USER_OBJECT_
S_check_GtkMatchType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"all",
		"all-tail",
		"head",
		"tail",
		"exact",
		"last"};
  static const char * const realNames[]  = {"GTK_MATCH_ALL",
		"GTK_MATCH_ALL_TAIL",
		"GTK_MATCH_HEAD",
		"GTK_MATCH_TAIL",
		"GTK_MATCH_EXACT",
		"GTK_MATCH_LAST"};
  static const int        cValues[]      = {GTK_MATCH_ALL,
	GTK_MATCH_ALL_TAIL,
	GTK_MATCH_HEAD,
	GTK_MATCH_TAIL,
	GTK_MATCH_EXACT,
	GTK_MATCH_LAST};
  return(S_checkEnum(val, localNames, realNames, cValues, 6,"GtkMatchType"));
}
 

USER_OBJECT_
S_check_GtkToolbarChildType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"space",
		"button",
		"togglebutton",
		"radiobutton",
		"widget"};
  static const char * const realNames[]  = {"GTK_TOOLBAR_CHILD_SPACE",
		"GTK_TOOLBAR_CHILD_BUTTON",
		"GTK_TOOLBAR_CHILD_TOGGLEBUTTON",
		"GTK_TOOLBAR_CHILD_RADIOBUTTON",
		"GTK_TOOLBAR_CHILD_WIDGET"};
  static const int        cValues[]      = {GTK_TOOLBAR_CHILD_SPACE,
	GTK_TOOLBAR_CHILD_BUTTON,
	GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
	GTK_TOOLBAR_CHILD_RADIOBUTTON,
	GTK_TOOLBAR_CHILD_WIDGET};
  return(S_checkEnum(val, localNames, realNames, cValues, 5,"GtkToolbarChildType"));
}
 

USER_OBJECT_
S_check_GtkPositionType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"left",
		"right",
		"top",
		"bottom"};
  static const char * const realNames[]  = {"GTK_POS_LEFT",
		"GTK_POS_RIGHT",
		"GTK_POS_TOP",
		"GTK_POS_BOTTOM"};
  static const int        cValues[]      = {GTK_POS_LEFT,
	GTK_POS_RIGHT,
	GTK_POS_TOP,
	GTK_POS_BOTTOM};
  return(S_checkEnum(val, localNames, realNames, cValues, 4,"GtkPositionType"));
}
 

USER_OBJECT_
S_check_GtkPackType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"start",
		"end"};
  static const char * const realNames[]  = {"GTK_PACK_START",
		"GTK_PACK_END"};
  static const int        cValues[]      = {GTK_PACK_START,
	GTK_PACK_END};
  return(S_checkEnum(val, localNames, realNames, cValues, 2,"GtkPackType"));
}
 

USER_OBJECT_
S_check_GdkTarget_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"bitmap",
		"colormap",
		"drawable",
		"pixmap",
		"string"};
  static const char * const realNames[]  = {"GDK_TARGET_BITMAP",
		"GDK_TARGET_COLORMAP",
		"GDK_TARGET_DRAWABLE",
		"GDK_TARGET_PIXMAP",
		"GDK_TARGET_STRING"};
  static const int        cValues[]      = {GDK_TARGET_BITMAP,
	GDK_TARGET_COLORMAP,
	GDK_TARGET_DRAWABLE,
	GDK_TARGET_PIXMAP,
	GDK_TARGET_STRING};
  return(S_checkEnum(val, localNames, realNames, cValues, 5,"GdkTarget"));
}
 

USER_OBJECT_
S_check_GtkToolbarStyle_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"icons",
		"text",
		"both"};
  static const char * const realNames[]  = {"GTK_TOOLBAR_ICONS",
		"GTK_TOOLBAR_TEXT",
		"GTK_TOOLBAR_BOTH"};
  static const int        cValues[]      = {GTK_TOOLBAR_ICONS,
	GTK_TOOLBAR_TEXT,
	GTK_TOOLBAR_BOTH};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GtkToolbarStyle"));
}
 

USER_OBJECT_
S_check_GtkCTreeExpanderStyle_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"none",
		"square",
		"triangle",
		"circular"};
  static const char * const realNames[]  = {"GTK_CTREE_EXPANDER_NONE",
		"GTK_CTREE_EXPANDER_SQUARE",
		"GTK_CTREE_EXPANDER_TRIANGLE",
		"GTK_CTREE_EXPANDER_CIRCULAR"};
  static const int        cValues[]      = {GTK_CTREE_EXPANDER_NONE,
	GTK_CTREE_EXPANDER_SQUARE,
	GTK_CTREE_EXPANDER_TRIANGLE,
	GTK_CTREE_EXPANDER_CIRCULAR};
  return(S_checkEnum(val, localNames, realNames, cValues, 4,"GtkCTreeExpanderStyle"));
}
 

USER_OBJECT_
S_check_GdkFillRule_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"even-odd-rule",
		"winding-rule"};
  static const char * const realNames[]  = {"GDK_EVEN_ODD_RULE",
		"GDK_WINDING_RULE"};
  static const int        cValues[]      = {GDK_EVEN_ODD_RULE,
	GDK_WINDING_RULE};
  return(S_checkEnum(val, localNames, realNames, cValues, 2,"GdkFillRule"));
}
 

USER_OBJECT_
S_check_GtkUpdateType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"continuous",
		"discontinuous",
		"delayed"};
  static const char * const realNames[]  = {"GTK_UPDATE_CONTINUOUS",
		"GTK_UPDATE_DISCONTINUOUS",
		"GTK_UPDATE_DELAYED"};
  static const int        cValues[]      = {GTK_UPDATE_CONTINUOUS,
	GTK_UPDATE_DISCONTINUOUS,
	GTK_UPDATE_DELAYED};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GtkUpdateType"));
}
 

USER_OBJECT_
S_check_GdkOverlapType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"in",
		"out",
		"part"};
  static const char * const realNames[]  = {"GDK_OVERLAP_RECTANGLE_IN",
		"GDK_OVERLAP_RECTANGLE_OUT",
		"GDK_OVERLAP_RECTANGLE_PART"};
  static const int        cValues[]      = {GDK_OVERLAP_RECTANGLE_IN,
	GDK_OVERLAP_RECTANGLE_OUT,
	GDK_OVERLAP_RECTANGLE_PART};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GdkOverlapType"));
}
 

USER_OBJECT_
S_check_GdkPropMode_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"replace",
		"prepend",
		"append"};
  static const char * const realNames[]  = {"GDK_PROP_MODE_REPLACE",
		"GDK_PROP_MODE_PREPEND",
		"GDK_PROP_MODE_APPEND"};
  static const int        cValues[]      = {GDK_PROP_MODE_REPLACE,
	GDK_PROP_MODE_PREPEND,
	GDK_PROP_MODE_APPEND};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GdkPropMode"));
}
 

USER_OBJECT_
S_check_GtkPolicyType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"always",
		"automatic",
		"never"};
  static const char * const realNames[]  = {"GTK_POLICY_ALWAYS",
		"GTK_POLICY_AUTOMATIC",
		"GTK_POLICY_NEVER"};
  static const int        cValues[]      = {GTK_POLICY_ALWAYS,
	GTK_POLICY_AUTOMATIC,
	GTK_POLICY_NEVER};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GtkPolicyType"));
}
 

USER_OBJECT_
S_check_GdkColorContextMode_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"undefined",
		"bw",
		"std-cmap",
		"true",
		"my-gray",
		"palette"};
  static const char * const realNames[]  = {"GDK_CC_MODE_UNDEFINED",
		"GDK_CC_MODE_BW",
		"GDK_CC_MODE_STD_CMAP",
		"GDK_CC_MODE_TRUE",
		"GDK_CC_MODE_MY_GRAY",
		"GDK_CC_MODE_PALETTE"};
  static const int        cValues[]      = {GDK_CC_MODE_UNDEFINED,
	GDK_CC_MODE_BW,
	GDK_CC_MODE_STD_CMAP,
	GDK_CC_MODE_TRUE,
	GDK_CC_MODE_MY_GRAY,
	GDK_CC_MODE_PALETTE};
  return(S_checkEnum(val, localNames, realNames, cValues, 6,"GdkColorContextMode"));
}
 

USER_OBJECT_
S_check_GdkInputSource_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"mouse",
		"pen",
		"eraser",
		"cursor"};
  static const char * const realNames[]  = {"GDK_SOURCE_MOUSE",
		"GDK_SOURCE_PEN",
		"GDK_SOURCE_ERASER",
		"GDK_SOURCE_CURSOR"};
  static const int        cValues[]      = {GDK_SOURCE_MOUSE,
	GDK_SOURCE_PEN,
	GDK_SOURCE_ERASER,
	GDK_SOURCE_CURSOR};
  return(S_checkEnum(val, localNames, realNames, cValues, 4,"GdkInputSource"));
}
 

USER_OBJECT_
S_check_GtkFundamentalType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"invalid",
		"none",
		"char",
		"uchar",
		"bool",
		"int",
		"uint",
		"long",
		"ulong",
		"float",
		"double",
		"string",
		"enum",
		"flags",
		"boxed",
		"pointer",
		"signal",
		"args",
		"callback",
		"c-callback",
		"foreign",
		"object"};
  static const char * const realNames[]  = {"GTK_TYPE_INVALID",
		"GTK_TYPE_NONE",
		"GTK_TYPE_CHAR",
		"GTK_TYPE_UCHAR",
		"GTK_TYPE_BOOL",
		"GTK_TYPE_INT",
		"GTK_TYPE_UINT",
		"GTK_TYPE_LONG",
		"GTK_TYPE_ULONG",
		"GTK_TYPE_FLOAT",
		"GTK_TYPE_DOUBLE",
		"GTK_TYPE_STRING",
		"GTK_TYPE_ENUM",
		"GTK_TYPE_FLAGS",
		"GTK_TYPE_BOXED",
		"GTK_TYPE_POINTER",
		"GTK_TYPE_SIGNAL",
		"GTK_TYPE_ARGS",
		"GTK_TYPE_CALLBACK",
		"GTK_TYPE_C_CALLBACK",
		"GTK_TYPE_FOREIGN",
		"GTK_TYPE_OBJECT"};
  static const int        cValues[]      = {GTK_TYPE_INVALID,
	GTK_TYPE_NONE,
	GTK_TYPE_CHAR,
	GTK_TYPE_UCHAR,
	GTK_TYPE_BOOL,
	GTK_TYPE_INT,
	GTK_TYPE_UINT,
	GTK_TYPE_LONG,
	GTK_TYPE_ULONG,
	GTK_TYPE_FLOAT,
	GTK_TYPE_DOUBLE,
	GTK_TYPE_STRING,
	GTK_TYPE_ENUM,
	GTK_TYPE_FLAGS,
	GTK_TYPE_BOXED,
	GTK_TYPE_POINTER,
	GTK_TYPE_SIGNAL,
	GTK_TYPE_ARGS,
	GTK_TYPE_CALLBACK,
	GTK_TYPE_C_CALLBACK,
	GTK_TYPE_FOREIGN,
	GTK_TYPE_OBJECT};
  return(S_checkEnum(val, localNames, realNames, cValues, 22,"GtkFundamentalType"));
}
 

USER_OBJECT_
S_check_GdkFontType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"font",
		"fontset"};
  static const char * const realNames[]  = {"GDK_FONT_FONT",
		"GDK_FONT_FONTSET"};
  static const int        cValues[]      = {GDK_FONT_FONT,
	GDK_FONT_FONTSET};
  return(S_checkEnum(val, localNames, realNames, cValues, 2,"GdkFontType"));
}
 

USER_OBJECT_
S_check_GtkPreviewType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"color",
		"grayscale"};
  static const char * const realNames[]  = {"GTK_PREVIEW_COLOR",
		"GTK_PREVIEW_GRAYSCALE"};
  static const int        cValues[]      = {GTK_PREVIEW_COLOR,
	GTK_PREVIEW_GRAYSCALE};
  return(S_checkEnum(val, localNames, realNames, cValues, 2,"GtkPreviewType"));
}
 

USER_OBJECT_
S_check_GtkDirectionType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"tab-forward",
		"tab-backward",
		"up",
		"down",
		"left",
		"right"};
  static const char * const realNames[]  = {"GTK_DIR_TAB_FORWARD",
		"GTK_DIR_TAB_BACKWARD",
		"GTK_DIR_UP",
		"GTK_DIR_DOWN",
		"GTK_DIR_LEFT",
		"GTK_DIR_RIGHT"};
  static const int        cValues[]      = {GTK_DIR_TAB_FORWARD,
	GTK_DIR_TAB_BACKWARD,
	GTK_DIR_UP,
	GTK_DIR_DOWN,
	GTK_DIR_LEFT,
	GTK_DIR_RIGHT};
  return(S_checkEnum(val, localNames, realNames, cValues, 6,"GtkDirectionType"));
}
 

USER_OBJECT_
S_check_GtkTreeViewMode_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"line",
		"item"};
  static const char * const realNames[]  = {"GTK_TREE_VIEW_LINE",
		"GTK_TREE_VIEW_ITEM"};
  static const int        cValues[]      = {GTK_TREE_VIEW_LINE,
	GTK_TREE_VIEW_ITEM};
  return(S_checkEnum(val, localNames, realNames, cValues, 2,"GtkTreeViewMode"));
}
 

USER_OBJECT_
S_check_GdkSubwindowMode_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"clip-by-children",
		"include-inferiors"};
  static const char * const realNames[]  = {"GDK_CLIP_BY_CHILDREN",
		"GDK_INCLUDE_INFERIORS"};
  static const int        cValues[]      = {GDK_CLIP_BY_CHILDREN,
	GDK_INCLUDE_INFERIORS};
  return(S_checkEnum(val, localNames, realNames, cValues, 2,"GdkSubwindowMode"));
}
 

USER_OBJECT_
S_check_GdkWindowClass_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"output",
		"only"};
  static const char * const realNames[]  = {"GDK_INPUT_OUTPUT",
		"GDK_INPUT_ONLY"};
  static const int        cValues[]      = {GDK_INPUT_OUTPUT,
	GDK_INPUT_ONLY};
  return(S_checkEnum(val, localNames, realNames, cValues, 2,"GdkWindowClass"));
}
 

USER_OBJECT_
S_check_GtkSideType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"top",
		"bottom",
		"left",
		"right"};
  static const char * const realNames[]  = {"GTK_SIDE_TOP",
		"GTK_SIDE_BOTTOM",
		"GTK_SIDE_LEFT",
		"GTK_SIDE_RIGHT"};
  static const int        cValues[]      = {GTK_SIDE_TOP,
	GTK_SIDE_BOTTOM,
	GTK_SIDE_LEFT,
	GTK_SIDE_RIGHT};
  return(S_checkEnum(val, localNames, realNames, cValues, 4,"GtkSideType"));
}
 

USER_OBJECT_
S_check_GtkOrientation_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"horizontal",
		"vertical"};
  static const char * const realNames[]  = {"GTK_ORIENTATION_HORIZONTAL",
		"GTK_ORIENTATION_VERTICAL"};
  static const int        cValues[]      = {GTK_ORIENTATION_HORIZONTAL,
	GTK_ORIENTATION_VERTICAL};
  return(S_checkEnum(val, localNames, realNames, cValues, 2,"GtkOrientation"));
}
 

USER_OBJECT_
S_check_GdkByteOrder_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"lsb-first",
		"msb-first"};
  static const char * const realNames[]  = {"GDK_LSB_FIRST",
		"GDK_MSB_FIRST"};
  static const int        cValues[]      = {GDK_LSB_FIRST,
	GDK_MSB_FIRST};
  return(S_checkEnum(val, localNames, realNames, cValues, 2,"GdkByteOrder"));
}
 

USER_OBJECT_
S_check_GtkProgressBarOrientation_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"left-to-right",
		"right-to-left",
		"bottom-to-top",
		"top-to-bottom"};
  static const char * const realNames[]  = {"GTK_PROGRESS_LEFT_TO_RIGHT",
		"GTK_PROGRESS_RIGHT_TO_LEFT",
		"GTK_PROGRESS_BOTTOM_TO_TOP",
		"GTK_PROGRESS_TOP_TO_BOTTOM"};
  static const int        cValues[]      = {GTK_PROGRESS_LEFT_TO_RIGHT,
	GTK_PROGRESS_RIGHT_TO_LEFT,
	GTK_PROGRESS_BOTTOM_TO_TOP,
	GTK_PROGRESS_TOP_TO_BOTTOM};
  return(S_checkEnum(val, localNames, realNames, cValues, 4,"GtkProgressBarOrientation"));
}
 

USER_OBJECT_
S_check_GtkSubmenuDirection_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"left",
		"right"};
  static const char * const realNames[]  = {"GTK_DIRECTION_LEFT",
		"GTK_DIRECTION_RIGHT"};
  static const int        cValues[]      = {GTK_DIRECTION_LEFT,
	GTK_DIRECTION_RIGHT};
  return(S_checkEnum(val, localNames, realNames, cValues, 2,"GtkSubmenuDirection"));
}
 

USER_OBJECT_
S_check_GdkSelection_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"primary",
		"secondary"};
  static const char * const realNames[]  = {"GDK_SELECTION_PRIMARY",
		"GDK_SELECTION_SECONDARY"};
  static const int        cValues[]      = {GDK_SELECTION_PRIMARY,
	GDK_SELECTION_SECONDARY};
  return(S_checkEnum(val, localNames, realNames, cValues, 2,"GdkSelection"));
}
 

USER_OBJECT_
S_check_GtkAnchorType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"center",
		"north",
		"north-west",
		"north-east",
		"south",
		"south-west",
		"south-east",
		"west",
		"east",
		"n",
		"nw",
		"ne",
		"s",
		"sw",
		"se",
		"w",
		"e"};
  static const char * const realNames[]  = {"GTK_ANCHOR_CENTER",
		"GTK_ANCHOR_NORTH",
		"GTK_ANCHOR_NORTH_WEST",
		"GTK_ANCHOR_NORTH_EAST",
		"GTK_ANCHOR_SOUTH",
		"GTK_ANCHOR_SOUTH_WEST",
		"GTK_ANCHOR_SOUTH_EAST",
		"GTK_ANCHOR_WEST",
		"GTK_ANCHOR_EAST",
		"GTK_ANCHOR_N",
		"GTK_ANCHOR_NW",
		"GTK_ANCHOR_NE",
		"GTK_ANCHOR_S",
		"GTK_ANCHOR_SW",
		"GTK_ANCHOR_SE",
		"GTK_ANCHOR_W",
		"GTK_ANCHOR_E"};
  static const int        cValues[]      = {GTK_ANCHOR_CENTER,
	GTK_ANCHOR_NORTH,
	GTK_ANCHOR_NORTH_WEST,
	GTK_ANCHOR_NORTH_EAST,
	GTK_ANCHOR_SOUTH,
	GTK_ANCHOR_SOUTH_WEST,
	GTK_ANCHOR_SOUTH_EAST,
	GTK_ANCHOR_WEST,
	GTK_ANCHOR_EAST,
	GTK_ANCHOR_N,
	GTK_ANCHOR_NW,
	GTK_ANCHOR_NE,
	GTK_ANCHOR_S,
	GTK_ANCHOR_SW,
	GTK_ANCHOR_SE,
	GTK_ANCHOR_W,
	GTK_ANCHOR_E};
  return(S_checkEnum(val, localNames, realNames, cValues, 17,"GtkAnchorType"));
}
 

USER_OBJECT_
S_check_GtkJustification_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"left",
		"right",
		"center",
		"fill"};
  static const char * const realNames[]  = {"GTK_JUSTIFY_LEFT",
		"GTK_JUSTIFY_RIGHT",
		"GTK_JUSTIFY_CENTER",
		"GTK_JUSTIFY_FILL"};
  static const int        cValues[]      = {GTK_JUSTIFY_LEFT,
	GTK_JUSTIFY_RIGHT,
	GTK_JUSTIFY_CENTER,
	GTK_JUSTIFY_FILL};
  return(S_checkEnum(val, localNames, realNames, cValues, 4,"GtkJustification"));
}
 

USER_OBJECT_
S_check_GtkMenuDirectionType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"parent",
		"child",
		"next",
		"prev"};
  static const char * const realNames[]  = {"GTK_MENU_DIR_PARENT",
		"GTK_MENU_DIR_CHILD",
		"GTK_MENU_DIR_NEXT",
		"GTK_MENU_DIR_PREV"};
  static const int        cValues[]      = {GTK_MENU_DIR_PARENT,
	GTK_MENU_DIR_CHILD,
	GTK_MENU_DIR_NEXT,
	GTK_MENU_DIR_PREV};
  return(S_checkEnum(val, localNames, realNames, cValues, 4,"GtkMenuDirectionType"));
}
 

USER_OBJECT_
S_check_GdkDragProtocol_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"motif",
		"xdnd",
		"rootwin"};
  static const char * const realNames[]  = {"GDK_DRAG_PROTO_MOTIF",
		"GDK_DRAG_PROTO_XDND",
		"GDK_DRAG_PROTO_ROOTWIN"};
  static const int        cValues[]      = {GDK_DRAG_PROTO_MOTIF,
	GDK_DRAG_PROTO_XDND,
	GDK_DRAG_PROTO_ROOTWIN};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GdkDragProtocol"));
}
 

USER_OBJECT_
S_check_GtkSubmenuPlacement_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"top-bottom",
		"left-right"};
  static const char * const realNames[]  = {"GTK_TOP_BOTTOM",
		"GTK_LEFT_RIGHT"};
  static const int        cValues[]      = {GTK_TOP_BOTTOM,
	GTK_LEFT_RIGHT};
  return(S_checkEnum(val, localNames, realNames, cValues, 2,"GtkSubmenuPlacement"));
}
 

USER_OBJECT_
S_check_GtkSpinButtonUpdatePolicy_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"always",
		"if-valid"};
  static const char * const realNames[]  = {"GTK_UPDATE_ALWAYS",
		"GTK_UPDATE_IF_VALID"};
  static const int        cValues[]      = {GTK_UPDATE_ALWAYS,
	GTK_UPDATE_IF_VALID};
  return(S_checkEnum(val, localNames, realNames, cValues, 2,"GtkSpinButtonUpdatePolicy"));
}
 

USER_OBJECT_
S_check_GtkTroughType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"none",
		"start",
		"end",
		"jump"};
  static const char * const realNames[]  = {"GTK_TROUGH_NONE",
		"GTK_TROUGH_START",
		"GTK_TROUGH_END",
		"GTK_TROUGH_JUMP"};
  static const int        cValues[]      = {GTK_TROUGH_NONE,
	GTK_TROUGH_START,
	GTK_TROUGH_END,
	GTK_TROUGH_JUMP};
  return(S_checkEnum(val, localNames, realNames, cValues, 4,"GtkTroughType"));
}
 

USER_OBJECT_
S_check_GtkSelectionMode_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"single",
		"browse",
		"multiple",
		"extended"};
  static const char * const realNames[]  = {"GTK_SELECTION_SINGLE",
		"GTK_SELECTION_BROWSE",
		"GTK_SELECTION_MULTIPLE",
		"GTK_SELECTION_EXTENDED"};
  static const int        cValues[]      = {GTK_SELECTION_SINGLE,
	GTK_SELECTION_BROWSE,
	GTK_SELECTION_MULTIPLE,
	GTK_SELECTION_EXTENDED};
  return(S_checkEnum(val, localNames, realNames, cValues, 4,"GtkSelectionMode"));
}
 

USER_OBJECT_
S_check_GdkWindowHints_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"pos",
		"min-size",
		"max-size",
		"base-size",
		"aspect",
		"resize-inc"};
  static const char * const realNames[]  = {"GDK_HINT_POS",
		"GDK_HINT_MIN_SIZE",
		"GDK_HINT_MAX_SIZE",
		"GDK_HINT_BASE_SIZE",
		"GDK_HINT_ASPECT",
		"GDK_HINT_RESIZE_INC"};
  static const int        cValues[]      = {GDK_HINT_POS,
	GDK_HINT_MIN_SIZE,
	GDK_HINT_MAX_SIZE,
	GDK_HINT_BASE_SIZE,
	GDK_HINT_ASPECT,
	GDK_HINT_RESIZE_INC};
  return(S_checkFlag(val, localNames, realNames, cValues, 6,"GdkWindowHints"));
}
 

USER_OBJECT_
S_check_GtkWidgetFlags_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"toplevel",
		"no-window",
		"realized",
		"mapped",
		"visible",
		"sensitive",
		"parent-sensitive",
		"can-focus",
		"has-focus",
		"can-default",
		"has-default",
		"has-grab",
		"rc-style",
		"composite-child",
		"no-reparent",
		"app-paintable"};
  static const char * const realNames[]  = {"GTK_TOPLEVEL",
		"GTK_NO_WINDOW",
		"GTK_REALIZED",
		"GTK_MAPPED",
		"GTK_VISIBLE",
		"GTK_SENSITIVE",
		"GTK_PARENT_SENSITIVE",
		"GTK_CAN_FOCUS",
		"GTK_HAS_FOCUS",
		"GTK_CAN_DEFAULT",
		"GTK_HAS_DEFAULT",
		"GTK_HAS_GRAB",
		"GTK_RC_STYLE",
		"GTK_COMPOSITE_CHILD",
		"GTK_NO_REPARENT",
		"GTK_APP_PAINTABLE"};
  static const int        cValues[]      = {GTK_TOPLEVEL,
	GTK_NO_WINDOW,
	GTK_REALIZED,
	GTK_MAPPED,
	GTK_VISIBLE,
	GTK_SENSITIVE,
	GTK_PARENT_SENSITIVE,
	GTK_CAN_FOCUS,
	GTK_HAS_FOCUS,
	GTK_CAN_DEFAULT,
	GTK_HAS_DEFAULT,
	GTK_HAS_GRAB,
	GTK_RC_STYLE,
	GTK_COMPOSITE_CHILD,
	GTK_NO_REPARENT,
	GTK_APP_PAINTABLE};
  return(S_checkFlag(val, localNames, realNames, cValues, 16,"GtkWidgetFlags"));
}
 

USER_OBJECT_
S_check_GtkArgFlags_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"readable",
		"writable",
		"construct",
		"construct-only",
		"child-arg",
		"mask",
		"readwrite"};
  static const char * const realNames[]  = {"GTK_ARG_READABLE",
		"GTK_ARG_WRITABLE",
		"GTK_ARG_CONSTRUCT",
		"GTK_ARG_CONSTRUCT_ONLY",
		"GTK_ARG_CHILD_ARG",
		"GTK_ARG_MASK",
		"GTK_ARG_READWRITE"};
  static const int        cValues[]      = {GTK_ARG_READABLE,
	GTK_ARG_WRITABLE,
	GTK_ARG_CONSTRUCT,
	GTK_ARG_CONSTRUCT_ONLY,
	GTK_ARG_CHILD_ARG,
	GTK_ARG_MASK,
	GTK_ARG_READWRITE};
  return(S_checkFlag(val, localNames, realNames, cValues, 7,"GtkArgFlags"));
}
 

USER_OBJECT_
S_check_GdkICAttributesType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"style",
		"client-window",
		"focus-window",
		"filter-events",
		"spot-location",
		"line-spacing",
		"cursor",
		"preedit-fontset",
		"preedit-area",
		"preedit-area-needed",
		"preedit-foreground",
		"preedit-background",
		"preedit-pixmap",
		"preedit-colormap",
		"status-fontset",
		"status-area",
		"status-area-needed",
		"status-foreground",
		"status-background",
		"status-pixmap",
		"status-colormap",
		"all-req",
		"client-window",
		"preedit-area-req",
		"preedit-fontset",
		"preedit-position-req",
		"preedit-fontset",
		"status-area-req",
		"status-fontset"};
  static const char * const realNames[]  = {"GDK_IC_STYLE",
		"GDK_IC_CLIENT_WINDOW",
		"GDK_IC_FOCUS_WINDOW",
		"GDK_IC_FILTER_EVENTS",
		"GDK_IC_SPOT_LOCATION",
		"GDK_IC_LINE_SPACING",
		"GDK_IC_CURSOR",
		"GDK_IC_PREEDIT_FONTSET",
		"GDK_IC_PREEDIT_AREA",
		"GDK_IC_PREEDIT_AREA_NEEDED",
		"GDK_IC_PREEDIT_FOREGROUND",
		"GDK_IC_PREEDIT_BACKGROUND",
		"GDK_IC_PREEDIT_PIXMAP",
		"GDK_IC_PREEDIT_COLORMAP",
		"GDK_IC_STATUS_FONTSET",
		"GDK_IC_STATUS_AREA",
		"GDK_IC_STATUS_AREA_NEEDED",
		"GDK_IC_STATUS_FOREGROUND",
		"GDK_IC_STATUS_BACKGROUND",
		"GDK_IC_STATUS_PIXMAP",
		"GDK_IC_STATUS_COLORMAP",
		"GDK_IC_ALL_REQ",
		"GDK_IC_CLIENT_WINDOW",
		"GDK_IC_PREEDIT_AREA_REQ",
		"GDK_IC_PREEDIT_FONTSET",
		"GDK_IC_PREEDIT_POSITION_REQ",
		"GDK_IC_PREEDIT_FONTSET",
		"GDK_IC_STATUS_AREA_REQ",
		"GDK_IC_STATUS_FONTSET"};
  static const int        cValues[]      = {GDK_IC_STYLE,
	GDK_IC_CLIENT_WINDOW,
	GDK_IC_FOCUS_WINDOW,
	GDK_IC_FILTER_EVENTS,
	GDK_IC_SPOT_LOCATION,
	GDK_IC_LINE_SPACING,
	GDK_IC_CURSOR,
	GDK_IC_PREEDIT_FONTSET,
	GDK_IC_PREEDIT_AREA,
	GDK_IC_PREEDIT_AREA_NEEDED,
	GDK_IC_PREEDIT_FOREGROUND,
	GDK_IC_PREEDIT_BACKGROUND,
	GDK_IC_PREEDIT_PIXMAP,
	GDK_IC_PREEDIT_COLORMAP,
	GDK_IC_STATUS_FONTSET,
	GDK_IC_STATUS_AREA,
	GDK_IC_STATUS_AREA_NEEDED,
	GDK_IC_STATUS_FOREGROUND,
	GDK_IC_STATUS_BACKGROUND,
	GDK_IC_STATUS_PIXMAP,
	GDK_IC_STATUS_COLORMAP,
	GDK_IC_ALL_REQ,
	GDK_IC_CLIENT_WINDOW,
	GDK_IC_PREEDIT_AREA_REQ,
	GDK_IC_PREEDIT_FONTSET,
	GDK_IC_PREEDIT_POSITION_REQ,
	GDK_IC_PREEDIT_FONTSET,
	GDK_IC_STATUS_AREA_REQ,
	GDK_IC_STATUS_FONTSET};
  return(S_checkFlag(val, localNames, realNames, cValues, 29,"GdkICAttributesType"));
}
 

USER_OBJECT_
S_check_GdkWindowAttributesType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"title",
		"x",
		"y",
		"cursor",
		"colormap",
		"visual",
		"wmclass",
		"noredir"};
  static const char * const realNames[]  = {"GDK_WA_TITLE",
		"GDK_WA_X",
		"GDK_WA_Y",
		"GDK_WA_CURSOR",
		"GDK_WA_COLORMAP",
		"GDK_WA_VISUAL",
		"GDK_WA_WMCLASS",
		"GDK_WA_NOREDIR"};
  static const int        cValues[]      = {GDK_WA_TITLE,
	GDK_WA_X,
	GDK_WA_Y,
	GDK_WA_CURSOR,
	GDK_WA_COLORMAP,
	GDK_WA_VISUAL,
	GDK_WA_WMCLASS,
	GDK_WA_NOREDIR};
  return(S_checkFlag(val, localNames, realNames, cValues, 8,"GdkWindowAttributesType"));
}
 

USER_OBJECT_
S_check_GtkObjectFlags_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"destroyed",
		"floating",
		"connected",
		"constructed"};
  static const char * const realNames[]  = {"GTK_DESTROYED",
		"GTK_FLOATING",
		"GTK_CONNECTED",
		"GTK_CONSTRUCTED"};
  static const int        cValues[]      = {GTK_DESTROYED,
	GTK_FLOATING,
	GTK_CONNECTED,
	GTK_CONSTRUCTED};
  return(S_checkFlag(val, localNames, realNames, cValues, 4,"GtkObjectFlags"));
}
 

USER_OBJECT_
S_check_GtkAccelFlags_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"visible",
		"signal-visible",
		"locked",
		"mask"};
  static const char * const realNames[]  = {"GTK_ACCEL_VISIBLE",
		"GTK_ACCEL_SIGNAL_VISIBLE",
		"GTK_ACCEL_LOCKED",
		"GTK_ACCEL_MASK"};
  static const int        cValues[]      = {GTK_ACCEL_VISIBLE,
	GTK_ACCEL_SIGNAL_VISIBLE,
	GTK_ACCEL_LOCKED,
	GTK_ACCEL_MASK};
  return(S_checkFlag(val, localNames, realNames, cValues, 4,"GtkAccelFlags"));
}
 

USER_OBJECT_
S_check_GdkIMStyle_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"preedit-area",
		"preedit-callbacks",
		"preedit-position",
		"preedit-nothing",
		"preedit-none",
		"preedit-mask",
		"status-area",
		"status-callbacks",
		"status-nothing",
		"status-none",
		"status-mask"};
  static const char * const realNames[]  = {"GDK_IM_PREEDIT_AREA",
		"GDK_IM_PREEDIT_CALLBACKS",
		"GDK_IM_PREEDIT_POSITION",
		"GDK_IM_PREEDIT_NOTHING",
		"GDK_IM_PREEDIT_NONE",
		"GDK_IM_PREEDIT_MASK",
		"GDK_IM_STATUS_AREA",
		"GDK_IM_STATUS_CALLBACKS",
		"GDK_IM_STATUS_NOTHING",
		"GDK_IM_STATUS_NONE",
		"GDK_IM_STATUS_MASK"};
  static const int        cValues[]      = {GDK_IM_PREEDIT_AREA,
	GDK_IM_PREEDIT_CALLBACKS,
	GDK_IM_PREEDIT_POSITION,
	GDK_IM_PREEDIT_NOTHING,
	GDK_IM_PREEDIT_NONE,
	GDK_IM_PREEDIT_MASK,
	GDK_IM_STATUS_AREA,
	GDK_IM_STATUS_CALLBACKS,
	GDK_IM_STATUS_NOTHING,
	GDK_IM_STATUS_NONE,
	GDK_IM_STATUS_MASK};
  return(S_checkFlag(val, localNames, realNames, cValues, 11,"GdkIMStyle"));
}
 

USER_OBJECT_
S_check_GdkDragAction_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"default",
		"copy",
		"move",
		"link",
		"private",
		"ask"};
  static const char * const realNames[]  = {"GDK_ACTION_DEFAULT",
		"GDK_ACTION_COPY",
		"GDK_ACTION_MOVE",
		"GDK_ACTION_LINK",
		"GDK_ACTION_PRIVATE",
		"GDK_ACTION_ASK"};
  static const int        cValues[]      = {GDK_ACTION_DEFAULT,
	GDK_ACTION_COPY,
	GDK_ACTION_MOVE,
	GDK_ACTION_LINK,
	GDK_ACTION_PRIVATE,
	GDK_ACTION_ASK};
  return(S_checkFlag(val, localNames, realNames, cValues, 6,"GdkDragAction"));
}
 

USER_OBJECT_
S_check_GtkFontType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"bitmap",
		"scalable",
		"scalable-bitmap",
		"all"};
  static const char * const realNames[]  = {"GTK_FONT_BITMAP",
		"GTK_FONT_SCALABLE",
		"GTK_FONT_SCALABLE_BITMAP",
		"GTK_FONT_ALL"};
  static const int        cValues[]      = {GTK_FONT_BITMAP,
	GTK_FONT_SCALABLE,
	GTK_FONT_SCALABLE_BITMAP,
	GTK_FONT_ALL};
  return(S_checkFlag(val, localNames, realNames, cValues, 4,"GtkFontType"));
}
 

USER_OBJECT_
S_check_GdkWMFunction_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"all",
		"resize",
		"move",
		"minimize",
		"maximize",
		"close"};
  static const char * const realNames[]  = {"GDK_FUNC_ALL",
		"GDK_FUNC_RESIZE",
		"GDK_FUNC_MOVE",
		"GDK_FUNC_MINIMIZE",
		"GDK_FUNC_MAXIMIZE",
		"GDK_FUNC_CLOSE"};
  static const int        cValues[]      = {GDK_FUNC_ALL,
	GDK_FUNC_RESIZE,
	GDK_FUNC_MOVE,
	GDK_FUNC_MINIMIZE,
	GDK_FUNC_MAXIMIZE,
	GDK_FUNC_CLOSE};
  return(S_checkFlag(val, localNames, realNames, cValues, 6,"GdkWMFunction"));
}
 

USER_OBJECT_
S_check_GdkGCValuesMask_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"foreground",
		"background",
		"font",
		"function",
		"fill",
		"tile",
		"stipple",
		"clip-mask",
		"subwindow",
		"ts-x-origin",
		"ts-y-origin",
		"clip-x-origin",
		"clip-y-origin",
		"exposures",
		"line-width",
		"line-style",
		"cap-style",
		"join-style"};
  static const char * const realNames[]  = {"GDK_GC_FOREGROUND",
		"GDK_GC_BACKGROUND",
		"GDK_GC_FONT",
		"GDK_GC_FUNCTION",
		"GDK_GC_FILL",
		"GDK_GC_TILE",
		"GDK_GC_STIPPLE",
		"GDK_GC_CLIP_MASK",
		"GDK_GC_SUBWINDOW",
		"GDK_GC_TS_X_ORIGIN",
		"GDK_GC_TS_Y_ORIGIN",
		"GDK_GC_CLIP_X_ORIGIN",
		"GDK_GC_CLIP_Y_ORIGIN",
		"GDK_GC_EXPOSURES",
		"GDK_GC_LINE_WIDTH",
		"GDK_GC_LINE_STYLE",
		"GDK_GC_CAP_STYLE",
		"GDK_GC_JOIN_STYLE"};
  static const int        cValues[]      = {GDK_GC_FOREGROUND,
	GDK_GC_BACKGROUND,
	GDK_GC_FONT,
	GDK_GC_FUNCTION,
	GDK_GC_FILL,
	GDK_GC_TILE,
	GDK_GC_STIPPLE,
	GDK_GC_CLIP_MASK,
	GDK_GC_SUBWINDOW,
	GDK_GC_TS_X_ORIGIN,
	GDK_GC_TS_Y_ORIGIN,
	GDK_GC_CLIP_X_ORIGIN,
	GDK_GC_CLIP_Y_ORIGIN,
	GDK_GC_EXPOSURES,
	GDK_GC_LINE_WIDTH,
	GDK_GC_LINE_STYLE,
	GDK_GC_CAP_STYLE,
	GDK_GC_JOIN_STYLE};
  return(S_checkFlag(val, localNames, realNames, cValues, 18,"GdkGCValuesMask"));
}
 

USER_OBJECT_
S_check_GtkSignalRunType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"first",
		"last",
		"both",
		"no-recurse",
		"action",
		"no-hooks"};
  static const char * const realNames[]  = {"GTK_RUN_FIRST",
		"GTK_RUN_LAST",
		"GTK_RUN_BOTH",
		"GTK_RUN_NO_RECURSE",
		"GTK_RUN_ACTION",
		"GTK_RUN_NO_HOOKS"};
  static const int        cValues[]      = {GTK_RUN_FIRST,
	GTK_RUN_LAST,
	GTK_RUN_BOTH,
	GTK_RUN_NO_RECURSE,
	GTK_RUN_ACTION,
	GTK_RUN_NO_HOOKS};
  return(S_checkFlag(val, localNames, realNames, cValues, 6,"GtkSignalRunType"));
}
 

USER_OBJECT_
S_check_GtkDestDefaults_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"motion",
		"highlight",
		"drop",
		"all"};
  static const char * const realNames[]  = {"GTK_DEST_DEFAULT_MOTION",
		"GTK_DEST_DEFAULT_HIGHLIGHT",
		"GTK_DEST_DEFAULT_DROP",
		"GTK_DEST_DEFAULT_ALL"};
  static const int        cValues[]      = {GTK_DEST_DEFAULT_MOTION,
	GTK_DEST_DEFAULT_HIGHLIGHT,
	GTK_DEST_DEFAULT_DROP,
	GTK_DEST_DEFAULT_ALL};
  return(S_checkFlag(val, localNames, realNames, cValues, 4,"GtkDestDefaults"));
}
 

USER_OBJECT_
S_check_GtkRcFlags_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"fg",
		"bg",
		"text",
		"base"};
  static const char * const realNames[]  = {"GTK_RC_FG",
		"GTK_RC_BG",
		"GTK_RC_TEXT",
		"GTK_RC_BASE"};
  static const int        cValues[]      = {GTK_RC_FG,
	GTK_RC_BG,
	GTK_RC_TEXT,
	GTK_RC_BASE};
  return(S_checkFlag(val, localNames, realNames, cValues, 4,"GtkRcFlags"));
}
 

USER_OBJECT_
S_check_GdkWMDecoration_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"all",
		"border",
		"resizeh",
		"title",
		"menu",
		"minimize",
		"maximize"};
  static const char * const realNames[]  = {"GDK_DECOR_ALL",
		"GDK_DECOR_BORDER",
		"GDK_DECOR_RESIZEH",
		"GDK_DECOR_TITLE",
		"GDK_DECOR_MENU",
		"GDK_DECOR_MINIMIZE",
		"GDK_DECOR_MAXIMIZE"};
  static const int        cValues[]      = {GDK_DECOR_ALL,
	GDK_DECOR_BORDER,
	GDK_DECOR_RESIZEH,
	GDK_DECOR_TITLE,
	GDK_DECOR_MENU,
	GDK_DECOR_MINIMIZE,
	GDK_DECOR_MAXIMIZE};
  return(S_checkFlag(val, localNames, realNames, cValues, 7,"GdkWMDecoration"));
}
 

USER_OBJECT_
S_check_GdkModifierType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"shift-mask",
		"lock-mask",
		"control-mask",
		"mod1-mask",
		"mod2-mask",
		"mod3-mask",
		"mod4-mask",
		"mod5-mask",
		"button1-mask",
		"button2-mask",
		"button3-mask",
		"button4-mask",
		"button5-mask",
		"release-mask",
		"modifier-mask"};
  static const char * const realNames[]  = {"GDK_SHIFT_MASK",
		"GDK_LOCK_MASK",
		"GDK_CONTROL_MASK",
		"GDK_MOD1_MASK",
		"GDK_MOD2_MASK",
		"GDK_MOD3_MASK",
		"GDK_MOD4_MASK",
		"GDK_MOD5_MASK",
		"GDK_BUTTON1_MASK",
		"GDK_BUTTON2_MASK",
		"GDK_BUTTON3_MASK",
		"GDK_BUTTON4_MASK",
		"GDK_BUTTON5_MASK",
		"GDK_RELEASE_MASK",
		"GDK_MODIFIER_MASK"};
  static const int        cValues[]      = {GDK_SHIFT_MASK,
	GDK_LOCK_MASK,
	GDK_CONTROL_MASK,
	GDK_MOD1_MASK,
	GDK_MOD2_MASK,
	GDK_MOD3_MASK,
	GDK_MOD4_MASK,
	GDK_MOD5_MASK,
	GDK_BUTTON1_MASK,
	GDK_BUTTON2_MASK,
	GDK_BUTTON3_MASK,
	GDK_BUTTON4_MASK,
	GDK_BUTTON5_MASK,
	GDK_RELEASE_MASK,
	GDK_MODIFIER_MASK};
  return(S_checkFlag(val, localNames, realNames, cValues, 15,"GdkModifierType"));
}
 

USER_OBJECT_
S_check_GtkAttachOptions_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"expand",
		"shrink",
		"fill"};
  static const char * const realNames[]  = {"GTK_EXPAND",
		"GTK_SHRINK",
		"GTK_FILL"};
  static const int        cValues[]      = {GTK_EXPAND,
	GTK_SHRINK,
	GTK_FILL};
  return(S_checkFlag(val, localNames, realNames, cValues, 3,"GtkAttachOptions"));
}
 

USER_OBJECT_
S_check_GdkInputCondition_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"read",
		"write",
		"exception"};
  static const char * const realNames[]  = {"GDK_INPUT_READ",
		"GDK_INPUT_WRITE",
		"GDK_INPUT_EXCEPTION"};
  static const int        cValues[]      = {GDK_INPUT_READ,
	GDK_INPUT_WRITE,
	GDK_INPUT_EXCEPTION};
  return(S_checkFlag(val, localNames, realNames, cValues, 3,"GdkInputCondition"));
}
 

USER_OBJECT_
S_check_GdkEventMask_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"exposure-mask",
		"pointer-motion-mask",
		"pointer-motion-hint-mask",
		"button-motion-mask",
		"button1-motion-mask",
		"button2-motion-mask",
		"button3-motion-mask",
		"button-press-mask",
		"button-release-mask",
		"key-press-mask",
		"key-release-mask",
		"enter-notify-mask",
		"leave-notify-mask",
		"focus-change-mask",
		"structure-mask",
		"property-change-mask",
		"visibility-notify-mask",
		"proximity-in-mask",
		"proximity-out-mask",
		"substructure-mask",
		"all-events-mask"};
  static const char * const realNames[]  = {"GDK_EXPOSURE_MASK",
		"GDK_POINTER_MOTION_MASK",
		"GDK_POINTER_MOTION_HINT_MASK",
		"GDK_BUTTON_MOTION_MASK",
		"GDK_BUTTON1_MOTION_MASK",
		"GDK_BUTTON2_MOTION_MASK",
		"GDK_BUTTON3_MOTION_MASK",
		"GDK_BUTTON_PRESS_MASK",
		"GDK_BUTTON_RELEASE_MASK",
		"GDK_KEY_PRESS_MASK",
		"GDK_KEY_RELEASE_MASK",
		"GDK_ENTER_NOTIFY_MASK",
		"GDK_LEAVE_NOTIFY_MASK",
		"GDK_FOCUS_CHANGE_MASK",
		"GDK_STRUCTURE_MASK",
		"GDK_PROPERTY_CHANGE_MASK",
		"GDK_VISIBILITY_NOTIFY_MASK",
		"GDK_PROXIMITY_IN_MASK",
		"GDK_PROXIMITY_OUT_MASK",
		"GDK_SUBSTRUCTURE_MASK",
		"GDK_ALL_EVENTS_MASK"};
  static const int        cValues[]      = {GDK_EXPOSURE_MASK,
	GDK_POINTER_MOTION_MASK,
	GDK_POINTER_MOTION_HINT_MASK,
	GDK_BUTTON_MOTION_MASK,
	GDK_BUTTON1_MOTION_MASK,
	GDK_BUTTON2_MOTION_MASK,
	GDK_BUTTON3_MOTION_MASK,
	GDK_BUTTON_PRESS_MASK,
	GDK_BUTTON_RELEASE_MASK,
	GDK_KEY_PRESS_MASK,
	GDK_KEY_RELEASE_MASK,
	GDK_ENTER_NOTIFY_MASK,
	GDK_LEAVE_NOTIFY_MASK,
	GDK_FOCUS_CHANGE_MASK,
	GDK_STRUCTURE_MASK,
	GDK_PROPERTY_CHANGE_MASK,
	GDK_VISIBILITY_NOTIFY_MASK,
	GDK_PROXIMITY_IN_MASK,
	GDK_PROXIMITY_OUT_MASK,
	GDK_SUBSTRUCTURE_MASK,
	GDK_ALL_EVENTS_MASK};
  return(S_checkFlag(val, localNames, realNames, cValues, 21,"GdkEventMask"));
}
 

USER_OBJECT_
S_check_GtkButtonAction_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"ignored",
		"selects",
		"drags",
		"expands"};
  static const char * const realNames[]  = {"GTK_BUTTON_IGNORED",
		"GTK_BUTTON_SELECTS",
		"GTK_BUTTON_DRAGS",
		"GTK_BUTTON_EXPANDS"};
  static const int        cValues[]      = {GTK_BUTTON_IGNORED,
	GTK_BUTTON_SELECTS,
	GTK_BUTTON_DRAGS,
	GTK_BUTTON_EXPANDS};
  return(S_checkFlag(val, localNames, realNames, cValues, 4,"GtkButtonAction"));
}
 

USER_OBJECT_
S_check_GtkTargetFlags_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"same-app",
		"same-widget"};
  static const char * const realNames[]  = {"GTK_TARGET_SAME_APP",
		"GTK_TARGET_SAME_WIDGET"};
  static const int        cValues[]      = {GTK_TARGET_SAME_APP,
	GTK_TARGET_SAME_WIDGET};
  return(S_checkFlag(val, localNames, realNames, cValues, 2,"GtkTargetFlags"));
}
 

USER_OBJECT_
S_check_GtkDebugFlag_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"objects",
		"misc",
		"signals",
		"dnd"};
  static const char * const realNames[]  = {"GTK_DEBUG_OBJECTS",
		"GTK_DEBUG_MISC",
		"GTK_DEBUG_SIGNALS",
		"GTK_DEBUG_DND"};
  static const int        cValues[]      = {GTK_DEBUG_OBJECTS,
	GTK_DEBUG_MISC,
	GTK_DEBUG_SIGNALS,
	GTK_DEBUG_DND};
  return(S_checkFlag(val, localNames, realNames, cValues, 4,"GtkDebugFlag"));
}
 

USER_OBJECT_
S_check_GtkPackerOptions_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"expand",
		"fill-x",
		"fill-y"};
  static const char * const realNames[]  = {"GTK_PACK_EXPAND",
		"GTK_FILL_X",
		"GTK_FILL_Y"};
  static const int        cValues[]      = {GTK_PACK_EXPAND,
	GTK_FILL_X,
	GTK_FILL_Y};
  return(S_checkFlag(val, localNames, realNames, cValues, 3,"GtkPackerOptions"));
}
 

USER_OBJECT_
S_check_GtkCalendarDisplayOptions_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"show-heading",
		"show-day-names",
		"no-month-change",
		"show-week-numbers",
		"week-start-monday"};
  static const char * const realNames[]  = {"GTK_CALENDAR_SHOW_HEADING",
		"GTK_CALENDAR_SHOW_DAY_NAMES",
		"GTK_CALENDAR_NO_MONTH_CHANGE",
		"GTK_CALENDAR_SHOW_WEEK_NUMBERS",
		"GTK_CALENDAR_WEEK_START_MONDAY"};
  static const int        cValues[]      = {GTK_CALENDAR_SHOW_HEADING,
	GTK_CALENDAR_SHOW_DAY_NAMES,
	GTK_CALENDAR_NO_MONTH_CHANGE,
	GTK_CALENDAR_SHOW_WEEK_NUMBERS,
	GTK_CALENDAR_WEEK_START_MONDAY};
  return(S_checkFlag(val, localNames, realNames, cValues, 5,"GtkCalendarDisplayOptions"));
}
 

