#include "RGtk.h"
#include "gtkUtils.h"
#include <R.h>

USER_OBJECT_ R_internalGetTypeArgs(GtkType type);


USER_OBJECT_
R_gtkGetObjectArgInfo(USER_OBJECT_ sobj, USER_OBJECT_ parent)
{
    GtkType type, objectType;
    int n, i;
    USER_OBJECT_ ans;

#if 0
    GtkObject *obj;
    obj = GTK_OBJECT(getPtrValue(sobj));
    type = GTK_OBJECT_TYPE(obj);
#else
    type = objectType = (GtkType) NUMERIC_POINTER(sobj)[0];
#endif

    if(LOGICAL_DATA(parent)[0] == FALSE)
	return(R_internalGetTypeArgs(type));


    n = 0;
    while(type != GTK_TYPE_INVALID) {
	type = gtk_type_parent(type);
        n++;
    }

    PROTECT(ans = NEW_LIST(n));
    type = objectType;
    i = 0;
    do {
	SET_VECTOR_ELT(ans, i++, R_internalGetTypeArgs(type));
    } while((type = gtk_type_parent(type)) != GTK_TYPE_INVALID);

    SET_NAMES(ans, R_internal_getTypeHierarchy(objectType));
    UNPROTECT(1);

    return(ans);
}

USER_OBJECT_
R_internalGetTypeArgs(GtkType type)
{
    USER_OBJECT_ ans, names, argNames, tmp;
    GtkArg *args;
    guint32 *flags;
    int num, ctr = 0, i;
    args = gtk_object_query_args(type, &flags, &num);

    PROTECT(argNames = NEW_CHARACTER(2));
    SET_STRING_ELT(argNames, 0, COPY_TO_USER_STRING("type"));
    SET_STRING_ELT(argNames, 1, COPY_TO_USER_STRING("flag"));
    PROTECT(ans = NEW_LIST(num));
    PROTECT(names = NEW_CHARACTER(num));
    for(i = 0; i < num; i++) {
        PROTECT(tmp = NEW_LIST(2));
        SET_VECTOR_ELT(tmp, 0, R_createGtkType(args[i].type, NULL));
        SET_VECTOR_ELT(tmp, 1, R_toRFlag(flags[i], "GtkArgFlags"));
        SET_NAMES(tmp, argNames);
        SET_VECTOR_ELT(ans, ctr, tmp);
        UNPROTECT(1);
	SET_STRING_ELT(names, ctr, COPY_TO_USER_STRING(args[i].name));
        ctr++;
    }

    g_free(flags);
    g_free(args);

    SET_NAMES(ans, names);
    UNPROTECT(3);
    return(ans);
}


USER_OBJECT_
R_getObjectArgs(USER_OBJECT_ sobj, USER_OBJECT_ argNames)
{
    USER_OBJECT_ ans;
    int i,n;

    GtkObject *obj;
    GtkArg *args;
    obj = GTK_OBJECT(getPtrValue(sobj));
    n = GET_LENGTH(argNames);
    if(n == 0)
	return(NULL_USER_OBJECT);

    args = (GtkArg*) R_alloc(n, sizeof(GtkArg));
    for(i = 0; i < n; i++) {
	args[i].name = CHAR_DEREF(STRING_ELT(argNames, i));
    }    
    gtk_object_getv(obj, n, args);

    PROTECT(ans = NEW_LIST(n));
    for(i = 0; i < n; i++) {
	SET_VECTOR_ELT(ans, i, convertGtkArgToSValue(args[i]));
    }

    SET_NAMES(ans, argNames);
    UNPROTECT(1);
    return(ans);
}


USER_OBJECT_
R_setObjectArgs(USER_OBJECT_ sobj, USER_OBJECT_ svals, USER_OBJECT_ argNames)
{
    USER_OBJECT_ ans = NULL_USER_OBJECT;
    int i,n;

    GtkObject *obj;
    GtkArg *args;

    obj = GTK_OBJECT(getPtrValue(sobj));
    n = GET_LENGTH(argNames);
    if(n == 0)
	return(NULL_USER_OBJECT);

    args = (GtkArg*) R_alloc(n, sizeof(GtkArg));
    for(i = 0; i < n; i++) {
	args[i].name = CHAR_DEREF(STRING_ELT(argNames, i));
        R_setArgFromSValue(VECTOR_ELT(svals, i), args+i);
    }    
    gtk_object_setv(obj, n, args);

    return(ans);
}


void
Rgtk_bitAnd(Sint *val, Sint *els, Sint *len, Sint *ans)
{
    int i;
    for(i = 0; i < *len; i++) {
	ans[i] = ((unsigned int) els[i]) & ((unsigned int) val[0]);
    }
}
