\name{getSignalInfo}
\alias{getSignalInfo}
\title{Information for all signals for multiple classes}
\description{
  This retrieves the signal information for
  all of the signals defined for each of the classes
  specified by \code{classes}.
  This is just a convenient front-end to
  \code{\link{gtkSignalGetInfo}} for a large number of signals.
}
\usage{
getSignalInfo(classes=.GtkClasses, load=TRUE)
}
\arguments{
  \item{classes}{a character vector containing the names of
  different Gtk classes/types}
\item{load}{a logical value indicating whether to
  force the initialization of the different classes
  before asking for their signals. The class must be initialized
  for the information to be available. If an instance of the
  class has been created or the C routine \code{gtk_<type>_get_type}
  has been called (directly or indirectly), the class has been initialized.}
}
\value{
  A list with elements for each of the classes.
  Each element is itself a list with an element for
  each of the signals defined for that class.
  Each element within this list is the value returned
  from \code{\link{gtkSignalGetInfo}}
}
\references{
  Information on the package is available
  from \url{http://www.omegahat.org/RGtk}.

  Information on Gtk is available from
  \url{http://www.gtk.org}.
}
\author{
Duncan Temple Lang <duncan@research.bell-labs.com>
}


\seealso{
  \code{\link{gtkSignalGetInfo}}
}

\examples{
 gtkInit()
 .C("gtk_button_get_type", PACKAGE = "RGtk")
 getSignalInfo("GtkButton")
}
\keyword{interface}
