\name{children}
\alias{gtkChildren}
\alias{gtkContainerGetChildren}
\alias{gtkParent}
\alias{gtkWidgetGetParent}
\title{Get child widgets of a Gtk container}
\description{
This returns a list of the widgets that
are currently contained or managed by 
a particular Gtk container widget.
}
\usage{
gtkChildren(w, full = TRUE)
gtkContainerGetChildren(w, full = TRUE)
gtkParent(w, full = TRUE)
gtkWidgetGetParent(w, full = TRUE)
}
\arguments{
  \item{w}{the Gtk widget object whose children or parent
    widget(s) are to be retrieved.
    For \code{gtkChildren}, the object should be an object
    that inherits from the class \code{GtkContainer}.
  }
  \item{full}{a logical value indicating whether we should
    examine the resulting object(s) and expand the class
    based on the run-time type. If this is \code{FALSE},
    a generic class \code{GtkWidget} is used.
    If one does not need to know what type of widget the
    parent or children widgets are, then specify \code{FALSE}
   to save processing.}
}
\value{
 For \code{gtkChildren},
  a list with each element corresponding
  to a child in the container widget.


  If \code{full} is \code{TRUE}, the class of each widget
  returned will contain information about the actual
  type of the underlying Gtk widget. Otherwise, it will simply
  be \code{GtkWidget}.
  
}
\references{
\url{http://www.gtk.org}
\url{http://www.omegahat.org/RGtk}
}
\author{Duncan Temple Lang}
\note{This is an extra-ordinarily early release 
intended to encourage others to contribute code, etc.}

\seealso{
\code{\link{gtkParent}}
}

\examples{

}
\keyword{interface}
\keyword{GUI}
