\name{names.GtkObject}
\alias{names.GtkObject}
\alias{gtkObjectGetArgInfo}
\title{Access information about properties of a GtkObject}
\description{
  These allow one to discover what ``properties'' or variables
  a Gtk object supports and the details of each property
  such as its type and whether it can be set or only read.
}
\usage{
names.GtkObject(x)
gtkObjectGetArgInfo(obj, parents=TRUE, collapse=FALSE, strip=FALSE)
}
\arguments{
  \item{x}{the Gtk object the names of whose properties are to be queried}
  \item{obj}{the Gtk object for which the property information is to be retrieved}
  \item{parents}{a logical value indicating whether to get the
    properties of the parent classes as well as the specific class of
    the Gtk object \code{obj}. If this is true, we iterate over the
    successive super-classes of \code{obj}.
    }
  \item{collapse}{a logical value indicating whether the information
    about parent classes should be collapsed into a single list (\code{TRUE})
    or maintained as separate elements in a top-level list that allows
    one to determine to which class each property originates.
    The names of a property contains the class for which it is defined.
  }
  \item{strip}{a logical value indicating whether to remove the
    class prefix in the name of the property (\code{TRUE}) or
    leave it (\code{FALSE}) so that one can identify for which class
    the property was defined and inherited.}
}
\details{
  A regular user will probably want to look at
  \code{names} and call \code{gtkObjectGetArgInfo}
  with \code{parents = TRUE}, \code{collapse=TRUE} and \code{strip =
    TRUE} to find all the available properties in the most
  convenient format.
  Tool writers using the reflectance may want to get the associated
  classes and process the properties hierarchically.
}
\value{
  \code{names} returns a character vector giving
  the names of the available properties
  with the class prefix removed.

  \code{gtkObjectGetArgInfo} returns a list giving details of
  the properties. At the lowest level, each property
  is described by a list containing
  \item{type}{an object of class \code{GtkType} which identifies the
   type (!) of the value of the property.}
  \item{flag}{an object of class \code{GtkArgFlags} which
    specifies whether the property is read-only or read-write
    and when it can be specified, etc. This is a 
    logical OR of the relevant values. See \code{\link{.GtkArgFlags}}.}
  Each property is indexed by its name in the list.
  
  The precise form of the returned value depends on the different
  arguments.
  If \code{parents} is \code{FALSE}, then a simple list giving
  each property for the class of \code{obj} is returned.
  If \code{parents} is \code{TRUE} and \code{collapse} is
  \code{FALSE}, then a list indexed by class is returned.
  Each element is a list containing the property information.

  If \code{strip} is \code{FALSE}, the property names used to
  to index the list of properties does not contain the class identifier
  (\code{class:...}). Otherwise it does.
  
}
\references{

}
\author{
Duncan Temple Lang <duncan@research.bell-labs.com>
}
\note{
}


\seealso{
\code{\link{$.GtkObject}}
}

\examples{

}
\keyword{interface}
