gtkTopWindow <-
function(title="My Window", show = TRUE)
{
 w <- .Call("R_gtk_window", as.character(title))
 class(w) <- "GtkWindow"

 if(show)
   gtkWidgetShow(w)
 w
}

gtkAdd <-
  #
  # Turn this around so that the parent is first to 
  # be consistent with gtkContainerAdd()
  # Also, make this ....
function(parent, ..., .flush = TRUE)
{
  widgets <- list(...)
  if(length(widgets) == 0)
    stop("No widgets to add to parent")

  if(!all(sapply(widgets, gtkCheckInherits))) {
    stop("Non widget objects passed to gtkAdd()")
  }

  .GtkCall("R_gtk_addWidget", parent, widgets, .flush = .flush)
}

gtkShow <-
function(..., all=TRUE, .flush = TRUE)
{
 .GtkCall("R_gtk_showWidget", list(...), as.logical(all), .flush = .flush)
}

gtkAddCallback <- gtkObjectAddCallback <-
function(w, signal, f, data = NULL, object = TRUE, after = TRUE)
{
  useData <- missing(data) == FALSE
  gtkCheckInherits(w, "GtkObject")

  if(is.null(f))
    stop("You've specified NULL as the action in setting a callback. Did you mean to use quote()")

  if(is.expression(f)) {
    f <- f[[1]]
  }
  
  if(!( is.expression(f) || is.function(f) || is.call(f))) {
    stop(paste("Callback action must be an expression, a call or a function, but instead is of type", typeof(f), ". Did you forget to use quote()"))
  }

  .Call("R_gtk_setCallback", w, f, as.character(signal), data, useData, as.logical(object), as.logical(after))
}

gtkObjectRemoveCallback <- gtkObjectDisconnectCallback <-
function(obj, id)
{
 gtkCheckInherits(obj, "GtkObject")    
 .Call("R_gtk_disconnectSignalHandler", obj, as.integer(id))
}

gtkObjectBlockCallback <-
function(obj, id)
{
  gtkCheckInherits(obj, "GtkObject")  
 .Call("R_gtk_blockSignalHandler", obj, as.integer(id), TRUE)
}

gtkObjectUnblockCallback <-
function(obj, id)
{
  gtkCheckInherits(obj, "GtkObject")
 .Call("R_gtk_blockSignalHandler", obj, as.integer(id), FALSE)
}  


gtkAddTimeout <-
function(interval, f, data = NULL, .flush = TRUE)
{
 useData <- !missing(data)

 if(!is.function(f))
   stop("Timeout handlers must be function objects")
 
 .GtkCall("R_gtkAddTimeout", as.integer(interval),  f, data, useData, .flush = .flush)
}  


gtkRemoveTimeout <-
function(id)
{
  gtkCheckInherits(id, "GtkTimeoutId")
  .Call("R_gtkRemoveTimeout", as.integer(id))
}  


gtkAddIdle <-
function(f, data = NULL, .flush = TRUE)
{
 useData <- !missing(data)

 if(!is.function(f)) {
  stop("Idle functions must be functions!")
 }

  .GtkCall("R_gtkAddIdle", f, data, useData, .flush = .flush)
}

gtkRemoveIdle <-
function(id)
{
  gtkCheckInherits(id, "GtkIdleId")
  .Call("R_gtkRemoveIdle", as.integer(id))
}  
