#!/home/ocon/bin/rexx
/*
 * makerexxtk.rexx - generate Rexx/Tk template program from specTcl ui files.
*/
Trace o
Parse Arg args
fn = Word(args,1)
If fn = '' Then Call Usage
uis = Subword(args,2)
Call BuildHeader fn, uis
Call BuildCallbacks fn, uis
Return

BuildHeader: Procedure
Parse Arg fn, uis
Call Stream fn, 'C', 'OPEN WRITE REPLACE'
Call Lineout fn, "/*"
Call Lineout fn, " *" fn "generated by makerexxtk.rexx on" Date() "at" Time()
Call Lineout fn, " */"
Call Lineout fn, "Trace o"
Call Lineout fn, ""
Call Lineout fn, "Call RxFuncAdd 'TkLoadFuncs', 'rexxtk', 'TkLoadFuncs'"
Call Lineout fn, "Call TkLoadFuncs"
Call Lineout fn, ""
Call Lineout fn, "Call SetupMainWindow"
Call Lineout fn, ""
Call Lineout fn, "/*"
Call Lineout fn, " * Our 'normal' Rexx/Tk loop"
Call Lineout fn, " */"
Call Lineout fn, "Do Forever"
Call Lineout fn, "   Interpret 'Call' TkWait()"
Call Lineout fn, "End"
Call Lineout fn, ""
Call Lineout fn, "Return"
Call Lineout fn, ""
Call Lineout fn, "SetupMainWindow:"
Call Lineout fn, "/*"
Call Lineout fn, " * Load the UI Tcl code, but don't execute it"
Call Lineout fn, " */"
Do i = 1 To Words(uis)
Call Lineout fn, "Call TkTcl 'source', '" || Word(uis,i) || ".ui.tcl'"
End
Call Lineout fn, "/*"
Call Lineout fn, " * Add any other setup code here"
Call Lineout fn, " */"
Call Lineout fn, ""
Call Lineout fn, "/*"
Call Lineout fn, " * The first ui file will be executed"
Call Lineout fn, " */"
Call Lineout fn, "Call TkTcl '" || Word(uis,1) || "_ui', '.'"
Call Lineout fn, ""
Call Lineout fn, "Return"
Return

BuildCallbacks: Procedure
Parse Arg fn, uis
tclvars = ''
rexxtk_commands = ''
idx = 0
Call Lineout fn, ""
Call Lineout fn, "/*"
widget_tag. = ''
widget_name. = ''
widget_type. = ''
widget_parent. = ''
widget_command. = ''
widget_variable. = ''
widget_ui. = ''
Do i = 1 To Words(uis)
   ui = Word(uis,i) || ".ui"
   Do While(Lines(ui) > 0)
      line = Linein(ui)
      Parse Var line word1 word2 word3
      Select
         When word1 = 'configure' & word2 = 'variable' Then
            Do
               If Wordpos( word3, tclvars ) = 0 Then tclvars = tclvars word3
               widget_variable.idx = word3
            End
         When word1 = 'configure' & word2 = 'textvariable' Then
            Do
               If Wordpos( word3, tclvars ) = 0 Then tclvars = tclvars word3
               widget_variable.idx = word3
            End
         When word1 = 'configure' & word2 = 'command' Then
            Do
               Parse Var word3 . '{' cmd '}' .
               If Translate(Word(cmd,1)) = 'SETREXXTK' Then
                  Do
                     widget_command.idx = Subword(cmd,2)
                     If Wordpos( Subword(cmd,2), rexxtk_commands ) = 0 Then rexxtk_commands = rexxtk_commands Subword(cmd,2)
                     Else Say 'Warning: Duplicate function:' Subword(cmd,2) 'defined'
                  End
            End
         When word1 = 'other' & word2 = 'item_name' Then
            Do
               widget_name.idx = word3
            End
         When word1 = 'other' & word2 = 'type' Then
            Do
               widget_type.idx = word3
            End
         When word1 = 'other' & word2 = 'master' Then
            Do
               If word3 \= '{}' Then widget_master.idx = Substr(word3,2)
            End
         When Substr(line, 1, 6) = 'Widget' Then
            Do
               idx = idx + 1
               widget_tag.idx = Word(line,2)
               widget_ui.idx = ui
            End
         Otherwise
            Nop
      End
   End
End
widget_name.0 = idx
/*
 * Resolve the "real" name of the widget
 */
Do i = 1 To widget_name.0
   Do j = 1 To widget_name.0
      If widget_master.i = widget_tag.j Then
         Do
            widget_name.i = widget_name.j || '.' || widget_name.i
            Leave
         End
   End
End
ui_name = ''
Do i = 1 To widget_name.0
   If widget_name.i \= 'f' Then
      Do
         If ui_name \= widget_ui.i Then
            Do
              Call Lineout fn, " * Widgets defined in UI:" widget_ui.i
              ui_name = widget_ui.i
            End
         Call Charout fn, "   ." || widget_name.i "(type:" widget_type.i || ')'
         If widget_command.i \= '' Then Call Charout fn, " (function:" widget_command.i || ')'
         If widget_variable.i \= '' Then Call Charout fn, " (variable:" widget_variable.i || ')'
         Call Lineout fn, ""
      End
End
Call Lineout fn, " */"
Do i = 1 To widget_name.0
   If widget_command.i \= '' Then
      Call WriteCmdFunction fn, widget_name.i, widget_command.i, widget_ui.i
End
/*
 * Don't write out Tcl varaible functions
Do i = 1 To Words(tclvars)
   Call WriteVarFunction fn, Word( tclvars, i )
End
*/
Return

WriteCmdFunction: Procedure
Parse Arg fn, widget, cmd, ui
Call Lineout fn, ""
Call Lineout fn, "/*"
Call Lineout fn, " * This function is called from the ." || widget "widget in UI:" ui
Call Lineout fn, " */"
Call Lineout fn, cmd || ":"
Call Lineout fn, "/*"
Call Lineout fn, " * Put your code here"
Call Lineout fn, " */"
Call Lineout fn, "Say '" || cmd "called'"
Call Lineout fn, "Return"
Return

WriteVarFunction: Procedure
Parse Arg fn, tclvar
Call Lineout fn, ""
Call Lineout fn, "/*"
Call Lineout fn, " * This function returns the value of the Tcl variable:" tclvar
Call Lineout fn, " */"
Call Lineout fn, "GetValueOf" || tclvar || ":"
Call Lineout fn, ""
Call Lineout fn, "Return TkVar( '" || tclvar || "' )"
Return

Usage: Procedure
Say 'This program generates a template Rexx/Tk program based on the output'
Say 'from specTcl.'
Say
Say 'The first argument is the name of the Rexx/Tk program to build'
Say 'Any subsequent arguments specify the base specTcl user interface'
Say 'files that the Rexx/Tk program will use. eg if you have built two'
Say 'user interface files from specTcl, called mdlog and dlog2, then you'
Say 'will have the files:'
Say '  mdlog.ui, mdlog.ui.tcl and'
Say '  dlog2.ui, dlog2.ui.tcl'
Say 
Say 'To generate mytk.rexx using the above two user interface files:'
Say '  rexx makerexxtk.rexx mytk.rexx mdlog dlog2'
Say
Say 'The order of the user interface files is important, as the first'
Say 'one will be executed by default.'
Exit
