;;; Copyright (C) 2001 Ian Campbell <ijc@hellion.org.uk>
;;;
;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2 of the
;;; License, or (at your option) any later version.
;;;
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
;;; General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
;;; USA.

(define-structure xmms.command 

    (export xmms-add-url
	    xmms-all-hide
	    xmms-all-show
	    xmms-always-on-top-set
	    xmms-always-on-top-unset
	    xmms-balance-set
	    xmms-eject
	    xmms-eq-hide
	    xmms-eq-show
	    xmms-eq-toggle
	    xmms-jump-to-time
	    xmms-main-hide
	    xmms-main-show
	    xmms-main-toggle
	    xmms-main-volume-dec
	    xmms-main-volume-inc
	    xmms-main-volume-set
	    xmms-next
	    xmms-pause
	    xmms-paused-toggle
	    xmms-play
	    xmms-playlist-add
	    xmms-playlist-clear
	    xmms-playlist-delete
	    xmms-playlist-hide
	    xmms-playlist-pos-set
	    xmms-playlist-set
	    xmms-playlist-show
	    xmms-playlist-toggle
	    xmms-prefs-show
	    xmms-prev
	    xmms-quit
	    xmms-repeat-toggle
	    xmms-shuffle-toggle
	    xmms-stop
	    xmms-time-shift
	    xmms-volume-set)

    (open rep 
	  sawfish.wm.commands
	  xmms.remote)
	    
    (define-command 'xmms-play xmms-play)
    (define-command 'xmms-paused-toggle
      (lambda ()
	"Toggle Play/Pause."
	(if (xmms-playing-p)
	    (xmms-pause)
	  (xmms-play))))

    (define-command 'xmms-stop xmms-stop)
    (define-command 'xmms-pause xmms-pause)
    (define-command 'xmms-prev xmms-prev)
    (define-command 'xmms-next xmms-next)
    
    (define-command 'xmms-playlist-pos-set xmms-playlist-pos-set
      #:type `(and (labelled ,(_ "Position:") (number 0))))

    (define-command 'xmms-playlist-add xmms-playlist-add
      #:type `(and (quoted (list string ,(_ "Tracks:")))))

    (define-command 'xmms-playlist-delete xmms-playlist-delete
      #:type `(and (labelled ,(_ "Position:") (number 0))))

    (define-command 'xmms-playlist-clear xmms-playlist-clear)
    (define-command 'xmms-jump-to-time xmms-jump-to-time
      #:type `(and (labelled ,(_ "Time:") number)))

    (define-command 'xmms-time-shift
      (lambda (seconds)
        (xmms-jump-to-time (+ (xmms-get-output-time) (* 1000 seconds))))
      #:type `(and (labelled ,(_ "Seconds:") (number -10000 10000))))
    
    (define-command 'xmms-volume-set xmms-volume-set
      #:type `(and (labelled ,(_ "Left/Right Channel:") (quoted (pair (number 1 100) (number 1 100))))))
    
    (define-command 'xmms-main-volume-set xmms-main-volume-set
      #:type `(and (labelled ,(_ "Volume:")(number 1 100))))
    
    (define-command 'xmms-main-volume-inc
      (lambda (step)
	(xmms-main-volume-set (+ (xmms-main-volume-get) step)))
      #:type `(and (labelled ,(_ "Step:")(number 1 100))))

    (define-command 'xmms-main-volume-dec
      (lambda (step)
	(xmms-main-volume-set (- (xmms-main-volume-get) step)))
      #:type `(and (labelled ,(_ "Step:") (number 1 100))))

    (define-command 'xmms-balance-set xmms-balance-set
      #:type `(and (labelled ,(_ "Balance:") (number -100 100))))

    (define-command 'xmms-all-show
      (lambda () 
	"Show all the windows."
	(xmms-main-visible t)
	(xmms-eq-visible t)
	(xmms-playlist-visible t)))

    (define-command 'xmms-all-hide
      (lambda () 
	"Hide all the main window."
	(xmms-main-visible nil)
	(xmms-eq-visible nil)
	(xmms-playlist-visible nil)))

    (define-command 'xmms-main-show
      (lambda () 
	"Show the main window."
	(xmms-main-visible t)))
    (define-command 'xmms-main-hide
      (lambda () 
	"Hide the main window."
	(xmms-main-visible nil)))
    (define-command 'xmms-main-toggle
      (lambda () 
	"Toggle the main window."
	(if (xmms-main-p)
	    (xmms-main-visible nil)
	  (xmms-main-visible t))))
    
    (define-command 'xmms-playlist-show 
      (lambda () 
	"Show the playlist window."
	(xmms-playlist-visible t)))
    (define-command 'xmms-playlist-hide 
      (lambda () 
	"Hide the playlist window."
	(xmms-playlist-visible nil)))
    (define-command 'xmms-playlist-toggle
      (lambda () 
	"Toggle the playlist window."
	(if (xmms-playlist-p)
	    (xmms-playlist-visible nil)
	  (xmms-playlist-visible t))))

    (define-command 'xmms-eq-show 
      (lambda () 
	"Show the equalizer window."
	(xmms-eq-visible t)))
    (define-command 'xmms-eq-hide 
      (lambda () 
	"Hide the equalizer window."
	(xmms-eq-visible nil)))
    (define-command 'xmms-eq-toggle
      (lambda () 
	"Toggle the equalizer window."
	(if (xmms-eq-p)
	    (xmms-eq-visible nil)
	  (xmms-eq-visible t))))
    
    (define-command 'xmms-prefs-show xmms-prefs-show)
    
    (define-command 'xmms-always-on-top-set
      (lambda () 
	"Make XMMS stay on top of other windows."
	(xmms-always-on-top-toggle t)))
    (define-command 'xmms-always-on-top-unset
      (lambda () 
	"Don't make XMMS stay on top of other windows."
	(xmms-always-on-top-toggle nil)))
    
    (define-command 'xmms-eject xmms-eject)
    (define-command 'xmms-playlist-add-url xmms-playlist-add-url
      #:type `(and (labelled ,(_ "URL:") (string))))
    (define-command 'xmms-repeat-toggle xmms-repeat-toggle)
    (define-command 'xmms-shuffle-toggle xmms-shuffle-toggle)
    (define-command 'xmms-quit xmms-quit)
)
