#!@@PERL@@ @@PERLOPTS@@

# Copyright 1999, 2000, 2001 (c) Thomas Erskine <@@AUTHOR@@>
# See the COPYRIGHT file with the distribution.

# new-ping-hosts - make a config-file fragment from a file of hostnames
# $Id: new-ping-hosts.pl,v 1.9 2001/08/28 15:22:24 remstats Exp $

# - - -   Configuration   - - -

# What is this program called, for error-messages and file-names
$main::prog = 'new-ping-hosts';
# Where is the config-dir
$main::config_dir = '@@CONFIGDIR@@';

# - - -   Version History   - - -

(undef, $main::version) = split(' ', '$Revision: 1.9 $');

# - - -   Setup   - - -

use lib '.', '@@LIBDIR@@';
use Socket;
use Getopt::Std;
require "remstats.pl";

# Parse the command-line
# STRICT use vars qw( $opt_d $opt_f $opt_h );
getopts('d:f:h');

if (defined $main::opt_h) { &usage; } # no return
if (defined $main::opt_d) { $main::debug = $main::opt_d; } else { $main::debug = 0; }
if (defined $main::opt_f) { $main::config_dir = $main::opt_f; }

if ($#ARGV < 0) { &usage; }
my $group = shift @ARGV;
$group =~ tr/_/ /;
if ($#ARGV < 0) { push @ARGV, '-'; } # read stdin

unless (-d $main::config_dir) {
	&abort("missing config-dir $main::config_dir");
}
&read_config_dir( $main::config_dir, 'general');

&add_group_if_missing( $group);

# - - -   Mainline   - - -

my ($host, $ip, $hostfile);
foreach my $file (@ARGV) {
	open (FILE, "<$file") or die "can't open $file: $!\n";
	while (<FILE>) {
		chomp;
		next if (/^#/ or /^\s*$/);
		$host = lc $_;
		$ip = &get_ip($host);
		if (defined $ip) { $ip = "\n#ip	$ip"; }
		else { $ip = ''; }

		$hostfile = $main::config_dir .'/hosts/'. $host;
		if (-f $hostfile) {
			open (HOST, ">>$hostfile") or 
				&abort("can't open $hostfile: $!");
			print HOST "rrd\tping\n";
			close(HOST);
		}
		else {
			open (HOST, ">$hostfile") or
				&abort("can't open $hostfile: $!");
			print HOST <<"EOD_HOST";
# hosts/$host
desc	$group host
group	$group$ip
tools	ping traceroute availability status
rrd	ping
EOD_HOST
			close(HOST);
		}
	}
	close (FILE);
}

# Save the new ip_cache
&write_ip_cache;

# Touch config_dir to note that the configuration has changed
my $now = time;
utime $now, $now, $main::config_dir or
	&abort("can't touch $main::config_dir for update-time");

exit 0;

#----------------------------------------------------------------- usage ---
sub usage {
	print STDERR <<"EOD_USAGE";
$main::prog version $main::version
usage: $main::prog [options] group [hostfile ...]
where options are:
    -d nnn  enable debugging output at level 'nnn'
    -f fff  use 'fff' as config-dir [$main::config_dir]
    -h      show this help
EOD_USAGE
	exit 0;
}

#----------------------------------------------------------------- debug ---
sub debug {
	my ($msg) = @_;

	if ($main::debug) { print STDERR "DEBUG: $msg\n"; }
0;
}

#---------------------------------------------------------------- abort ---
sub abort {
	my ($msg) = @_;
	print STDERR "$main::prog: ABORT: $msg\n";
	exit 1;
}

#----------------------------------------------- keep_strict_happy ---
sub keep_strict_happy {
	$main::opt_h = 0;
}

#---------------------------------------------------------------- error ---
sub error {
	my ($msg) = @_;
	print STDERR "ERROR: $msg\n";
}
