#!@@PERL@@ @@PERLOPTS@@

# Copyright 1999, 2000, 2001 (c) Thomas Erskine <@@AUTHOR@@>
# See the COPYRIGHT file with the distribution.

# cleanup - remove cruft that gets left around.  Run it out of cron
# $Id: cleanup.pl,v 1.4 2001/08/28 15:22:24 remstats Exp $

# - - -   Configuration   - - -

use strict;

# What is this program called, for error-messages and file-names
$main::prog = 'cleanup';
# Where is the default configuration dir
$main::config_dir = '@@CONFIGDIR@@';

# - - -   Version History   - - -

(undef, $main::version) = split(' ', '$Revision: 1.4 $');

# - - -   Setup   - - -

use lib '.', '@@LIBDIR@@', '@@RRDLIBDIR@@';
require "remstats.pl";
use Getopt::Std;

# Parse the command-line
my %opt = ();
getopts('d:f:h', \%opt);

if (defined $opt{'h'}) { &usage; } # no return
if (defined $opt{'d'}) { $main::debug = $opt{'d'}; } else { $main::debug = 0; }
if (defined $opt{'f'}) { $main::config_dir = $opt{'f'}; }

&read_config_dir($main::config_dir, 'general', 'html', 'groups', 'oids', 
	'rrds', 'groups', 'host-templates', 'hosts');

# No buffering when debugging
if ($main::debug) { $| = 1; }

# - - -   Mainline   - - -

my ($host);

# Some directories shouldn't have old files in them
&clean_dir( $main::config{DATADIR}. '/LAST', 24*60*60, '*');
&clean_dir( $main::config{DATADIR}. '/LOGS', $main::config{KEEPLOGS}, '*');
&clean_dir( $main::config{DATADIR}. '/TRACEROUTES', $main::config{KEEPLOGS}, '*');
&clean_dir( $main::config{HTMLDIR}. '/MOVIES', 24*60*60, 'snap-*.png', 'snap-*.gif');

# Clean host graphs
foreach $host (keys %{$main::config{HOST}}) {
	next if ($host eq '_remstats_');
	&clean_dir( $main::config{HTMLDIR} .'/'.  $main::config{HTML}{KEEPIMAGES}, 
		'snap-*.png', 'snap-*.gif');
}

exit 0;

#----------------------------------------------------------------- clean_dir ---
sub clean_dir {
	my ($dir, $max_age, @patterns) = @_;
	my (@files, $file, $age, $pattern);

# Collect the list of files
	@files = ();
	foreach my $pattern (@patterns) {
		push @files, glob $dir . '/' . $pattern;
	}

# Check each one
	foreach $file (@files) {
		next if( $file =~ /^\./);
		$age = (-M $file) * 24*60*60;
		if ($age > $max_age) {
			unlink $file or &error("can't unlink $file: $!");
		}
	}
}

#----------------------------------------------------------------- usage ---
sub usage {
	print STDERR <<"EOD_USAGE";
$main::prog version $main::version
usage: $0 [options]
where options are:
    -d nnn  enable debugging output at level 'nnn'
    -f fff  use 'fff' for config-dir [$main::config_dir]
    -h      show this help
EOD_USAGE
	exit 0;
}

#----------------------------------------------------------------- debug ---
sub debug {
	my $msg = join('', @_);
	print STDERR "DEBUG: $msg\n";
}

#------------------------------------------------------------------ abort ---
sub abort {
	my $msg = join('', @_);
	print STDERR "$main::prog: ABORT: $msg\n";
	exit 1;
}

#------------------------------------------------------------------ error ---
sub error {
	my $msg = join('', @_);
	print STDERR "$main::prog: ERROR: $msg\n";
}
