/*
RealTimeBattle, a robot programming game for Unix
Copyright (C) 1998-2000  Erik Ouchterlony and Ragnar Ouchterlony

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.
*/

#ifndef __GAMEOPTIONTYPE__
#define __GAMEOPTIONTYPE__

/**
* Namespace Parser
*/
namespace Parser {
	enum game_option_type
	{
	  ROBOT_MAX_ROTATE=0,
	  ROBOT_CANNON_MAX_ROTATE=1,
	  ROBOT_RADAR_MAX_ROTATE=2,

	  ROBOT_MAX_ACCELERATION=3,
	  ROBOT_MIN_ACCELERATION=4,

	  ROBOT_START_ENERGY=5,
	  ROBOT_MAX_ENERGY=6,
	  ROBOT_ENERGY_LEVELS=7,

	  SHOT_SPEED=8,
	  SHOT_MIN_ENERGY=9,
	  SHOT_MAX_ENERGY=10,
	  SHOT_ENERGY_INCREASE_SPEED=11,

	  TIMEOUT=12,

	  DEBUG_LEVEL=13,            // 0 - no debug, 5 - highest debug level

	  SEND_ROBOT_COORDINATES= 14    // 0 - no coordinates, 
					// 1 - coordniates are given relative the starting position
					// 2 - absolute coordinates 
	};
}


#endif 
