#ifndef _raptor_menu_h_
#define _raptor_menu_h_

#include "allegro.h"

class RFont;
class RField;

class RMenu{
public:

	RMenu( BITMAP * intr, int x, int y, int c1, int c2, int title_color );

	//addMenu: Adds a RField class to the list
	virtual void addTitle( char * n, RFont * rf );
	virtual void addMenu( char * n, RFont * rf, bool s, int r, RMenu * who, SAMPLE * pl );
	virtual void addMenu( BITMAP * look, bool s, int r, RMenu * who, SAMPLE * pl );

	//replace: Replaces a given RField with a new RField at position q in the list
	virtual void replace( int q, char * n, RFont * rf, bool s, int r, RMenu * who, SAMPLE * pl );
	virtual void replaceTitle( int q, char * n, RFont * rf );
	virtual void replace( int q, BITMAP * look, bool s, int r, RMenu * who, SAMPLE * pl );

	//returns the place where field str lives, or -1 if cant find
	virtual int askPos( char * str );

	//procMenu: Runs the current menu, returning the value of the menu
	//and changing the current menu to the selected one
	virtual int procMenu( RMenu ** current );

	virtual void init();

	virtual bool changed();
	
	virtual void nextMenu( int q, RMenu * nx );
	
	virtual void prevMenu( RMenu * rm );

	virtual RMenu * Previous();

	virtual void clear();

	virtual bool Selected();

	virtual ~RMenu();

protected:

	int countNodes();
	void spiffy_triangle( BITMAP * work, int x1, int y1, int color, int * shade, int MAX_SHADE, int dir );
	virtual void Draw( BITMAP * work, int x, int * yval, int * yshade, int min, int max );
	virtual void endMenu();

	BITMAP * background;

	int last_opt;
	int first_x, first_y;

	int col1, col2;
	int t_color;
	RField * head, * location;
	RMenu * prev;

	int * shade;
	int * shade_border;
	int * shade_opt_color;

	bool select;

protected:

	BITMAP * work;

	double x1;
	int ang;

	int col_up;
	int col_down;
	int opt_max;
	int max_seen;				  //maximum number of fields on the screen at any one time
	int * opts;
	RField * field_seen;
	int keep_y;
	int * opts_shade;
	RField * temp;
	int ac_y;
	bool k_hold;
	int min_x;
	int shade_counter;

	bool initialized;
	bool change;

};

#endif
