#include "gunobj.h"
#include "allegro.h"
#include "gun_rotate.h"
#include "trigtable.h"
#include "ebox.h"
#include "spaceobj.h"
#include "defs.h"
#include "weapon_rotate.h"
#include "hull_weapon_rotate.h"

WeaponRotateGun::WeaponRotateGun( int z, int d, SAMPLE * _smp, int al ):
WeaponObject( d, "Rotate Gun", 250000, al, z, 4 ) {
	smp = _smp;

	angX = rnd( 360 );
	angY = rnd( 360 );
	dX = (rnd( 8 ) + 10 ) * (rnd(2)*2-1);
	dY = (rnd( 8 ) + 10 ) * (rnd(2)*2-1);
	dwX = dX;
	dwY = dY;
	maxX = 400;
	maxY = 400;

	BITMAP * temp = create_bitmap( 20, 20 );
	clear_to_color( temp, makecol(255,0,255) );
	circlefill( temp, 10, 10, 10, makecol(255,0,0) );
	collide = new ECollide( temp, 2, makecol(255,0,255), 30.0 );
	destroy_bitmap( temp );

}


WeaponRotateGun::~WeaponRotateGun() {
	delete collide;
}


void WeaponRotateGun::MakeShot(int x, int y, vector< SpaceObject * > * Ammo, vector< SpaceObject * > * fight ) {

	shot_counter = 24;
	int dam = 40 + (strength + 1 ) * 10;

	int base = rnd( 100 );
	for ( int q = 0; q < 360; q += 360 / (strength + 4) )
		Ammo->push_back( new Rotate( x, y, 0, -0.8, (q+base) % 360, 55, new Rotate_WHull( dam, collide->copy() ), alignment ) );

}


WeaponObject * WeaponRotateGun::copy() {
	return new WeaponRotateGun( strength, dir, smp, alignment );
}
