#include "gun_massive.h"
#include "trigtable.h"
#include "gunobj.h"
#include "allegro.h"
#include "hull_weapon_massive.h"
#include "weaponobj.h"
#include "weapon_damage.h"
#include "weapon_massive.h"
#include "spaceobj.h"
#include "ebox.h"
#include "defs.h"
#include <vector>

using namespace std;

WeaponMassiveGun::WeaponMassiveGun( int z, int d, SAMPLE * smp, int al ):
WeaponObject( d, "Massive Gun", 43000, al, z, 0 ),
rising( 0 ) {

	BITMAP * dopey = create_bitmap( 16, 16 );
	clear_to_color( dopey, makecol(255,0,255) );
	circlefill(dopey,8,8,8,makecol(20,0,0) );
	diss_collide = new ECollide( dopey,4,makecol(255,0,255),52);
	destroy_bitmap( dopey );
	ang = 0;

}


WeaponObject * WeaponMassiveGun::copy() {
	return new WeaponMassiveGun( strength, dir, smp, alignment );
}


WeaponMassiveGun::~WeaponMassiveGun() {
	delete diss_collide;
}


void WeaponMassiveGun::MakeShot(int x, int y, vector< SpaceObject * > * Ammo, vector< SpaceObject * > * fight ) {

	shot_counter = 0;
	if ( rising < 200 )
		rising++;
	ang = (ang + 13 ) % 360;

	if ( rising/20 >= 1 ) {
		Ammo->push_back( new Damage_Weapon((int)(x+tcos[ang]*50),(int)(y+tsine[ang]*50),0,0,1,new Massive_WHull(rising/20,USE_AMMO,diss_collide), alignment ) );
		Ammo->push_back( new Damage_Weapon((int)(x+tcos[(ang+120)%360]*50),(int)(y+tsine[(ang+120)%360]*50),0,0,1,new Massive_WHull(rising/20,USE_AMMO,diss_collide), alignment ) );
		Ammo->push_back( new Damage_Weapon((int)(x+tcos[(ang+240)%360]*50),(int)(y+tsine[(ang+240)%360]*50),0,0,1,new Massive_WHull(rising/20,USE_AMMO,diss_collide), alignment ) );
	}

}


void WeaponMassiveGun::Idle( int x, int y, vector< SpaceObject * > * Ammo, vector< SpaceObject * > * fight ) {
	if ( rising == 0 ) return;
	if ( rising/20 >= 1 ) {
		Ammo->push_back( new Massive_Weapon((int)(x+tcos[ang]*50),(int)(y+tsine[ang]*50),tcos[(ang+90)%360]*2.0,tsine[(ang+90)%360]*2.0,new Massive_WHull(rising/20,USE_AMMO,diss_collide), alignment ) );
		Ammo->push_back( new Massive_Weapon((int)(x+tcos[(ang+120)%360]*50),(int)(y+tsine[(ang+120)%360]*50),tcos[(ang+90+120)%360]*2.0,tsine[(ang+90+120)%360]*2.0,new Massive_WHull(rising/20,USE_AMMO,diss_collide), alignment ) );
		Ammo->push_back( new Massive_Weapon((int)(x+tcos[(ang+240)%360]*50),(int)(y+tsine[(ang+240)%360]*50),tcos[(ang+90+240)%360]*2.0,tsine[(ang+90+240)%360]*2.0,new Massive_WHull(rising/20,USE_AMMO,diss_collide), alignment ) );
	}
	ang = 0;
	rising = 0;
}
