#include "group.h"
#include "spaceobj.h"
#include <vector>

using namespace std;

/* Group:
 * Creates a new group with a y coordinate to be used for knowing when to
 * put the group into the game.
 */
Group::Group( int _y ):
y( _y ) {

	list = new vector< SpaceObject * >;

}

/* pos:
 * Returns the y coordinate of the group
 */
int Group::pos() {
	return y;
}

/* add:
 * Adds another spaceobject to this group
 */
void Group::add( SpaceObject * who ) {
	list->push_back( who );
}


/* drop:
 * Removes a spaceobject from this group if it exists
 */
void Group::drop( SpaceObject * who ) {
	for ( vector< SpaceObject *>::iterator it = list->begin(); it != list->end(); )
	if ( *it == who ) {
		it = list->erase( it );
		return;
	} else it++;
}

/* size:
 * Returns number of spaceobjects currently stored in this group
 */
int Group::size() {
	return list->size();
}


/* members:
 * Returns a list of the objects that this group stores
 */
vector< class SpaceObject * > * Group::members() {
	return list;
}

/* ~Group:
 * Destructor. Deletes all objects stored in this group.
 */
Group::~Group() {
	//list->clear();
	for ( vector< SpaceObject * >::iterator it = list->begin(); it != list->end(); ){
		SpaceObject * del = *it;
		del->Independent();
		it = list->erase( it );
		delete del;
	}
	delete list;
}

