% Generated by roxygen2 (4.0.1): do not edit by hand
\name{importCiphergenXml}
\alias{importCiphergenXml}
\title{Import Ciphergen XML files}
\usage{
importCiphergenXml(path, ...)
}
\arguments{
\item{path}{\code{character}, path to directory or file which should be read
in.}

\item{\ldots}{arguments to be passed to
\code{\link[MALDIquantForeign]{import}}.}
}
\value{
a \code{list} of \code{\link[MALDIquant]{MassSpectrum-class}} or
\code{\link[MALDIquant]{MassPeaks-class}} objects (depending on the
\code{centroided} argument).
}
\description{
This function imports files in Ciphergen XML file format
into \code{\link[MALDIquant]{MassSpectrum-class}} or
\code{\link[MALDIquant]{MassPeaks-class}} objects.
}
\examples{
library("MALDIquant")
library("MALDIquantForeign")

## get example directory
exampleDirectory <- system.file("exampledata", package="MALDIquantForeign")

## import
s <- importCiphergenXml(exampleDirectory)
}
\author{
Sebastian Gibb
}
\references{
\url{http://strimmerlab.org/software/maldiquant/}
}
\seealso{
\code{\link[MALDIquant]{MassSpectrum-class}},
\code{\link[MALDIquant]{MassPeaks-class}}
}

