# Copyright (C) 2003-2006 Kouichirou Eto, All rights reserved.
# This is free software with ABSOLUTELY NO WARRANTY.
# You can redistribute it and/or modify it under the terms of the GNU GPL 2.

$LOAD_PATH << '..' unless $LOAD_PATH.include? '..'
require 'qwik/util-pathname'

class JavaScriptCompressor
  def self.run
    generate_src
  end

  def self.generate_src
    src = <<'EOT'
//
// Copyright (C) 2003-2006 Kouichirou Eto
//     All rights reserved.
//     This is free software with ABSOLUTELY NO WARRANTY.
//
// You can redistribute it and/or modify it under the terms of 
// the GNU General Public License version 2.
//

// This file is automatically generated.
// PLEASE DO NOT EDIT THIS FILE.
EOT
   #add_all_js(src)
    add_some_js(src)
    '../all.js'.path.open('wb') {|f|
      f.puts src
    }
  end

  def self.add_some_js(src)
    path = '.'.path
   #ar = %w(base history monitor niftypp wysiwyg)
    ar = %w(base niftypp)
    ar.each {|f|
      pa = path+(f+'.js')
      src << read_file(pa)
    }
  end

  def self.add_all_js(src)
    path = '.'.path
    path.each_entry {|file|
      f = file.to_s
      next unless /\.js\z/ =~ f
      src << read_file(file)
    }
  end

  def self.read_file(file)
    s = ''
    file.open {|f|
      while line = f.gets
	line.sub!(/\/\/.+$/, "")
	case line
	when /\A\/\//, /\A\s*$/
	  # do nothing
	else
	  s << line
	end
      end
      f.read
    }
    s
  end
end

if $0 == __FILE__
  JavaScriptCompressor.run
end
