/***************************************************************************
 *   Copyright (C) 2009 by fra74   *
 *   francesco.b74@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef SCHEDALISTATRENI_H
#define SCHEDALISTATRENI_H

#include <schedaviaggiatreno.h>

class QViaggiaTreno;
class WidgetListaTreni;

namespace Lista
{
	enum Dati {dtCategoria, dtOrigine, dtDestinazione, dtUltimaFermata, dtOrarioFermataProgrammato, dtOrarioFermataEffettivo,
			   dtUltimoRilevamento, dtOrarioTransito, dtRitardoTransito, dtPartenzaProgrammata, dtPartenzaEffettiva,
			   dtArrivoProgrammato, dtArrivoEffettivo};

	enum {rigaNumero = 0, rigaCategoria, rigaStato, rigaOrigine, rigaPartenzaProgrammata, rigaPartenzaEffettiva,
	  rigaDestinazione, rigaArrivoProgrammato, rigaArrivoEffettivo, rigaUltimaFermata, rigaOrarioFermataProgrammato,
	  rigaOrarioFermataEffettivo, rigaUltimoRilevamento, rigaOrarioTransito, rigaRitardoTransito,  rigaUltima = rigaRitardoTransito};

//questa classe memorizza i dati di ogni singolo treno della lista di treni
class DatiTreno
{
public:
	DatiTreno(const QString& numero);

	void cancella();

	void impostaDato(Dati tipoDato, const QString& valore) {m_dati[tipoDato] = valore; }
	QString dato(Dati tipoDato) const {return m_dati[tipoDato]; }

	StatoTreno statoTreno() const {return m_stato;}
	void impostaStatoTreno(StatoTreno stato) {m_stato = stato;}
	QString stringaStatoTreno() const;

	QString numero() const {return m_numero;}
	void impostaNumero(const QString& numero) {m_numero = numero;}

private:
	QString m_numero;
	QMap<Dati, QString> m_dati;

	StatoTreno m_stato;


};
};


class SchedaListaTreni: public SchedaViaggiaTreno
{
	Q_OBJECT

public:
	SchedaListaTreni(QViaggiaTreno* parent, const unsigned int intervalloStandard = 3);

	virtual void avvia();
	virtual void ferma();
	virtual void aggiorna();
	virtual QString titolo(bool = false) const;
	void impostaTitolo();

	bool modificata() const {return m_modificata; }
	int numeroTreni() const {return m_listatreni.count();}

	void apriFile(const QString& filename);

	virtual void salvaScheda(QSettings& settings);

public slots:
	void apri();
	void salva();
	void salvaConNome();
	void aggiungiTreni();
	void rimuoviTreni();
	void rimuoviTuttiITreni();

protected slots:
	virtual void downloadFinito(QNetworkReply* risposta);

private:
	static int s_count;

	WidgetListaTreni* m_widget;

	bool m_modificata;
	QString m_titoloLista;
	QString m_nomefile;
	QDomDocument m_dom;

	QMap<QString, Lista::DatiTreno*> m_listatreni;
	QQueue<QString> m_codatreni;
	QString m_trenoAttuale;

private:
	void aggiungiTreno(const QString& numero);
	void rimuoviTreno(const QString& numero);

	void prossimoTreno();
	void analizzaRispostaVT(const QString& risposta, Lista::DatiTreno *treno);

	void salvaFile(const QString& filename);


};

class TabellaLista;
class WidgetListaTreni: public QWidget
{
	Q_OBJECT


public:
	WidgetListaTreni(SchedaListaTreni *parent);
	void aggiungiTreno(Lista::DatiTreno *treno);
	void rimuoviTreno(const QString& treno);
	void ridimensionaColonne();
	void impostaTitolo(const QString& titolo);
	void aggiornaTreno(const Lista::DatiTreno* treno);
	void impostaAggiornamento(const QString& testo);

	void rimuoviTuttiITreni();


private:
	TabellaLista* m_tabella;
	QLabel *m_labelTitolo, *m_labelAggiornamento;
	void impostaCella(int riga, int colonna, const QString& testo);
	int larghezzaItem(const QTableWidgetItem* item);


private slots:
	void itemAttivato(QTableWidgetItem* item);

signals:
	void apriSchedaStazione(const QString& stazione);
	void apriSchedaTreno(const QString& treno);
};

class DialogoAggiuntaTreni : public QDialog
{
	Q_OBJECT

	public:
	DialogoAggiuntaTreni(QWidget* parent);
	bool listaVuota() const;
	QStringList listaTreni() const;

	private:
	QListWidget *m_listwidget;
	QLineEdit * m_lineedit;

	private slots:
	void aggiungiTreno();
};

class DialogoRimozioneTreni: public QDialog
{
	Q_OBJECT

	public:
	DialogoRimozioneTreni(const QStringList& lista, QWidget* parent);
	bool listaVuota() const;
	QStringList listaTreni() const;

	private:
	QListWidget *m_listwidget;
	QDialogButtonBox *m_buttonBox;

	private slots:
	void selezioneModificata();
};

class TabellaLista : public QTableWidget
{
Q_OBJECT

public:
	TabellaLista(QWidget* parent);

	void mouseMoveEvent(QMouseEvent *event);
};


#endif // SCHEDALISTATRENI_H
