/***************************************************************************
                          oilpaintingdialog.cpp  -  description
                             -------------------
    begin                : Wed Mar 6 2002
    copyright            : (C) 2002 by Michael Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/******************************************************************************
 * The algorithm used in this class is based on the Gimp 1.2.0                *
 * Original filename: effect.c                                                *
 * Original copyright message:                                                *
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%                                                                             %
%                                                                             %
%                   EEEEE  FFFFF  FFFFF  EEEEE  CCCC  TTTTT                   %
%                   E      F      F      E     C        T                     %
%                   EEE    FFF    FFF    EEE   C        T                     %
%                   E      F      F      E     C        T                     %
%                   EEEEE  F      F      EEEEE  CCCC    T                     %
%                                                                             %
%                                                                             %
%                      ImageMagick Image Effects Methods                      %
%                                                                             %
%                                                                             %
%                               Software Design                               %
%                                 John Cristy                                 %
%                                 October 1996                                %
%                                                                             %
%                                                                             %
%  Copyright (C) 2001 ImageMagick Studio, a non-profit organization dedicated %
%  to making software imaging solutions freely available.                     %
%                                                                             %
%  Permission is hereby granted, free of charge, to any person obtaining a    %
%  copy of this software and associated documentation files ("ImageMagick"),  %
%  to deal in ImageMagick without restriction, including without limitation   %
%  the rights to use, copy, modify, merge, publish, distribute, sublicense,   %
%  and/or sell copies of ImageMagick, and to permit persons to whom the       %
%  ImageMagick is furnished to do so, subject to the following conditions:    %
%                                                                             %
%  The above copyright notice and this permission notice shall be included in %
%  all copies or substantial portions of ImageMagick.                         %
%                                                                             %
%  The software is provided "as is", without warranty of any kind, express or %
%  implied, including but not limited to the warranties of merchantability,   %
%  fitness for a particular purpose and noninfringement.  In no event shall   %
%  ImageMagick Studio be liable for any claim, damages or other liability,    %
%  whether in an action of contract, tort or otherwise, arising from, out of  %
%  or in connection with ImageMagick or the use or other dealings in          %
%  ImageMagick.                                                               %
%                                                                             %
%  Except as contained in this notice, the name of the ImageMagick Studio     %
%  shall not be used in advertising or otherwise to promote the sale, use or  %
%  other dealings in ImageMagick without prior written authorization from the %
%  ImageMagick Studio.                                                        %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

#include "oilpaintingdialog.h"
#include "quiteinsane/qxmlconfig.h"
#include "quiteinsane/sliderspin.h"

#include <math.h>

#include <qapplication.h>
#include <qhbox.h>
#include <qimage.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qnamespace.h>
#include <qslider.h>
#include <qspinbox.h>
#include <qvbox.h>

OilPaintingDialog::OilPaintingDialog(int preview_size,QImage* image,QWidget* parent)
                  :ImageFilterDialog(preview_size,image,parent)
{
  initControls();
}
OilPaintingDialog::~OilPaintingDialog()
{
}
/** No descriptions */
void OilPaintingDialog::initControls()
{
  int radius = xmlConfig->intValue("FILTER_OILPAINTING_RADIUS",3);
  bool c_up = xmlConfig->boolValue("FILTER_OILPAINTING_CONTINOUS_UPDATE",false);
  QVBox* vb = controlsVBox();
  if(!vb)
    return;
  setTitle(tr("Oil Painting"));
  setCaption(tr("Oil Painting"));
  //radius
  QHBox* hb = new QHBox(vb);
  hb->setSpacing(3);
  mpSliderSpin = new SliderSpin(2,20,radius,tr("Radius"),hb);
  mpSliderSpin->setMinimumWidth(150);
  //dummy
  QWidget* dummy = new QWidget(vb);
  vb->setStretchFactor(dummy,1);

  connect(mpSliderSpin,SIGNAL(signalValueChanged(int)),
          this,SLOT(slotRadiusChanged(int)));
  slotRadiusChanged(radius);
  setContinousUpdate(c_up);
  setFixedSize(minimumSizeHint());
}
/** No descriptions */
bool OilPaintingDialog::apply(QImage* image,bool emit_progress)
{
  int imwidth;
  int count,j,k,width,y;
  int i,x;

  QRgb* p;
  QRgb* q;
  QRgb* s;

  unsigned int *histogram;
  int depth;

  QImage im;
  depth = image->depth();
  if(depth < 32)
    *image = image->convertDepth(32);

  im = image->copy();

  if(im.isNull())
    return false;

  /*
    Initialize painted image attributes.
  */
  width=mpSliderSpin->value();
  imwidth = image->width();
  /*
    Allocate histogram and scanline.
  */
  histogram= new (unsigned int) [(255+1)*sizeof(unsigned int)];
  if (histogram == (unsigned int *) NULL)
  {
    return false;
  }
  int progress,progresscnt;
  int old_p = 0;

  progress = (im.height()-width-1) - width;
  progresscnt = 0;

  /*
    Paint each row of the image.
  */
  k=0;
  for(y=width;y<int(im.height()-width-1); y++)
  {
    p= (QRgb*)image->scanLine(y-width);
    q= (QRgb*)im.scanLine(y);
    if ((p == 0) || (q == 0))
    {
      delete [] histogram;
      return false;
    }
    p+=width*imwidth+width;
    q+=width;
    for(x=width;x<int(imwidth-width-1);x++)
    {
      /*
        Determine most frequent color.
      */
      count=0;
      memset(histogram,0,256 * sizeof(unsigned int));
      for (i=0; i < (int) width; i++)
      {
        s=p-(width-i)*imwidth-i-1;
        for (j=0; j < (2*i+1); j++)
        {
          k = (unsigned int) ((qRed(*s)*77+qGreen(*s)*150+qBlue(*s)*29) >> 8);
          histogram[k]++;
          if ((int) histogram[k] > count)
          {
            *q=(*s);
            count=histogram[k];
          }
          s++;
        }
        s=p+(width-i)*imwidth-i-1;
        for (j=0; j < (2*i+1); j++)
        {
          k = (unsigned int) ((qRed(*s)*77+qGreen(*s)*150+qBlue(*s)*29) >> 8);
          histogram[k]++;
          if ((int) histogram[k] > count)
          {
            *q=(*s);
            count=histogram[k];
          }
          s++;
        }
      }
      s=p-width;
      for (j=0; j < (int) (width+width+1); j++)
      {
        k = (unsigned int) ((qRed(*s)*77+qGreen(*s)*150+qBlue(*s)*29) >> 8);
        histogram[k]++;
        if ((int) histogram[k] > count)
        {
          *q=*s;
          count=histogram[k];
        }
        s++;
      }
      p++;
      q++;
    }
    if(emit_progress)
    {
      if(stopped())
      {
        delete [] histogram;
        return false;
      }
      ++progresscnt;
      int pro = int(100.0*double(progresscnt)/double(progress));
      if(((pro % 10) == 0) && (pro > old_p))
      {
        old_p = pro;
        emit signalFilterProgress(pro);
        qApp->processEvents();
      }
    }
  }
  delete [] histogram;
  if(depth != im.depth())
    im = im.convertDepth(depth);
  *image = im;
  return true;
}
/**  */
void OilPaintingDialog::slotRadiusChanged(int)
{
  updatePreview();
}
/** No descriptions */
void OilPaintingDialog::saveConfig()
{
  xmlConfig->setIntValue("FILTER_OILPAINTING_RADIUS",
                         mpSliderSpin->value());
  xmlConfig->setBoolValue("FILTER_OILPAINTING_CONTINOUS_UPDATE",
                          continousUpdate());
}
