/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt Mobility Components.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QVCARDRESTOREHANDLER_P_H
#define QVCARDRESTOREHANDLER_P_H

#include "qmobilityglobal.h"
#include "qlatin1constant.h"
#include "qcontactdetail.h"

QTM_BEGIN_NAMESPACE
class QVersitProperty;

// This is a map from Versit group names to the details that were generated from properties with the
// said groups.  Multiple details can be associated with a single group.
class DetailGroupMap
{
public:
    QList<QContactDetail> detailsInGroup(const QString& groupName) const;
    void insert(const QString& groupName, const QContactDetail& detail);
    void update(const QContactDetail& detail);
    void clear();

private:
    QHash<int, QString> mDetailGroupName; // detailid -> group name
    QHash<int, QContactDetail> mDetailById; // detailid -> detail
};

class QVCardRestoreHandler
{
public:
    bool propertyProcessed(const QVersitProperty& property,
                           QList<QContactDetail>* updatedDetails);
    void documentProcessed();

    Q_DECLARE_LATIN1_CONSTANT(PropertyName, "X-NOKIA-QCONTACTFIELD");
    Q_DECLARE_LATIN1_CONSTANT(DetailDefinitionParameter, "DETAIL");
    Q_DECLARE_LATIN1_CONSTANT(FieldParameter, "FIELD");
    Q_DECLARE_LATIN1_CONSTANT(DatatypeParameter, "DATATYPE");
    Q_DECLARE_LATIN1_CONSTANT(DatatypeParameterVariant, "VARIANT");
    Q_DECLARE_LATIN1_CONSTANT(DatatypeParameterDate, "DATE");
    Q_DECLARE_LATIN1_CONSTANT(DatatypeParameterDateTime, "DATETIME");
    Q_DECLARE_LATIN1_CONSTANT(DatatypeParameterTime, "TIME");
    Q_DECLARE_LATIN1_CONSTANT(DatatypeParameterBool, "BOOL");
    Q_DECLARE_LATIN1_CONSTANT(DatatypeParameterInt, "INT");
    Q_DECLARE_LATIN1_CONSTANT(DatatypeParameterUInt, "UINT");
    Q_DECLARE_LATIN1_CONSTANT(DatatypeParameterUrl, "URL");
    Q_DECLARE_LATIN1_CONSTANT(GroupPrefix, "G");

private:
    static QVariant deserializeValue(const QVersitProperty& property);
    DetailGroupMap mDetailGroupMap; // remembers which details came from which groups
};

QTM_END_NAMESPACE

#endif
